/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.validator.ddl.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.exception.ShardingSphereException;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.sharding.route.engine.validator.ddl.ShardingDDLStatementValidator;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sql.parser.sql.common.extractor.TableExtractor;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.AggregationProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.CreateViewStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.dml.SelectStatementHandler;

public final class ShardingCreateViewStatementValidator
extends ShardingDDLStatementValidator<CreateViewStatement> {
    @Override
    public void preValidate(ShardingRule shardingRule, SQLStatementContext<CreateViewStatement> sqlStatementContext, List<Object> parameters, ShardingSphereDatabase database) {
        Optional selectStatement = ((CreateViewStatement)sqlStatementContext.getSqlStatement()).getSelect();
        if (!selectStatement.isPresent()) {
            return;
        }
        if (this.isShardingTablesWithoutBinding(shardingRule, sqlStatementContext, (SelectStatement)selectStatement.get())) {
            throw new ShardingSphereException("View name has to bind to sharding tables!", new Object[0]);
        }
    }

    @Override
    public void postValidate(ShardingRule shardingRule, SQLStatementContext<CreateViewStatement> sqlStatementContext, List<Object> parameters, ShardingSphereDatabase database, ConfigurationProperties props, RouteContext routeContext) {
        Optional selectStatement = ((CreateViewStatement)sqlStatementContext.getSqlStatement()).getSelect();
        if (!selectStatement.isPresent()) {
            return;
        }
        if (this.isContainsNotSupportedViewStatement((SelectStatement)selectStatement.get(), routeContext)) {
            throw new ShardingSphereException("This view statement contains not supported query statement!", new Object[0]);
        }
    }

    private boolean isShardingTablesWithoutBinding(ShardingRule shardingRule, SQLStatementContext<CreateViewStatement> sqlStatementContext, SelectStatement selectStatement) {
        TableExtractor extractor = new TableExtractor();
        extractor.extractTablesFromSelect(selectStatement);
        Collection tableSegments = extractor.getRewriteTables();
        for (SimpleTableSegment each : tableSegments) {
            String logicTable = each.getTableName().getIdentifier().getValue();
            if (!shardingRule.isShardingTable(logicTable) || this.isBindingTables(shardingRule, ((CreateViewStatement)sqlStatementContext.getSqlStatement()).getView().getTableName().getIdentifier().getValue(), logicTable)) continue;
            return true;
        }
        return false;
    }

    private boolean isBindingTables(ShardingRule shardingRule, String logicViewName, String logicTable) {
        List<String> bindTables = Arrays.asList(logicTable, logicViewName);
        return shardingRule.isAllBindingTables(bindTables);
    }

    private boolean isContainsNotSupportedViewStatement(SelectStatement selectStatement, RouteContext routeContext) {
        if (routeContext.getRouteUnits().size() <= 1) {
            return false;
        }
        return this.hasGroupBy(selectStatement) || this.hasAggregation(selectStatement) || this.hasDistinct(selectStatement) || this.hasLimit(selectStatement);
    }

    private boolean hasGroupBy(SelectStatement selectStatement) {
        return selectStatement.getGroupBy().map(groupBySegment -> !groupBySegment.getGroupByItems().isEmpty()).orElse(false);
    }

    private boolean hasAggregation(SelectStatement selectStatement) {
        for (ProjectionSegment each : selectStatement.getProjections().getProjections()) {
            if (!(each instanceof AggregationProjectionSegment)) continue;
            return true;
        }
        return false;
    }

    private boolean hasDistinct(SelectStatement selectStatement) {
        return selectStatement.getProjections().isDistinctRow();
    }

    private boolean hasLimit(SelectStatement selectStatement) {
        return SelectStatementHandler.getLimitSegment((SelectStatement)selectStatement).isPresent();
    }
}

