/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.validator.ddl.impl;

import java.util.Collections;
import java.util.List;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.exception.ShardingSphereException;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.sharding.route.engine.validator.ddl.ShardingDDLStatementValidator;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.CreateTableStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.ddl.CreateTableStatementHandler;

public final class ShardingCreateTableStatementValidator
extends ShardingDDLStatementValidator<CreateTableStatement> {
    @Override
    public void preValidate(ShardingRule shardingRule, SQLStatementContext<CreateTableStatement> sqlStatementContext, List<Object> parameters, ShardingSphereDatabase database) {
        if (!CreateTableStatementHandler.containsNotExistClause((CreateTableStatement)((CreateTableStatement)sqlStatementContext.getSqlStatement()))) {
            String defaultSchemaName = DatabaseTypeEngine.getDefaultSchemaName((DatabaseType)sqlStatementContext.getDatabaseType(), (String)database.getName());
            ShardingSphereSchema schema = sqlStatementContext.getTablesContext().getSchemaName().map(optional -> (ShardingSphereSchema)database.getSchemas().get(optional)).orElseGet(() -> (ShardingSphereSchema)database.getSchemas().get(defaultSchemaName));
            this.validateTableNotExist(schema, Collections.singletonList(((CreateTableStatement)sqlStatementContext.getSqlStatement()).getTable()));
        }
    }

    @Override
    public void postValidate(ShardingRule shardingRule, SQLStatementContext<CreateTableStatement> sqlStatementContext, List<Object> parameters, ShardingSphereDatabase database, ConfigurationProperties props, RouteContext routeContext) {
        String primaryTable = ((CreateTableStatement)sqlStatementContext.getSqlStatement()).getTable().getTableName().getIdentifier().getValue();
        if (this.isRouteUnitDataNodeDifferentSize(shardingRule, routeContext, primaryTable)) {
            throw new ShardingSphereException("CREATE TABLE ... statement can not route correctly for tables %s.", new Object[]{sqlStatementContext.getTablesContext().getTableNames()});
        }
    }
}

