/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.validator.ddl.impl;

import java.util.Collections;
import java.util.List;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.type.IndexAvailable;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.exception.ShardingSphereException;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.sharding.route.engine.validator.ddl.ShardingDDLStatementValidator;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.CreateIndexStatement;

public final class ShardingCreateIndexStatementValidator
extends ShardingDDLStatementValidator<CreateIndexStatement> {
    @Override
    public void preValidate(ShardingRule shardingRule, SQLStatementContext<CreateIndexStatement> sqlStatementContext, List<Object> parameters, ShardingSphereDatabase database) {
        String defaultSchemaName = DatabaseTypeEngine.getDefaultSchemaName((DatabaseType)sqlStatementContext.getDatabaseType(), (String)database.getName());
        ShardingSphereSchema schema = sqlStatementContext.getTablesContext().getSchemaName().map(optional -> (ShardingSphereSchema)database.getSchemas().get(optional)).orElseGet(() -> (ShardingSphereSchema)database.getSchemas().get(defaultSchemaName));
        this.validateTableExist(schema, Collections.singletonList(((CreateIndexStatement)sqlStatementContext.getSqlStatement()).getTable()));
        String tableName = ((CreateIndexStatement)sqlStatementContext.getSqlStatement()).getTable().getTableName().getIdentifier().getValue();
        String indexName = ((IndexAvailable)sqlStatementContext).getIndexes().stream().map(each -> each.getIndexName().getIdentifier().getValue()).findFirst().orElse(null);
        if (schema.get(tableName).getIndexes().containsKey(indexName)) {
            throw new ShardingSphereException("Index '%s' already exists.", new Object[]{indexName});
        }
    }

    @Override
    public void postValidate(ShardingRule shardingRule, SQLStatementContext<CreateIndexStatement> sqlStatementContext, List<Object> parameters, ShardingSphereDatabase database, ConfigurationProperties props, RouteContext routeContext) {
    }
}

