/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.rewrite.token.pojo;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.RouteUnitAware;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.SQLToken;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.Substitutable;
import org.apache.shardingsphere.infra.route.context.RouteMapper;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;

public final class CursorToken
extends SQLToken
implements Substitutable,
RouteUnitAware {
    private final int stopIndex;
    private final IdentifierValue identifier;
    private final SQLStatementContext<?> sqlStatementContext;
    private final ShardingRule shardingRule;

    public CursorToken(int startIndex, int stopIndex, IdentifierValue identifier, SQLStatementContext<?> sqlStatementContext, ShardingRule shardingRule) {
        super(startIndex);
        this.stopIndex = stopIndex;
        this.identifier = identifier;
        this.sqlStatementContext = sqlStatementContext;
        this.shardingRule = shardingRule;
    }

    public String toString(RouteUnit routeUnit) {
        return this.identifier.getQuoteCharacter().wrap(this.getCursorValue(routeUnit));
    }

    private String getCursorValue(RouteUnit routeUnit) {
        Map<String, String> logicAndActualTables = this.getLogicAndActualTables(routeUnit);
        String actualTableName = logicAndActualTables.isEmpty() ? null : logicAndActualTables.values().iterator().next();
        return Strings.isNullOrEmpty(actualTableName) ? this.identifier.getValue() : this.identifier.getValue() + "_" + actualTableName;
    }

    private Map<String, String> getLogicAndActualTables(RouteUnit routeUnit) {
        Collection tableNames = this.sqlStatementContext.getTablesContext().getTableNames();
        HashMap<String, String> result = new HashMap<String, String>(tableNames.size(), 1.0f);
        for (RouteMapper each : routeUnit.getTableMappers()) {
            result.put(each.getLogicName().toLowerCase(), each.getActualName());
            result.putAll(this.shardingRule.getLogicAndActualTablesFromBindingTable(routeUnit.getDataSourceMapper().getLogicName(), each.getLogicName(), each.getActualName(), tableNames));
        }
        return result;
    }

    @Generated
    public int getStopIndex() {
        return this.stopIndex;
    }
}

