/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.metadata;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.exception.ShardingSphereException;
import org.apache.shardingsphere.infra.metadata.database.schema.builder.GenericSchemaBuilderMaterials;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.spi.RuleBasedSchemaMetaDataDecorator;
import org.apache.shardingsphere.infra.metadata.database.schema.loader.model.ColumnMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.loader.model.ConstraintMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.loader.model.IndexMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.loader.model.SchemaMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.loader.model.TableMetaData;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sharding.rule.TableRule;

public final class ShardingSchemaMetaDataDecorator
implements RuleBasedSchemaMetaDataDecorator<ShardingRule> {
    public Map<String, SchemaMetaData> decorate(Map<String, SchemaMetaData> schemaMetaDataMap, ShardingRule rule, GenericSchemaBuilderMaterials materials) {
        LinkedHashMap<String, SchemaMetaData> result = new LinkedHashMap<String, SchemaMetaData>(schemaMetaDataMap.size(), 1.0f);
        boolean isCheckingMetaData = (Boolean)materials.getProps().getValue((Enum)ConfigurationPropertyKey.CHECK_TABLE_METADATA_ENABLED);
        for (Map.Entry<String, SchemaMetaData> entry : schemaMetaDataMap.entrySet()) {
            LinkedList<TableMetaData> tables = new LinkedList<TableMetaData>();
            for (Map.Entry<String, Collection<TableMetaData>> tableEntry : this.getLogicTableMetaDataMap(entry.getValue(), rule).entrySet()) {
                if (isCheckingMetaData) {
                    this.checkUniformed(tableEntry.getKey(), tableEntry.getValue());
                }
                tables.add(tableEntry.getValue().iterator().next());
            }
            result.put(entry.getKey(), new SchemaMetaData(entry.getKey(), tables));
        }
        return result;
    }

    private TableMetaData decorate(TableMetaData tableMetaData, ShardingRule rule) {
        return rule.findTableRuleByActualTable(tableMetaData.getName()).map(optional -> this.createTableMetaData(rule, (TableRule)optional, tableMetaData)).orElse(tableMetaData);
    }

    private TableMetaData createTableMetaData(ShardingRule rule, TableRule tableRule, TableMetaData tableMetaData) {
        Collection<ColumnMetaData> columnMetaDataList = this.getColumnMetaDataList(tableMetaData, tableRule);
        Collection<IndexMetaData> indexMetaDataList = this.getIndexMetaDataList(tableMetaData, tableRule);
        Collection<ConstraintMetaData> constraintMetaDataList = this.getConstraintMetaDataList(tableMetaData, rule, tableRule);
        return new TableMetaData(tableRule.getLogicTable(), columnMetaDataList, indexMetaDataList, constraintMetaDataList);
    }

    private Map<String, Collection<TableMetaData>> getLogicTableMetaDataMap(SchemaMetaData schemaMetaData, ShardingRule rule) {
        LinkedHashMap<String, Collection<TableMetaData>> result = new LinkedHashMap<String, Collection<TableMetaData>>();
        for (TableMetaData each : schemaMetaData.getTables()) {
            String logicTableName = rule.findLogicTableByActualTable(each.getName()).orElse(each.getName());
            Collection tableMetaDataList = result.computeIfAbsent(logicTableName, key -> new LinkedList());
            tableMetaDataList.add(this.decorate(each, rule));
        }
        return result;
    }

    private void checkUniformed(String logicTableName, Collection<TableMetaData> tableMetaDataList) {
        TableMetaData sample = tableMetaDataList.iterator().next();
        Collection violations = tableMetaDataList.stream().filter(each -> !sample.equals(each)).map(each -> new TableMetaDataViolation(each.getName(), (TableMetaData)each)).collect(Collectors.toList());
        this.throwExceptionIfNecessary(violations, logicTableName);
    }

    private void throwExceptionIfNecessary(Collection<TableMetaDataViolation> violations, String logicTableName) {
        if (!violations.isEmpty()) {
            StringBuilder errorMessage = new StringBuilder("Cannot get uniformed table structure for logic table `%s`, it has different meta data of actual tables are as follows:").append(System.lineSeparator());
            for (TableMetaDataViolation each : violations) {
                errorMessage.append("actual table: ").append(each.getActualTableName()).append(", meta data: ").append(each.getTableMetaData()).append(System.lineSeparator());
            }
            throw new ShardingSphereException(errorMessage.toString(), new Object[]{logicTableName});
        }
    }

    private Collection<ColumnMetaData> getColumnMetaDataList(TableMetaData tableMetaData, TableRule tableRule) {
        LinkedList<ColumnMetaData> result = new LinkedList<ColumnMetaData>();
        for (ColumnMetaData each : tableMetaData.getColumns()) {
            boolean generated = each.getName().equalsIgnoreCase(tableRule.getGenerateKeyColumn().orElse(null));
            result.add(new ColumnMetaData(each.getName(), each.getDataType(), each.isPrimaryKey(), generated, each.isCaseSensitive()));
        }
        return result;
    }

    private Collection<IndexMetaData> getIndexMetaDataList(TableMetaData tableMetaData, TableRule tableRule) {
        HashSet<IndexMetaData> result = new HashSet<IndexMetaData>();
        for (IndexMetaData each : tableMetaData.getIndexes()) {
            for (DataNode dataNode : tableRule.getActualDataNodes()) {
                this.getLogicIndex(each.getName(), dataNode.getTableName()).ifPresent(optional -> result.add(new IndexMetaData(optional)));
            }
        }
        return result;
    }

    private Collection<ConstraintMetaData> getConstraintMetaDataList(TableMetaData tableMetaData, ShardingRule shardingRule, TableRule tableRule) {
        HashSet<ConstraintMetaData> result = new HashSet<ConstraintMetaData>();
        for (ConstraintMetaData each : tableMetaData.getConstrains()) {
            for (DataNode dataNode : tableRule.getActualDataNodes()) {
                String referencedTableName = each.getReferencedTableName();
                this.getLogicIndex(each.getName(), dataNode.getTableName()).ifPresent(optional -> result.add(new ConstraintMetaData(optional, shardingRule.findLogicTableByActualTable(referencedTableName).orElse(referencedTableName))));
            }
        }
        return result;
    }

    private Optional<String> getLogicIndex(String actualIndexName, String actualTableName) {
        String indexNameSuffix = "_" + actualTableName;
        return actualIndexName.endsWith(indexNameSuffix) ? Optional.of(actualIndexName.replace(indexNameSuffix, "")) : Optional.empty();
    }

    public int getOrder() {
        return -10;
    }

    public Class<ShardingRule> getTypeClass() {
        return ShardingRule.class;
    }

    private static final class TableMetaDataViolation {
        private final String actualTableName;
        private final TableMetaData tableMetaData;

        @Generated
        public TableMetaDataViolation(String actualTableName, TableMetaData tableMetaData) {
            this.actualTableName = actualTableName;
            this.tableMetaData = tableMetaData;
        }

        @Generated
        public String getActualTableName() {
            return this.actualTableName;
        }

        @Generated
        public TableMetaData getTableMetaData() {
            return this.tableMetaData;
        }
    }
}

