/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.merge.ddl.fetch;

import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import org.apache.shardingsphere.infra.binder.segment.select.orderby.OrderByItem;
import org.apache.shardingsphere.infra.binder.statement.ddl.FetchStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.merge.result.impl.stream.StreamMergedResult;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereSchema;
import org.apache.shardingsphere.sharding.merge.ddl.fetch.FetchOrderByValueQueuesHolder;
import org.apache.shardingsphere.sharding.merge.dql.orderby.OrderByValue;

public final class FetchStreamMergedResult
extends StreamMergedResult {
    private final Collection<OrderByItem> orderByItems;
    private final Queue<OrderByValue> orderByValuesQueue;
    private boolean isFirstNext;

    public FetchStreamMergedResult(List<QueryResult> queryResults, FetchStatementContext fetchStatementContext, ShardingSphereSchema schema) throws SQLException {
        String cursorName = fetchStatementContext.getCursorName().getIdentifier().getValue().toLowerCase();
        SelectStatementContext selectStatementContext = fetchStatementContext.getCursorStatementContext().getSelectStatementContext();
        this.orderByItems = selectStatementContext.getOrderByContext().getItems();
        this.orderByValuesQueue = FetchOrderByValueQueuesHolder.get().computeIfAbsent(cursorName, key -> new PriorityQueue(queryResults.size()));
        this.orderResultSetsToQueue(queryResults, selectStatementContext, schema);
        this.isFirstNext = true;
    }

    private void orderResultSetsToQueue(List<QueryResult> queryResults, SelectStatementContext selectStatementContext, ShardingSphereSchema schema) throws SQLException {
        for (QueryResult each : queryResults) {
            OrderByValue orderByValue = new OrderByValue(each, this.orderByItems, selectStatementContext, schema);
            if (!orderByValue.next()) continue;
            this.orderByValuesQueue.offer(orderByValue);
        }
    }

    public boolean next() throws SQLException {
        if (this.orderByValuesQueue.isEmpty()) {
            return false;
        }
        if (this.isFirstNext) {
            this.setCurrentQueryResult(this.orderByValuesQueue.poll().getQueryResult());
            this.isFirstNext = false;
            return true;
        }
        return false;
    }
}

