/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.data.pipeline;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.config.TableNameSchemaNameMapping;
import org.apache.shardingsphere.data.pipeline.api.config.ingest.DumperConfiguration;
import org.apache.shardingsphere.data.pipeline.api.config.rulealtered.ImporterConfiguration;
import org.apache.shardingsphere.data.pipeline.api.config.rulealtered.RuleAlteredJobConfiguration;
import org.apache.shardingsphere.data.pipeline.api.config.rulealtered.TaskConfiguration;
import org.apache.shardingsphere.data.pipeline.api.config.rulealtered.yaml.RuleAlteredJobConfigurationSwapper;
import org.apache.shardingsphere.data.pipeline.api.config.rulealtered.yaml.YamlRuleAlteredJobConfiguration;
import org.apache.shardingsphere.data.pipeline.api.datanode.JobDataNodeEntry;
import org.apache.shardingsphere.data.pipeline.api.datanode.JobDataNodeLine;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.PipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.PipelineDataSourceConfigurationFactory;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.impl.ShardingSpherePipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.impl.StandardPipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.api.metadata.ActualTableName;
import org.apache.shardingsphere.data.pipeline.api.metadata.LogicTableName;
import org.apache.shardingsphere.data.pipeline.core.context.PipelineContext;
import org.apache.shardingsphere.data.pipeline.spi.rulealtered.RuleAlteredJobConfigurationPreparer;
import org.apache.shardingsphere.infra.config.rulealtered.OnRuleAlteredActionConfiguration;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.datasource.props.DataSourceProperties;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.yaml.config.swapper.YamlDataSourceConfigurationSwapper;
import org.apache.shardingsphere.infra.yaml.engine.YamlEngine;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingTableRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ComplexShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.StandardShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sharding.rule.TableRule;
import org.apache.shardingsphere.sharding.yaml.config.YamlShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.yaml.swapper.ShardingRuleConfigurationConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ShardingRuleAlteredJobConfigurationPreparer
implements RuleAlteredJobConfigurationPreparer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ShardingRuleAlteredJobConfigurationPreparer.class);

    public void extendJobConfiguration(YamlRuleAlteredJobConfiguration yamlJobConfig) {
        Map<String, List<DataNode>> actualDataNodes = ShardingRuleAlteredJobConfigurationPreparer.getActualDataNodes(new RuleAlteredJobConfigurationSwapper().swapToObject(yamlJobConfig));
        yamlJobConfig.setJobShardingDataNodes(this.getJobShardingDataNodes(actualDataNodes));
        yamlJobConfig.setLogicTables(ShardingRuleAlteredJobConfigurationPreparer.getLogicTables(actualDataNodes.keySet()));
        yamlJobConfig.setTablesFirstDataNodes(ShardingRuleAlteredJobConfigurationPreparer.getTablesFirstDataNodes(actualDataNodes));
    }

    private static Map<String, List<DataNode>> getActualDataNodes(RuleAlteredJobConfiguration jobConfig) {
        PipelineDataSourceConfiguration sourceDataSourceConfig = PipelineDataSourceConfigurationFactory.newInstance((String)jobConfig.getSource().getType(), (String)jobConfig.getSource().getParameter());
        ShardingSpherePipelineDataSourceConfiguration source = (ShardingSpherePipelineDataSourceConfiguration)sourceDataSourceConfig;
        ShardingRuleConfiguration sourceRuleConfig = ShardingRuleConfigurationConverter.findAndConvertShardingRuleConfiguration(source.getRootConfig().getRules());
        ShardingRule shardingRule = new ShardingRule(sourceRuleConfig, source.getRootConfig().getDataSources().keySet());
        Map<String, TableRule> tableRules = shardingRule.getTableRules();
        LinkedHashMap<String, List<DataNode>> result = new LinkedHashMap<String, List<DataNode>>();
        HashSet reShardNeededTables = new HashSet((Collection)jobConfig.getAlteredRuleYamlClassNameTablesMap().get(YamlShardingRuleConfiguration.class.getName()));
        for (Map.Entry<String, TableRule> entry : tableRules.entrySet()) {
            if (!reShardNeededTables.contains(entry.getKey())) continue;
            result.put(entry.getKey(), entry.getValue().getActualDataNodes());
        }
        return result;
    }

    private List<String> getJobShardingDataNodes(Map<String, List<DataNode>> actualDataNodes) {
        LinkedList<String> result = new LinkedList<String>();
        Map<String, Map<String, List<DataNode>>> groupedDataSourceDataNodesMap = this.groupDataSourceDataNodesMapByDataSourceName(actualDataNodes);
        for (Map<String, List<DataNode>> each : groupedDataSourceDataNodesMap.values()) {
            ArrayList<JobDataNodeEntry> dataNodeEntries = new ArrayList<JobDataNodeEntry>(each.size());
            for (Map.Entry<String, List<DataNode>> entry : each.entrySet()) {
                dataNodeEntries.add(new JobDataNodeEntry(entry.getKey(), entry.getValue()));
            }
            result.add(new JobDataNodeLine(dataNodeEntries).marshal());
        }
        return result;
    }

    private Map<String, Map<String, List<DataNode>>> groupDataSourceDataNodesMapByDataSourceName(Map<String, List<DataNode>> actualDataNodes) {
        LinkedHashMap<String, Map<String, List<DataNode>>> result = new LinkedHashMap<String, Map<String, List<DataNode>>>();
        for (Map.Entry<String, List<DataNode>> entry : actualDataNodes.entrySet()) {
            for (DataNode each : entry.getValue()) {
                Map groupedDataNodesMap = result.computeIfAbsent(each.getDataSourceName(), key -> new LinkedHashMap());
                groupedDataNodesMap.computeIfAbsent(entry.getKey(), key -> new LinkedList()).add(each);
            }
        }
        return result;
    }

    private static String getLogicTables(Set<String> logicTables) {
        return String.join((CharSequence)",", logicTables);
    }

    private static String getTablesFirstDataNodes(Map<String, List<DataNode>> actualDataNodes) {
        ArrayList<JobDataNodeEntry> dataNodeEntries = new ArrayList<JobDataNodeEntry>(actualDataNodes.size());
        for (Map.Entry<String, List<DataNode>> entry : actualDataNodes.entrySet()) {
            dataNodeEntries.add(new JobDataNodeEntry(entry.getKey(), entry.getValue().subList(0, 1)));
        }
        return new JobDataNodeLine(dataNodeEntries).marshal();
    }

    public TaskConfiguration createTaskConfiguration(RuleAlteredJobConfiguration jobConfig, int jobShardingItem, OnRuleAlteredActionConfiguration onRuleAlteredActionConfig) {
        ShardingSpherePipelineDataSourceConfiguration sourceConfig = ShardingRuleAlteredJobConfigurationPreparer.getSourceConfiguration(jobConfig);
        ShardingRuleConfiguration sourceRuleConfig = ShardingRuleConfigurationConverter.findAndConvertShardingRuleConfiguration(sourceConfig.getRootConfig().getRules());
        Map dataSourcePropsMap = new YamlDataSourceConfigurationSwapper().getDataSourcePropertiesMap(sourceConfig.getRootConfig());
        JobDataNodeLine dataNodeLine = JobDataNodeLine.unmarshal((String)((String)jobConfig.getJobShardingDataNodes().get(jobShardingItem)));
        String dataSourceName = ((DataNode)((JobDataNodeEntry)dataNodeLine.getEntries().get(0)).getDataNodes().get(0)).getDataSourceName();
        LinkedHashMap<ActualTableName, LogicTableName> tableNameMap = new LinkedHashMap<ActualTableName, LogicTableName>();
        for (JobDataNodeEntry each : dataNodeLine.getEntries()) {
            for (DataNode dataNode : each.getDataNodes()) {
                tableNameMap.put(new ActualTableName(dataNode.getTableName()), new LogicTableName(each.getLogicTableName()));
            }
        }
        ShardingSphereDatabase database = (ShardingSphereDatabase)PipelineContext.getContextManager().getMetaDataContexts().getMetaData().getDatabases().get(jobConfig.getDatabaseName());
        DumperConfiguration dumperConfig = ShardingRuleAlteredJobConfigurationPreparer.createDumperConfiguration(jobConfig.getDatabaseName(), dataSourceName, ((DataSourceProperties)dataSourcePropsMap.get(dataSourceName)).getAllLocalProperties(), tableNameMap, database);
        Optional<ShardingRuleConfiguration> targetRuleConfig = ShardingRuleAlteredJobConfigurationPreparer.getTargetRuleConfiguration(jobConfig);
        Set<LogicTableName> reShardNeededTables = jobConfig.splitLogicTableNames().stream().map(LogicTableName::new).collect(Collectors.toSet());
        Map<LogicTableName, Set<String>> shardingColumnsMap = ShardingRuleAlteredJobConfigurationPreparer.getShardingColumnsMap(targetRuleConfig.orElse(sourceRuleConfig), reShardNeededTables);
        ImporterConfiguration importerConfig = ShardingRuleAlteredJobConfigurationPreparer.createImporterConfiguration(jobConfig, onRuleAlteredActionConfig, shardingColumnsMap, database);
        TaskConfiguration result = new TaskConfiguration(jobConfig, dumperConfig, importerConfig);
        log.info("createTaskConfiguration, dataSourceName={}, result={}", (Object)dataSourceName, (Object)result);
        return result;
    }

    private static ShardingSpherePipelineDataSourceConfiguration getSourceConfiguration(RuleAlteredJobConfiguration jobConfig) {
        return (ShardingSpherePipelineDataSourceConfiguration)PipelineDataSourceConfigurationFactory.newInstance((String)jobConfig.getSource().getType(), (String)jobConfig.getSource().getParameter());
    }

    private static Optional<ShardingRuleConfiguration> getTargetRuleConfiguration(RuleAlteredJobConfiguration jobConfig) {
        PipelineDataSourceConfiguration targetDataSourceConfig = PipelineDataSourceConfigurationFactory.newInstance((String)jobConfig.getTarget().getType(), (String)jobConfig.getTarget().getParameter());
        if (!(targetDataSourceConfig instanceof ShardingSpherePipelineDataSourceConfiguration)) {
            return Optional.empty();
        }
        ShardingSpherePipelineDataSourceConfiguration target = (ShardingSpherePipelineDataSourceConfiguration)targetDataSourceConfig;
        return Optional.of(ShardingRuleConfigurationConverter.findAndConvertShardingRuleConfiguration(target.getRootConfig().getRules()));
    }

    private static Map<LogicTableName, Set<String>> getShardingColumnsMap(ShardingRuleConfiguration shardingRuleConfig, Set<LogicTableName> reShardNeededTables) {
        LogicTableName logicTableName;
        Set<String> defaultDatabaseShardingColumns = ShardingRuleAlteredJobConfigurationPreparer.extractShardingColumns(shardingRuleConfig.getDefaultDatabaseShardingStrategy());
        Set<String> defaultTableShardingColumns = ShardingRuleAlteredJobConfigurationPreparer.extractShardingColumns(shardingRuleConfig.getDefaultTableShardingStrategy());
        ConcurrentHashMap<LogicTableName, Set<String>> result = new ConcurrentHashMap<LogicTableName, Set<String>>();
        for (ShardingTableRuleConfiguration each : shardingRuleConfig.getTables()) {
            logicTableName = new LogicTableName(each.getLogicTable());
            if (!reShardNeededTables.contains(logicTableName)) continue;
            HashSet<String> shardingColumns = new HashSet<String>();
            shardingColumns.addAll(null == each.getDatabaseShardingStrategy() ? defaultDatabaseShardingColumns : ShardingRuleAlteredJobConfigurationPreparer.extractShardingColumns(each.getDatabaseShardingStrategy()));
            shardingColumns.addAll(null == each.getTableShardingStrategy() ? defaultTableShardingColumns : ShardingRuleAlteredJobConfigurationPreparer.extractShardingColumns(each.getTableShardingStrategy()));
            result.put(logicTableName, shardingColumns);
        }
        for (ShardingTableRuleConfiguration each : shardingRuleConfig.getAutoTables()) {
            logicTableName = new LogicTableName(each.getLogicTable());
            if (!reShardNeededTables.contains(logicTableName)) continue;
            ShardingStrategyConfiguration shardingStrategy = each.getShardingStrategy();
            HashSet<String> shardingColumns = new HashSet<String>(ShardingRuleAlteredJobConfigurationPreparer.extractShardingColumns(shardingStrategy));
            result.put(logicTableName, shardingColumns);
        }
        return result;
    }

    private static Set<String> extractShardingColumns(ShardingStrategyConfiguration shardingStrategy) {
        if (shardingStrategy instanceof StandardShardingStrategyConfiguration) {
            return new HashSet<String>(Collections.singleton(((StandardShardingStrategyConfiguration)shardingStrategy).getShardingColumn()));
        }
        if (shardingStrategy instanceof ComplexShardingStrategyConfiguration) {
            return new HashSet<String>(Arrays.asList(((ComplexShardingStrategyConfiguration)shardingStrategy).getShardingColumns().split(",")));
        }
        return Collections.emptySet();
    }

    private static DumperConfiguration createDumperConfiguration(String databaseName, String dataSourceName, Map<String, Object> props, Map<ActualTableName, LogicTableName> tableNameMap, ShardingSphereDatabase database) {
        DumperConfiguration result = new DumperConfiguration();
        result.setDatabaseName(databaseName);
        result.setDataSourceName(dataSourceName);
        result.setDataSourceConfig((PipelineDataSourceConfiguration)new StandardPipelineDataSourceConfiguration(YamlEngine.marshal(props)));
        result.setTableNameMap(tableNameMap);
        result.setTableNameSchemaNameMapping(new TableNameSchemaNameMapping(TableNameSchemaNameMapping.convert((Map)database.getSchemas())));
        return result;
    }

    private static ImporterConfiguration createImporterConfiguration(RuleAlteredJobConfiguration jobConfig, OnRuleAlteredActionConfiguration onRuleAlteredActionConfig, Map<LogicTableName, Set<String>> shardingColumnsMap, ShardingSphereDatabase database) {
        PipelineDataSourceConfiguration dataSourceConfig = PipelineDataSourceConfigurationFactory.newInstance((String)jobConfig.getTarget().getType(), (String)jobConfig.getTarget().getParameter());
        TableNameSchemaNameMapping tableNameSchemaNameMapping = new TableNameSchemaNameMapping(TableNameSchemaNameMapping.convert((Map)database.getSchemas()));
        int batchSize = onRuleAlteredActionConfig.getOutput().getBatchSize();
        int retryTimes = jobConfig.getRetryTimes();
        return new ImporterConfiguration(dataSourceConfig, ShardingRuleAlteredJobConfigurationPreparer.unmodifiable(shardingColumnsMap), tableNameSchemaNameMapping, batchSize, retryTimes);
    }

    private static Map<LogicTableName, Set<String>> unmodifiable(Map<LogicTableName, Set<String>> shardingColumnsMap) {
        HashMap<LogicTableName, Set<String>> result = new HashMap<LogicTableName, Set<String>>(shardingColumnsMap.size());
        for (Map.Entry<LogicTableName, Set<String>> entry : shardingColumnsMap.entrySet()) {
            result.put(entry.getKey(), Collections.unmodifiableSet(entry.getValue()));
        }
        return Collections.unmodifiableMap(result);
    }
}

