/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.algorithm.sharding.datetime;

import com.google.common.base.Preconditions;
import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Properties;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.exception.ShardingSphereConfigurationException;
import org.apache.shardingsphere.sharding.api.sharding.standard.PreciseShardingValue;
import org.apache.shardingsphere.sharding.api.sharding.standard.RangeShardingValue;
import org.apache.shardingsphere.sharding.api.sharding.standard.StandardShardingAlgorithm;

public final class IntervalShardingAlgorithm
implements StandardShardingAlgorithm<Comparable<?>> {
    private static final String DATE_TIME_PATTERN_KEY = "datetime-pattern";
    private static final String DATE_TIME_LOWER_KEY = "datetime-lower";
    private static final String DATE_TIME_UPPER_KEY = "datetime-upper";
    private static final String SHARDING_SUFFIX_FORMAT_KEY = "sharding-suffix-pattern";
    private static final String INTERVAL_AMOUNT_KEY = "datetime-interval-amount";
    private static final String INTERVAL_UNIT_KEY = "datetime-interval-unit";
    private Properties props;
    private DateTimeFormatter dateTimeFormatter;
    private int dateTimePatternLength;
    private TemporalAccessor dateTimeLower;
    private TemporalAccessor dateTimeUpper;
    private DateTimeFormatter tableSuffixPattern;
    private int stepAmount;
    private ChronoUnit stepUnit;

    public void init(Properties props) {
        this.props = props;
        String dateTimePattern = this.getDateTimePattern(props);
        this.dateTimeFormatter = DateTimeFormatter.ofPattern(dateTimePattern);
        this.dateTimePatternLength = dateTimePattern.length();
        this.dateTimeLower = this.getDateTimeLower(props, dateTimePattern);
        this.dateTimeUpper = this.getDateTimeUpper(props, dateTimePattern);
        this.tableSuffixPattern = this.getTableSuffixPattern(props);
        this.stepAmount = Integer.parseInt(props.getOrDefault((Object)INTERVAL_AMOUNT_KEY, (Object)1).toString());
        this.stepUnit = props.containsKey(INTERVAL_UNIT_KEY) ? this.getStepUnit(props.getProperty(INTERVAL_UNIT_KEY)) : ChronoUnit.DAYS;
    }

    private String getDateTimePattern(Properties props) {
        Preconditions.checkArgument((boolean)props.containsKey(DATE_TIME_PATTERN_KEY), (String)"%s can not be null.", (Object)DATE_TIME_PATTERN_KEY);
        return props.getProperty(DATE_TIME_PATTERN_KEY);
    }

    private TemporalAccessor getDateTimeLower(Properties props, String dateTimePattern) {
        Preconditions.checkArgument((boolean)props.containsKey(DATE_TIME_LOWER_KEY), (String)"%s can not be null.", (Object)DATE_TIME_LOWER_KEY);
        return this.getDateTime(DATE_TIME_LOWER_KEY, props.getProperty(DATE_TIME_LOWER_KEY), dateTimePattern);
    }

    private TemporalAccessor getDateTimeUpper(Properties props, String dateTimePattern) {
        return props.containsKey(DATE_TIME_UPPER_KEY) ? this.getDateTime(DATE_TIME_UPPER_KEY, props.getProperty(DATE_TIME_UPPER_KEY), dateTimePattern) : LocalDateTime.now();
    }

    private TemporalAccessor getDateTime(String dateTimeKey, String dateTimeValue, String dateTimePattern) {
        try {
            return this.dateTimeFormatter.parse(dateTimeValue);
        }
        catch (DateTimeParseException ex) {
            throw new ShardingSphereConfigurationException("Invalid %s, datetime pattern should be `%s`, value is `%s`", new Object[]{dateTimeKey, dateTimePattern, dateTimeValue});
        }
    }

    private DateTimeFormatter getTableSuffixPattern(Properties props) {
        Preconditions.checkArgument((boolean)props.containsKey(SHARDING_SUFFIX_FORMAT_KEY), (String)"%s can not be null.", (Object)SHARDING_SUFFIX_FORMAT_KEY);
        return DateTimeFormatter.ofPattern(props.getProperty(SHARDING_SUFFIX_FORMAT_KEY));
    }

    private ChronoUnit getStepUnit(String stepUnit) {
        for (ChronoUnit each : ChronoUnit.values()) {
            if (!each.toString().equalsIgnoreCase(stepUnit)) continue;
            return each;
        }
        throw new UnsupportedOperationException(String.format("Cannot find step unit for specified %s property: `%s`", INTERVAL_UNIT_KEY, stepUnit));
    }

    public String doSharding(Collection<String> availableTargetNames, PreciseShardingValue<Comparable<?>> shardingValue) {
        return this.doSharding(availableTargetNames, Range.singleton((Comparable)shardingValue.getValue())).stream().findFirst().orElse(null);
    }

    public Collection<String> doSharding(Collection<String> availableTargetNames, RangeShardingValue<Comparable<?>> shardingValue) {
        return this.doSharding(availableTargetNames, shardingValue.getValueRange());
    }

    private Collection<String> doSharding(Collection<String> availableTargetNames, Range<Comparable<?>> range) {
        TemporalAccessor calculateTime = this.dateTimeLower;
        LocalDate queryToLocalDate = calculateTime.query(TemporalQueries.localDate());
        LocalTime queryToLocalTime = calculateTime.query(TemporalQueries.localTime());
        if (null == queryToLocalTime) {
            return this.doShardingInLocalDate(availableTargetNames, range, calculateTime);
        }
        if (null == queryToLocalDate) {
            return this.doShardingInLocalTime(availableTargetNames, range, calculateTime);
        }
        return this.doShardingInLocalDateTime(availableTargetNames, range, calculateTime);
    }

    private Collection<String> doShardingInLocalDateTime(Collection<String> availableTargetNames, Range<Comparable<?>> range, TemporalAccessor calculateTime) {
        HashSet<String> result = new HashSet<String>();
        LocalDateTime calculateTimeAsView = LocalDateTime.from(calculateTime);
        LocalDateTime dateTimeUpperAsLocalDateTime = LocalDateTime.from(this.dateTimeUpper);
        LocalDateTime dateTimeLowerAsLocalDateTime = LocalDateTime.from(this.dateTimeLower);
        while (!calculateTimeAsView.isAfter(dateTimeUpperAsLocalDateTime)) {
            if (this.hasIntersection((Range<LocalDateTime>)Range.closedOpen((Comparable)calculateTimeAsView, (Comparable)calculateTimeAsView.plus(this.stepAmount, this.stepUnit)), range, dateTimeLowerAsLocalDateTime, dateTimeUpperAsLocalDateTime)) {
                result.addAll(this.getMatchedTables(calculateTimeAsView, availableTargetNames));
            }
            calculateTimeAsView = calculateTimeAsView.plus(this.stepAmount, this.stepUnit);
        }
        return result;
    }

    private Collection<String> doShardingInLocalTime(Collection<String> availableTargetNames, Range<Comparable<?>> range, TemporalAccessor calculateTime) {
        HashSet<String> result = new HashSet<String>();
        LocalTime dateTimeUpperAsLocalTime = this.dateTimeUpper.query(TemporalQueries.localTime());
        LocalTime dateTimeLowerAsLocalTime = this.dateTimeLower.query(TemporalQueries.localTime());
        LocalTime calculateTimeAsView = calculateTime.query(TemporalQueries.localTime());
        while (!calculateTimeAsView.isAfter(dateTimeUpperAsLocalTime)) {
            if (this.hasIntersection((Range<LocalTime>)Range.closedOpen((Comparable)calculateTimeAsView, (Comparable)calculateTimeAsView.plus(this.stepAmount, this.stepUnit)), range, dateTimeLowerAsLocalTime, dateTimeUpperAsLocalTime)) {
                result.addAll(this.getMatchedTables(calculateTimeAsView, availableTargetNames));
            }
            calculateTimeAsView = calculateTimeAsView.plus(this.stepAmount, this.stepUnit);
        }
        return result;
    }

    private Collection<String> doShardingInLocalDate(Collection<String> availableTargetNames, Range<Comparable<?>> range, TemporalAccessor calculateTime) {
        HashSet<String> result = new HashSet<String>();
        LocalDate dateTimeUpperAsLocalDate = this.dateTimeUpper.query(TemporalQueries.localDate());
        LocalDate dateTimeLowerAsLocalDate = this.dateTimeLower.query(TemporalQueries.localDate());
        LocalDate calculateTimeAsView = calculateTime.query(TemporalQueries.localDate());
        while (!calculateTimeAsView.isAfter(dateTimeUpperAsLocalDate)) {
            if (this.hasIntersection((Range<LocalDate>)Range.closedOpen((Comparable)calculateTimeAsView, (Comparable)calculateTimeAsView.plus(this.stepAmount, this.stepUnit)), range, dateTimeLowerAsLocalDate, dateTimeUpperAsLocalDate)) {
                result.addAll(this.getMatchedTables(calculateTimeAsView, availableTargetNames));
            }
            calculateTimeAsView = calculateTimeAsView.plus(this.stepAmount, this.stepUnit);
        }
        return result;
    }

    private boolean hasIntersection(Range<LocalDateTime> calculateRange, Range<Comparable<?>> range, LocalDateTime dateTimeLower, LocalDateTime dateTimeUpper) {
        LocalDateTime lower = range.hasLowerBound() ? this.parseLocalDateTime(range.lowerEndpoint()) : dateTimeLower;
        LocalDateTime upper = range.hasUpperBound() ? this.parseLocalDateTime(range.upperEndpoint()) : dateTimeUpper;
        BoundType lowerBoundType = range.hasLowerBound() ? range.lowerBoundType() : BoundType.CLOSED;
        BoundType upperBoundType = range.hasUpperBound() ? range.upperBoundType() : BoundType.CLOSED;
        Range dateTimeRange = Range.range((Comparable)lower, (BoundType)lowerBoundType, (Comparable)upper, (BoundType)upperBoundType);
        return calculateRange.isConnected(dateTimeRange) && !calculateRange.intersection(dateTimeRange).isEmpty();
    }

    private boolean hasIntersection(Range<LocalDate> calculateRange, Range<Comparable<?>> range, LocalDate dateTimeLower, LocalDate dateTimeUpper) {
        LocalDate lower = range.hasLowerBound() ? this.parseLocalDate(range.lowerEndpoint()) : dateTimeLower;
        LocalDate upper = range.hasUpperBound() ? this.parseLocalDate(range.upperEndpoint()) : dateTimeUpper;
        BoundType lowerBoundType = range.hasLowerBound() ? range.lowerBoundType() : BoundType.CLOSED;
        BoundType upperBoundType = range.hasUpperBound() ? range.upperBoundType() : BoundType.CLOSED;
        Range dateTimeRange = Range.range((Comparable)lower, (BoundType)lowerBoundType, (Comparable)upper, (BoundType)upperBoundType);
        return calculateRange.isConnected(dateTimeRange) && !calculateRange.intersection(dateTimeRange).isEmpty();
    }

    private boolean hasIntersection(Range<LocalTime> calculateRange, Range<Comparable<?>> range, LocalTime dateTimeLower, LocalTime dateTimeUpper) {
        LocalTime lower = range.hasLowerBound() ? this.parseLocalTime(range.lowerEndpoint()) : dateTimeLower;
        LocalTime upper = range.hasUpperBound() ? this.parseLocalTime(range.upperEndpoint()) : dateTimeUpper;
        BoundType lowerBoundType = range.hasLowerBound() ? range.lowerBoundType() : BoundType.CLOSED;
        BoundType upperBoundType = range.hasUpperBound() ? range.upperBoundType() : BoundType.CLOSED;
        Range dateTimeRange = Range.range((Comparable)lower, (BoundType)lowerBoundType, (Comparable)upper, (BoundType)upperBoundType);
        return calculateRange.isConnected(dateTimeRange) && !calculateRange.intersection(dateTimeRange).isEmpty();
    }

    private LocalDateTime parseLocalDateTime(Comparable<?> endpoint) {
        return LocalDateTime.parse(this.getDateTimeText(endpoint).substring(0, this.dateTimePatternLength), this.dateTimeFormatter);
    }

    private LocalDate parseLocalDate(Comparable<?> endpoint) {
        return LocalDate.parse(this.getDateTimeText(endpoint).substring(0, this.dateTimePatternLength), this.dateTimeFormatter);
    }

    private LocalTime parseLocalTime(Comparable<?> endpoint) {
        return LocalTime.parse(this.getDateTimeText(endpoint).substring(0, this.dateTimePatternLength), this.dateTimeFormatter);
    }

    private String getDateTimeText(Comparable<?> endpoint) {
        if (endpoint instanceof Instant) {
            return this.dateTimeFormatter.withZone(ZoneId.systemDefault()).format((Instant)endpoint);
        }
        if (endpoint instanceof TemporalAccessor) {
            return this.dateTimeFormatter.format((TemporalAccessor)((Object)endpoint));
        }
        if (endpoint instanceof Date) {
            return this.dateTimeFormatter.format(((Date)endpoint).toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime());
        }
        return endpoint.toString();
    }

    private Collection<String> getMatchedTables(TemporalAccessor dateTime, Collection<String> availableTargetNames) {
        LocalDate localDate = dateTime.query(TemporalQueries.localDate());
        LocalTime localTime = dateTime.query(TemporalQueries.localTime());
        if (null == localTime) {
            String tableSuffix = localDate.format(this.tableSuffixPattern);
            return availableTargetNames.parallelStream().filter(each -> each.endsWith(tableSuffix)).collect(Collectors.toSet());
        }
        if (null == localDate) {
            String tableSuffix = localTime.format(this.tableSuffixPattern);
            return availableTargetNames.parallelStream().filter(each -> each.endsWith(tableSuffix)).collect(Collectors.toSet());
        }
        String tableSuffix = LocalDateTime.from(dateTime).format(this.tableSuffixPattern);
        return availableTargetNames.parallelStream().filter(each -> each.endsWith(tableSuffix)).collect(Collectors.toSet());
    }

    public String getType() {
        return "INTERVAL";
    }

    @Generated
    public Properties getProps() {
        return this.props;
    }
}

