/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.readwritesplitting.strategy.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.infra.datasource.strategy.DynamicDataSourceStrategy;
import org.apache.shardingsphere.readwritesplitting.strategy.ReadwriteSplittingStrategy;

public final class DynamicReadwriteSplittingStrategy
implements ReadwriteSplittingStrategy {
    private final String autoAwareDataSourceName;
    private final DynamicDataSourceStrategy dynamicDataSourceStrategy;

    @Override
    public String getWriteDataSource() {
        return this.dynamicDataSourceStrategy.getPrimaryDataSourceName(this.autoAwareDataSourceName);
    }

    @Override
    public List<String> getReadDataSources() {
        return new ArrayList<String>(this.dynamicDataSourceStrategy.getReplicaDataSourceNames(this.autoAwareDataSourceName));
    }

    @Override
    public Collection<String> getAllDataSources() {
        LinkedList<String> result = new LinkedList<String>();
        result.add(this.dynamicDataSourceStrategy.getPrimaryDataSourceName(this.autoAwareDataSourceName));
        result.addAll(this.dynamicDataSourceStrategy.getReplicaDataSourceNames(this.autoAwareDataSourceName));
        return result;
    }

    @Generated
    public DynamicReadwriteSplittingStrategy(String autoAwareDataSourceName, DynamicDataSourceStrategy dynamicDataSourceStrategy) {
        this.autoAwareDataSourceName = autoAwareDataSourceName;
        this.dynamicDataSourceStrategy = dynamicDataSourceStrategy;
    }

    @Generated
    public String getAutoAwareDataSourceName() {
        return this.autoAwareDataSourceName;
    }

    @Generated
    public DynamicDataSourceStrategy getDynamicDataSourceStrategy() {
        return this.dynamicDataSourceStrategy;
    }
}

