/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.readwritesplitting.strategy;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.infra.datasource.strategy.DynamicDataSourceStrategy;
import org.apache.shardingsphere.infra.datasource.strategy.DynamicDataSourceStrategyFactory;
import org.apache.shardingsphere.readwritesplitting.strategy.ReadwriteSplittingStrategy;
import org.apache.shardingsphere.readwritesplitting.strategy.type.DynamicReadwriteSplittingStrategy;
import org.apache.shardingsphere.readwritesplitting.strategy.type.StaticReadwriteSplittingStrategy;

public final class ReadwriteSplittingStrategyFactory {
    public static ReadwriteSplittingStrategy newInstance(String type, Properties props) {
        return "STATIC".equalsIgnoreCase(type) ? ReadwriteSplittingStrategyFactory.createStaticReadwriteSplittingStrategy(props) : ReadwriteSplittingStrategyFactory.createDynamicReadwriteSplittingStrategy(props);
    }

    private static StaticReadwriteSplittingStrategy createStaticReadwriteSplittingStrategy(Properties props) {
        String writeDataSourceName = props.getProperty("write-data-source-name");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)writeDataSourceName) ? 1 : 0) != 0, (Object)"Write data source name is required.");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)props.getProperty("read-data-source-names")) ? 1 : 0) != 0, (Object)"Read data source names are required.");
        List readDataSourceNames = Splitter.on((String)",").trimResults().splitToList((CharSequence)props.getProperty("read-data-source-names"));
        return new StaticReadwriteSplittingStrategy(writeDataSourceName, readDataSourceNames);
    }

    private static DynamicReadwriteSplittingStrategy createDynamicReadwriteSplittingStrategy(Properties props) {
        String autoAwareDataSourceName = props.getProperty("auto-aware-data-source-name");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)autoAwareDataSourceName) ? 1 : 0) != 0, (Object)"Auto aware data source name is required.");
        Optional dynamicDataSourceStrategy = DynamicDataSourceStrategyFactory.findInstance();
        Preconditions.checkArgument((boolean)dynamicDataSourceStrategy.isPresent(), (Object)"Dynamic data source strategy is required.");
        return new DynamicReadwriteSplittingStrategy(autoAwareDataSourceName, (DynamicDataSourceStrategy)dynamicDataSourceStrategy.get());
    }

    @Generated
    private ReadwriteSplittingStrategyFactory() {
    }
}

