/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.readwritesplitting.rule;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithmConfiguration;
import org.apache.shardingsphere.infra.rule.event.DataSourceStatusChangedEvent;
import org.apache.shardingsphere.infra.rule.identifier.scope.SchemaRule;
import org.apache.shardingsphere.infra.rule.identifier.type.DataSourceContainedRule;
import org.apache.shardingsphere.infra.rule.identifier.type.ExportableRule;
import org.apache.shardingsphere.infra.rule.identifier.type.StatusContainedRule;
import org.apache.shardingsphere.mode.metadata.storage.event.DataSourceNameDisabledEvent;
import org.apache.shardingsphere.readwritesplitting.algorithm.config.AlgorithmProvidedReadwriteSplittingRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.api.ReadwriteSplittingRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.api.rule.ReadwriteSplittingDataSourceRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.factory.ReplicaLoadBalanceAlgorithmFactory;
import org.apache.shardingsphere.readwritesplitting.rule.ReadwriteSplittingDataSourceRule;
import org.apache.shardingsphere.readwritesplitting.spi.ReadQueryLoadBalanceAlgorithm;
import org.apache.shardingsphere.readwritesplitting.strategy.type.DynamicReadwriteSplittingStrategy;
import org.apache.shardingsphere.readwritesplitting.strategy.type.StaticReadwriteSplittingStrategy;

public final class ReadwriteSplittingRule
implements SchemaRule,
DataSourceContainedRule,
StatusContainedRule,
ExportableRule {
    private final Map<String, ReadQueryLoadBalanceAlgorithm> loadBalancers = new LinkedHashMap<String, ReadQueryLoadBalanceAlgorithm>();
    private final Map<String, ReadwriteSplittingDataSourceRule> dataSourceRules;

    public ReadwriteSplittingRule(ReadwriteSplittingRuleConfiguration ruleConfig) {
        Preconditions.checkArgument((!ruleConfig.getDataSources().isEmpty() ? 1 : 0) != 0, (Object)"Replica query data source rules can not be empty.");
        ruleConfig.getLoadBalancers().forEach((key, value) -> this.loadBalancers.put((String)key, ReplicaLoadBalanceAlgorithmFactory.newInstance((ShardingSphereAlgorithmConfiguration)value)));
        this.dataSourceRules = new HashMap<String, ReadwriteSplittingDataSourceRule>(ruleConfig.getDataSources().size(), 1.0f);
        for (ReadwriteSplittingDataSourceRuleConfiguration each : ruleConfig.getDataSources()) {
            ReadQueryLoadBalanceAlgorithm loadBalanceAlgorithm = Strings.isNullOrEmpty((String)each.getLoadBalancerName()) || !this.loadBalancers.containsKey(each.getLoadBalancerName()) ? ReplicaLoadBalanceAlgorithmFactory.newInstance() : this.loadBalancers.get(each.getLoadBalancerName());
            this.dataSourceRules.put(each.getName(), new ReadwriteSplittingDataSourceRule(each, loadBalanceAlgorithm));
        }
    }

    public ReadwriteSplittingRule(AlgorithmProvidedReadwriteSplittingRuleConfiguration ruleConfig) {
        Preconditions.checkArgument((!ruleConfig.getDataSources().isEmpty() ? 1 : 0) != 0, (Object)"Replica query data source rules can not be empty.");
        this.loadBalancers.putAll(ruleConfig.getLoadBalanceAlgorithms());
        this.dataSourceRules = new HashMap<String, ReadwriteSplittingDataSourceRule>(ruleConfig.getDataSources().size(), 1.0f);
        for (ReadwriteSplittingDataSourceRuleConfiguration each : ruleConfig.getDataSources()) {
            ReadQueryLoadBalanceAlgorithm loadBalanceAlgorithm = Strings.isNullOrEmpty((String)each.getLoadBalancerName()) || !this.loadBalancers.containsKey(each.getLoadBalancerName()) ? ReplicaLoadBalanceAlgorithmFactory.newInstance() : this.loadBalancers.get(each.getLoadBalancerName());
            this.dataSourceRules.put(each.getName(), new ReadwriteSplittingDataSourceRule(each, loadBalanceAlgorithm));
        }
    }

    public ReadwriteSplittingDataSourceRule getSingleDataSourceRule() {
        return this.dataSourceRules.values().iterator().next();
    }

    public Optional<ReadwriteSplittingDataSourceRule> findDataSourceRule(String dataSourceName) {
        return Optional.ofNullable(this.dataSourceRules.get(dataSourceName));
    }

    public Map<String, Collection<String>> getDataSourceMapper() {
        HashMap<String, Collection<String>> result = new HashMap<String, Collection<String>>();
        for (Map.Entry<String, ReadwriteSplittingDataSourceRule> entry : this.dataSourceRules.entrySet()) {
            result.put(entry.getValue().getName(), entry.getValue().getReadwriteSplittingStrategy().getAllDataSources());
        }
        return result;
    }

    public void updateStatus(DataSourceStatusChangedEvent event) {
        if (event instanceof DataSourceNameDisabledEvent) {
            for (Map.Entry<String, ReadwriteSplittingDataSourceRule> entry : this.dataSourceRules.entrySet()) {
                entry.getValue().updateDisabledDataSourceNames(((DataSourceNameDisabledEvent)event).getQualifiedDatabase().getDataSourceName(), ((DataSourceNameDisabledEvent)event).isDisabled());
            }
        }
    }

    public Map<String, Supplier<Object>> getExportedMethods() {
        HashMap<String, Supplier<Object>> result = new HashMap<String, Supplier<Object>>(2, 1.0f);
        result.put("dynamic_readwrite_splitting_rules", this::exportDynamicDataSources);
        result.put("static_readwrite_splitting_rules", this::exportStaticDataSources);
        return result;
    }

    private Map<String, Map<String, String>> exportDynamicDataSources() {
        LinkedHashMap<String, Map<String, String>> result = new LinkedHashMap<String, Map<String, String>>(this.dataSourceRules.size(), 1.0f);
        for (ReadwriteSplittingDataSourceRule each : this.dataSourceRules.values()) {
            if (!(each.getReadwriteSplittingStrategy() instanceof DynamicReadwriteSplittingStrategy)) continue;
            LinkedHashMap<String, String> exportedDataSources = new LinkedHashMap<String, String>(2, 1.0f);
            exportedDataSources.put("auto_aware_data_source_name", ((DynamicReadwriteSplittingStrategy)each.getReadwriteSplittingStrategy()).getAutoAwareDataSourceName());
            exportedDataSources.put("primary_data_source_name", each.getWriteDataSource());
            exportedDataSources.put("replica_data_source_names", String.join((CharSequence)",", each.getReadwriteSplittingStrategy().getReadDataSources()));
            result.put(each.getName(), exportedDataSources);
        }
        return result;
    }

    private Map<String, Map<String, String>> exportStaticDataSources() {
        LinkedHashMap<String, Map<String, String>> result = new LinkedHashMap<String, Map<String, String>>(this.dataSourceRules.size(), 1.0f);
        for (ReadwriteSplittingDataSourceRule each : this.dataSourceRules.values()) {
            if (!(each.getReadwriteSplittingStrategy() instanceof StaticReadwriteSplittingStrategy)) continue;
            LinkedHashMap<String, String> exportedDataSources = new LinkedHashMap<String, String>(2, 1.0f);
            exportedDataSources.put("primary_data_source_name", each.getWriteDataSource());
            exportedDataSources.put("replica_data_source_names", String.join((CharSequence)",", each.getReadwriteSplittingStrategy().getReadDataSources()));
            result.put(each.getName(), exportedDataSources);
        }
        return result;
    }

    public String getType() {
        return ReadwriteSplittingRule.class.getSimpleName();
    }
}

