/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.readwritesplitting.route.impl;

import lombok.Generated;
import org.apache.shardingsphere.infra.binder.statement.CommonSQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.hint.HintManager;
import org.apache.shardingsphere.readwritesplitting.rule.ReadwriteSplittingDataSourceRule;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.dml.SelectStatementHandler;

public final class ReadwriteSplittingDataSourceRouter {
    private final ReadwriteSplittingDataSourceRule rule;

    public String route(SQLStatementContext<?> sqlStatementContext) {
        if (this.isPrimaryRoute(sqlStatementContext)) {
            return this.rule.getWriteDataSource();
        }
        return this.rule.getLoadBalancer().getDataSource(this.rule.getName(), this.rule.getWriteDataSource(), this.rule.getEnabledReplicaDataSources());
    }

    private boolean isPrimaryRoute(SQLStatementContext<?> sqlStatementContext) {
        return this.isWriteRouteStatement(sqlStatementContext) || this.isHintWriteRouteOnly(sqlStatementContext);
    }

    private boolean isWriteRouteStatement(SQLStatementContext<?> sqlStatementContext) {
        SQLStatement sqlStatement = sqlStatementContext.getSqlStatement();
        return this.containsLockSegment(sqlStatement) || this.containsLastInsertIdProjection(sqlStatementContext) || !(sqlStatement instanceof SelectStatement);
    }

    private boolean containsLockSegment(SQLStatement sqlStatement) {
        return sqlStatement instanceof SelectStatement && SelectStatementHandler.getLockSegment((SelectStatement)((SelectStatement)sqlStatement)).isPresent();
    }

    private boolean containsLastInsertIdProjection(SQLStatementContext<?> sqlStatementContext) {
        return sqlStatementContext instanceof SelectStatementContext && ((SelectStatementContext)sqlStatementContext).getProjectionsContext().isContainsLastInsertIdProjection();
    }

    private boolean isHintWriteRouteOnly(SQLStatementContext<?> sqlStatementContext) {
        return HintManager.isWriteRouteOnly() || sqlStatementContext instanceof CommonSQLStatementContext && ((CommonSQLStatementContext)sqlStatementContext).isHintWriteRouteOnly();
    }

    @Generated
    public ReadwriteSplittingDataSourceRouter(ReadwriteSplittingDataSourceRule rule) {
        this.rule = rule;
    }
}

