/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.readwritesplitting.checker;

import com.google.common.base.Preconditions;
import java.util.Collection;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.config.checker.RuleConfigurationChecker;
import org.apache.shardingsphere.readwritesplitting.api.rule.ReadwriteSplittingDataSourceRuleConfiguration;

public abstract class AbstractReadwriteSplittingRuleConfigurationChecker<T extends RuleConfiguration>
implements RuleConfigurationChecker<T> {
    public final void check(String databaseName, T config) {
        this.checkDataSources(databaseName, this.getDataSources(config));
    }

    private void checkDataSources(String databaseName, Collection<ReadwriteSplittingDataSourceRuleConfiguration> dataSources) {
        dataSources.forEach(each -> {
            Preconditions.checkState((!each.getType().isEmpty() ? 1 : 0) != 0, (String)"No available readwrite-splitting rule configuration in database `%s`.", (Object)databaseName);
            Preconditions.checkState((!each.getProps().isEmpty() ? 1 : 0) != 0, (String)"No available readwrite-splitting rule configuration in database `%s`.", (Object)databaseName);
        });
    }

    protected abstract Collection<ReadwriteSplittingDataSourceRuleConfiguration> getDataSources(T var1);
}

