/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.parser.rule;

import lombok.Generated;
import org.apache.shardingsphere.infra.parser.ShardingSphereSQLParserEngine;
import org.apache.shardingsphere.infra.rule.identifier.scope.GlobalRule;
import org.apache.shardingsphere.parser.config.SQLParserRuleConfiguration;
import org.apache.shardingsphere.sql.parser.api.CacheOption;

public final class SQLParserRule
implements GlobalRule {
    private final boolean sqlCommentParseEnabled;
    private final CacheOption sqlStatementCache;
    private final CacheOption parseTreeCache;

    public SQLParserRule(SQLParserRuleConfiguration ruleConfig) {
        this.sqlCommentParseEnabled = ruleConfig.isSqlCommentParseEnabled();
        this.sqlStatementCache = ruleConfig.getSqlStatementCache();
        this.parseTreeCache = ruleConfig.getParseTreeCache();
    }

    public ShardingSphereSQLParserEngine getSQLParserEngine(String databaseType) {
        return new ShardingSphereSQLParserEngine(databaseType, this.sqlStatementCache, this.parseTreeCache, this.sqlCommentParseEnabled);
    }

    public String getType() {
        return SQLParserRule.class.getSimpleName();
    }

    @Generated
    public boolean isSqlCommentParseEnabled() {
        return this.sqlCommentParseEnabled;
    }

    @Generated
    public CacheOption getSqlStatementCache() {
        return this.sqlStatementCache;
    }

    @Generated
    public CacheOption getParseTreeCache() {
        return this.parseTreeCache;
    }
}

