/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.persist.service.impl;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.yaml.config.pojo.YamlRuleConfiguration;
import org.apache.shardingsphere.infra.yaml.config.swapper.YamlRuleConfigurationSwapperEngine;
import org.apache.shardingsphere.infra.yaml.engine.YamlEngine;
import org.apache.shardingsphere.mode.metadata.persist.node.DatabaseMetaDataNode;
import org.apache.shardingsphere.mode.metadata.persist.service.DatabaseBasedPersistService;
import org.apache.shardingsphere.mode.persist.PersistRepository;

public final class DatabaseRulePersistService
implements DatabaseBasedPersistService<Collection<RuleConfiguration>> {
    private static final String DEFAULT_VERSION = "0";
    private final PersistRepository repository;

    @Override
    public void persist(String databaseName, Collection<RuleConfiguration> configs, boolean isOverwrite) {
        if (!(configs.isEmpty() || !isOverwrite && this.isExisted(databaseName))) {
            this.persist(databaseName, configs);
        }
    }

    @Override
    public void persist(String databaseName, Collection<RuleConfiguration> configs) {
        if (Strings.isNullOrEmpty((String)this.getDatabaseActiveVersion(databaseName))) {
            this.repository.persist(DatabaseMetaDataNode.getActiveVersionPath(databaseName), DEFAULT_VERSION);
        }
        this.repository.persist(DatabaseMetaDataNode.getRulePath(databaseName, this.getDatabaseActiveVersion(databaseName)), YamlEngine.marshal(this.createYamlRuleConfigurations(configs)));
    }

    @Override
    public void persist(String databaseName, String version, Collection<RuleConfiguration> configs) {
        this.repository.persist(DatabaseMetaDataNode.getRulePath(databaseName, version), YamlEngine.marshal(this.createYamlRuleConfigurations(configs)));
    }

    private Collection<YamlRuleConfiguration> createYamlRuleConfigurations(Collection<RuleConfiguration> ruleConfigs) {
        return new YamlRuleConfigurationSwapperEngine().swapToYamlRuleConfigurations(ruleConfigs);
    }

    @Override
    public Collection<RuleConfiguration> load(String databaseName) {
        return this.isExisted(databaseName) ? new YamlRuleConfigurationSwapperEngine().swapToRuleConfigurations((Collection)YamlEngine.unmarshal((String)this.repository.get(DatabaseMetaDataNode.getRulePath(databaseName, this.getDatabaseActiveVersion(databaseName))), Collection.class, (boolean)true)) : new LinkedList<RuleConfiguration>();
    }

    @Override
    public Collection<RuleConfiguration> load(String databaseName, String version) {
        String yamlContent = this.repository.get(DatabaseMetaDataNode.getRulePath(databaseName, version));
        return Strings.isNullOrEmpty((String)yamlContent) ? new LinkedList<RuleConfiguration>() : new YamlRuleConfigurationSwapperEngine().swapToRuleConfigurations((Collection)YamlEngine.unmarshal((String)this.repository.get(DatabaseMetaDataNode.getRulePath(databaseName, this.getDatabaseActiveVersion(databaseName))), Collection.class, (boolean)true));
    }

    @Override
    public boolean isExisted(String databaseName) {
        return !Strings.isNullOrEmpty((String)this.getDatabaseActiveVersion(databaseName)) && !Strings.isNullOrEmpty((String)this.repository.get(DatabaseMetaDataNode.getRulePath(databaseName, this.getDatabaseActiveVersion(databaseName))));
    }

    private String getDatabaseActiveVersion(String databaseName) {
        return this.repository.get(DatabaseMetaDataNode.getActiveVersionPath(databaseName));
    }

    @Generated
    public DatabaseRulePersistService(PersistRepository repository) {
        this.repository = repository;
    }
}

