/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.persist.service;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.yaml.engine.YamlEngine;
import org.apache.shardingsphere.infra.yaml.schema.pojo.YamlTableMetaData;
import org.apache.shardingsphere.infra.yaml.schema.swapper.TableMetaDataYamlSwapper;
import org.apache.shardingsphere.mode.metadata.persist.node.DatabaseMetaDataNode;
import org.apache.shardingsphere.mode.persist.PersistRepository;

public final class SchemaMetaDataPersistService {
    private final PersistRepository repository;

    public void persistMetaData(String databaseName, String schemaName, ShardingSphereSchema schema) {
        Optional<ShardingSphereSchema> originalSchema = this.load(databaseName, schemaName);
        if (originalSchema.isPresent()) {
            this.compareAndPersist(databaseName, schemaName, schema, originalSchema.get());
            return;
        }
        this.persistMetaData(databaseName, schemaName, schema.getTables());
    }

    private void persistMetaData(String databaseName, String schemaName, Map<String, ShardingSphereTable> tables) {
        if (tables.isEmpty()) {
            this.persistSchema(databaseName, schemaName);
            return;
        }
        tables.forEach((key, value) -> this.repository.persist(DatabaseMetaDataNode.getTableMetaDataPath(databaseName, schemaName, key), YamlEngine.marshal((Object)new TableMetaDataYamlSwapper().swapToYamlConfiguration(value))));
    }

    public void persistTable(String databaseName, String schemaName, ShardingSphereTable table) {
        this.repository.persist(DatabaseMetaDataNode.getTableMetaDataPath(databaseName, schemaName, table.getName().toLowerCase()), YamlEngine.marshal((Object)new TableMetaDataYamlSwapper().swapToYamlConfiguration(table)));
    }

    public void persistSchema(String databaseName, String schemaName) {
        this.repository.persist(DatabaseMetaDataNode.getMetaDataTablesPath(databaseName, schemaName), "");
    }

    private void compareAndPersist(String databaseName, String schemaName, ShardingSphereSchema schema, ShardingSphereSchema originalSchema) {
        LinkedHashMap<String, ShardingSphereTable> cachedLocalTables = new LinkedHashMap<String, ShardingSphereTable>(schema.getTables());
        for (Map.Entry entry : originalSchema.getTables().entrySet()) {
            String onlineTableName = (String)entry.getKey();
            ShardingSphereTable localTableMetaData = (ShardingSphereTable)cachedLocalTables.remove(onlineTableName);
            if (null == localTableMetaData) {
                this.deleteTable(databaseName, schemaName, onlineTableName);
                continue;
            }
            if (localTableMetaData.equals(entry.getValue())) continue;
            this.persistTable(databaseName, schemaName, localTableMetaData);
        }
        if (!cachedLocalTables.isEmpty()) {
            this.persistMetaData(databaseName, schemaName, cachedLocalTables);
        }
    }

    public void deleteDatabase(String databaseName) {
        this.repository.delete(DatabaseMetaDataNode.getDatabaseNamePath(databaseName));
    }

    public void deleteSchema(String databaseName, String schemaName) {
        this.repository.delete(DatabaseMetaDataNode.getMetaDataSchemaPath(databaseName, schemaName));
    }

    public void deleteTable(String databaseName, String schemaName, String tableName) {
        this.repository.delete(DatabaseMetaDataNode.getTableMetaDataPath(databaseName, schemaName, tableName));
    }

    public Optional<ShardingSphereSchema> load(String databaseName, String schemaName) {
        List<String> tables = this.repository.getChildrenKeys(DatabaseMetaDataNode.getMetaDataTablesPath(databaseName, schemaName));
        if (tables.isEmpty()) {
            return Optional.empty();
        }
        ShardingSphereSchema schema = new ShardingSphereSchema();
        tables.forEach(each -> {
            String content = this.repository.get(DatabaseMetaDataNode.getTableMetaDataPath(databaseName, schemaName, each));
            ShardingSphereTable table = new TableMetaDataYamlSwapper().swapToObject((YamlTableMetaData)YamlEngine.unmarshal((String)content, YamlTableMetaData.class));
            schema.getTables().put(each, table);
        });
        return Optional.of(schema);
    }

    public Collection<String> loadAllDatabaseNames() {
        return this.repository.getChildrenKeys(DatabaseMetaDataNode.getMetaDataNodePath());
    }

    @Generated
    public SchemaMetaDataPersistService(PersistRepository repository) {
        this.repository = repository;
    }
}

