/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.persist.node;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.shardingsphere.infra.instance.definition.InstanceDefinition;
import org.apache.shardingsphere.infra.instance.definition.InstanceType;

public final class ComputeNode {
    private static final String ROOT_NODE = "nodes";
    private static final String COMPUTE_NODE = "compute_nodes";
    private static final String ONLINE_NODE = "online";
    private static final String LABELS_NODE = "labels";
    private static final String PROCESS_TRIGGER = "process_trigger";
    private static final String STATUS_NODE = "status";
    private static final String WORKER_ID = "worker_id";
    private static final String XA_RECOVERY_ID_NODE = "xa_recovery_id";

    public static String getOnlineNodePath(InstanceType instanceType) {
        return String.join((CharSequence)"/", "", ROOT_NODE, COMPUTE_NODE, ONLINE_NODE, instanceType.name().toLowerCase());
    }

    public static String getOnlineInstanceNodePath(String instanceId, InstanceType instanceType) {
        return String.join((CharSequence)"/", "", ROOT_NODE, COMPUTE_NODE, ONLINE_NODE, instanceType.name().toLowerCase(), instanceId);
    }

    public static String getOnlineInstanceNodePath() {
        return String.join((CharSequence)"/", "", ROOT_NODE, COMPUTE_NODE, ONLINE_NODE);
    }

    public static String getProcessTriggerNodePatch() {
        return String.join((CharSequence)"/", "", ROOT_NODE, COMPUTE_NODE, PROCESS_TRIGGER);
    }

    public static String getProcessTriggerInstanceIdNodePath(String instanceId, String showProcessListId) {
        return String.join((CharSequence)"/", "", ROOT_NODE, COMPUTE_NODE, PROCESS_TRIGGER, String.join((CharSequence)":", instanceId, showProcessListId));
    }

    public static String getInstanceLabelsNodePath(String instanceId) {
        return String.join((CharSequence)"/", "", ROOT_NODE, COMPUTE_NODE, LABELS_NODE, instanceId);
    }

    public static String getXaRecoveryIdNodePath() {
        return String.join((CharSequence)"/", "", ROOT_NODE, COMPUTE_NODE, XA_RECOVERY_ID_NODE);
    }

    public static String getInstanceXaRecoveryIdNodePath(String xaRecoveryId, String instanceId) {
        return String.join((CharSequence)"/", "", ROOT_NODE, COMPUTE_NODE, XA_RECOVERY_ID_NODE, xaRecoveryId, instanceId);
    }

    public static String getComputeNodePath() {
        return String.join((CharSequence)"/", "", ROOT_NODE, COMPUTE_NODE);
    }

    public static String getInstanceWorkerIdNodePath(String instanceId) {
        return String.join((CharSequence)"/", "", ROOT_NODE, COMPUTE_NODE, WORKER_ID, instanceId);
    }

    public static String getInstanceIdByComputeNode(String computeNodePath) {
        Pattern pattern = Pattern.compile(ComputeNode.getComputeNodePath() + "(/status|/worker_id|/labels)/([\\S]+)$", 2);
        Matcher matcher = pattern.matcher(computeNodePath);
        return matcher.find() ? matcher.group(2) : "";
    }

    public static String getInstanceStatusNodePath(String instanceId) {
        return String.join((CharSequence)"/", "", ROOT_NODE, COMPUTE_NODE, STATUS_NODE, instanceId);
    }

    public static Optional<InstanceDefinition> getInstanceDefinitionByInstanceOnlinePath(String onlineInstancePath) {
        Pattern pattern = Pattern.compile(ComputeNode.getOnlineInstanceNodePath() + "/(proxy|jdbc)/([\\S]+)$", 2);
        Matcher matcher = pattern.matcher(onlineInstancePath);
        return matcher.find() ? Optional.of(new InstanceDefinition(ComputeNode.getInstanceType(matcher.group(1)), matcher.group(2))) : Optional.empty();
    }

    private static InstanceType getInstanceType(String instanceType) {
        return InstanceType.PROXY.name().equalsIgnoreCase(instanceType) ? InstanceType.PROXY : InstanceType.JDBC;
    }
}

