/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata;

import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.config.database.DatabaseConfiguration;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.federation.optimizer.context.OptimizerContextFactory;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.rule.ShardingSphereRuleMetaData;
import org.apache.shardingsphere.infra.rule.builder.global.GlobalRulesBuilder;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.mode.metadata.persist.MetaDataPersistService;

public final class MetaDataContextsBuilder {
    private final Map<String, DatabaseConfiguration> databaseConfigMap;
    private final Collection<RuleConfiguration> globalRuleConfigs;
    private final ConfigurationProperties props;

    public MetaDataContexts build(MetaDataPersistService metaDataPersistService) throws SQLException {
        DatabaseType protocolType = DatabaseTypeEngine.getProtocolType(this.databaseConfigMap, (ConfigurationProperties)this.props);
        DatabaseType storageType = DatabaseTypeEngine.getStorageType(this.databaseConfigMap);
        Map<String, ShardingSphereDatabase> databases = this.getDatabases(protocolType, storageType);
        ShardingSphereRuleMetaData globalMetaData = new ShardingSphereRuleMetaData(this.globalRuleConfigs, GlobalRulesBuilder.buildRules(this.globalRuleConfigs, databases));
        ShardingSphereMetaData metaData = new ShardingSphereMetaData(databases, globalMetaData, this.props);
        return new MetaDataContexts(metaDataPersistService, metaData, OptimizerContextFactory.create(databases, (ShardingSphereRuleMetaData)globalMetaData));
    }

    private Map<String, ShardingSphereDatabase> getDatabases(DatabaseType protocolType, DatabaseType storageType) throws SQLException {
        HashMap<String, ShardingSphereDatabase> result = new HashMap<String, ShardingSphereDatabase>(this.databaseConfigMap.size() + protocolType.getSystemDatabaseSchemaMap().size(), 1.0f);
        result.putAll(this.getGenericDatabases(protocolType, storageType));
        result.putAll(this.getSystemDatabases(protocolType));
        return result;
    }

    private Map<String, ShardingSphereDatabase> getGenericDatabases(DatabaseType protocolType, DatabaseType storageType) throws SQLException {
        HashMap<String, ShardingSphereDatabase> result = new HashMap<String, ShardingSphereDatabase>(this.databaseConfigMap.size(), 1.0f);
        for (Map.Entry<String, DatabaseConfiguration> entry : this.databaseConfigMap.entrySet()) {
            String databaseName = entry.getKey();
            if (entry.getValue().getDataSources().isEmpty() && protocolType.getSystemSchemas().contains(databaseName)) continue;
            result.put(databaseName, ShardingSphereDatabase.create((String)databaseName, (DatabaseType)protocolType, (DatabaseType)storageType, (DatabaseConfiguration)entry.getValue(), (ConfigurationProperties)this.props));
        }
        return result;
    }

    private Map<String, ShardingSphereDatabase> getSystemDatabases(DatabaseType protocolType) throws SQLException {
        HashMap<String, ShardingSphereDatabase> result = new HashMap<String, ShardingSphereDatabase>(protocolType.getSystemDatabaseSchemaMap().size(), 1.0f);
        for (String each : protocolType.getSystemDatabaseSchemaMap().keySet()) {
            if (this.databaseConfigMap.containsKey(each) && !this.databaseConfigMap.get(each).getDataSources().isEmpty()) continue;
            result.put(each, ShardingSphereDatabase.create((String)each, (DatabaseType)protocolType));
        }
        return result;
    }

    @Generated
    public MetaDataContextsBuilder(Map<String, DatabaseConfiguration> databaseConfigMap, Collection<RuleConfiguration> globalRuleConfigs, ConfigurationProperties props) {
        this.databaseConfigMap = databaseConfigMap;
        this.globalRuleConfigs = globalRuleConfigs;
        this.props = props;
    }
}

