/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.config.database.DatabaseConfiguration;
import org.apache.shardingsphere.infra.config.database.impl.DataSourceProvidedDatabaseConfiguration;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.datasource.pool.creator.DataSourcePoolCreator;
import org.apache.shardingsphere.infra.datasource.props.DataSourceProperties;
import org.apache.shardingsphere.infra.datasource.props.DataSourcePropertiesCreator;
import org.apache.shardingsphere.infra.executor.kernel.ExecutorEngine;
import org.apache.shardingsphere.infra.federation.optimizer.context.planner.OptimizerPlannerContextFactory;
import org.apache.shardingsphere.infra.federation.optimizer.metadata.FederationDatabaseMetaData;
import org.apache.shardingsphere.infra.instance.InstanceContext;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.resource.ShardingSphereResource;
import org.apache.shardingsphere.infra.metadata.database.rule.ShardingSphereRuleMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.builder.GenericSchemaBuilder;
import org.apache.shardingsphere.infra.metadata.database.schema.builder.GenericSchemaBuilderMaterials;
import org.apache.shardingsphere.infra.metadata.database.schema.builder.SystemSchemaBuilder;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.rule.builder.global.GlobalRulesBuilder;
import org.apache.shardingsphere.infra.rule.builder.schema.DatabaseRulesBuilder;
import org.apache.shardingsphere.infra.rule.identifier.type.DataNodeContainedRule;
import org.apache.shardingsphere.infra.rule.identifier.type.MutableDataNodeRule;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.mode.metadata.MetaDataContextsBuilder;
import org.apache.shardingsphere.mode.metadata.persist.MetaDataPersistService;
import org.apache.shardingsphere.transaction.ShardingSphereTransactionManagerEngine;
import org.apache.shardingsphere.transaction.config.TransactionRuleConfiguration;
import org.apache.shardingsphere.transaction.context.TransactionContexts;
import org.apache.shardingsphere.transaction.rule.TransactionRule;
import org.apache.shardingsphere.transaction.rule.builder.DefaultTransactionRuleConfigurationBuilder;
import org.apache.shardingsphere.transaction.spi.TransactionConfigurationFileGeneratorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ContextManager
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ContextManager.class);
    private volatile MetaDataContexts metaDataContexts;
    private volatile TransactionContexts transactionContexts;
    private final InstanceContext instanceContext;
    private final ExecutorEngine executorEngine;

    public ContextManager(MetaDataContexts metaDataContexts, TransactionContexts transactionContexts, InstanceContext instanceContext) {
        this.metaDataContexts = metaDataContexts;
        this.transactionContexts = transactionContexts;
        this.instanceContext = instanceContext;
        this.executorEngine = ExecutorEngine.createExecutorEngineWithSize((int)((Integer)metaDataContexts.getMetaData().getProps().getValue((Enum)ConfigurationPropertyKey.KERNEL_EXECUTOR_SIZE)));
    }

    public synchronized void renewMetaDataContexts(MetaDataContexts metaDataContexts) {
        this.metaDataContexts = metaDataContexts;
    }

    public synchronized void renewTransactionContexts(TransactionContexts transactionContexts) {
        this.transactionContexts = transactionContexts;
    }

    public Map<String, DataSource> getDataSourceMap(String databaseName) {
        return ((ShardingSphereDatabase)this.metaDataContexts.getMetaData().getDatabases().get(databaseName)).getResource().getDataSources();
    }

    public void addDatabase(String databaseName) throws SQLException {
        if (this.metaDataContexts.getMetaData().getDatabases().containsKey(databaseName)) {
            return;
        }
        MetaDataContexts newMetaDataContexts = this.createMetaDataContext(databaseName);
        FederationDatabaseMetaData federationDatabaseMetaData = (FederationDatabaseMetaData)newMetaDataContexts.getOptimizerContext().getFederationMetaData().getDatabases().get(databaseName);
        this.metaDataContexts.getOptimizerContext().getFederationMetaData().getDatabases().put(databaseName, federationDatabaseMetaData);
        this.metaDataContexts.getOptimizerContext().getPlannerContexts().put(databaseName, OptimizerPlannerContextFactory.create((FederationDatabaseMetaData)federationDatabaseMetaData));
        this.metaDataContexts.getMetaData().getDatabases().put(databaseName, (ShardingSphereDatabase)newMetaDataContexts.getMetaData().getDatabases().get(databaseName));
        this.persistMetaData(this.metaDataContexts);
        this.renewAllTransactionContext();
    }

    private MetaDataContexts createMetaDataContext(String databaseName) throws SQLException {
        MetaDataContextsBuilder builder = new MetaDataContextsBuilder(Collections.singletonMap(databaseName, new DataSourceProvidedDatabaseConfiguration(new HashMap(), new LinkedList())), this.metaDataContexts.getMetaData().getGlobalRuleMetaData().getConfigurations(), this.metaDataContexts.getMetaData().getProps());
        return builder.build(this.metaDataContexts.getPersistService().orElse(null));
    }

    public void addSchema(String databaseName, String schemaName) {
        if (null != ((ShardingSphereDatabase)this.metaDataContexts.getMetaData().getDatabases().get(databaseName)).getSchemas().get(schemaName)) {
            return;
        }
        FederationDatabaseMetaData federationDatabaseMetaData = (FederationDatabaseMetaData)this.metaDataContexts.getOptimizerContext().getFederationMetaData().getDatabases().get(databaseName);
        federationDatabaseMetaData.putTable(schemaName, new ShardingSphereTable());
        this.metaDataContexts.getOptimizerContext().getPlannerContexts().put(databaseName, OptimizerPlannerContextFactory.create((FederationDatabaseMetaData)federationDatabaseMetaData));
        ((ShardingSphereDatabase)this.metaDataContexts.getMetaData().getDatabases().get(databaseName)).getSchemas().put(schemaName, new ShardingSphereSchema());
    }

    public void alterSchemas(String databaseName, Map<String, ShardingSphereSchema> schemas) {
        ShardingSphereDatabase alteredMetaData = new ShardingSphereDatabase(databaseName, ((ShardingSphereDatabase)this.metaDataContexts.getMetaData().getDatabases().get(databaseName)).getProtocolType(), ((ShardingSphereDatabase)this.metaDataContexts.getMetaData().getDatabases().get(databaseName)).getResource(), ((ShardingSphereDatabase)this.metaDataContexts.getMetaData().getDatabases().get(databaseName)).getRuleMetaData(), schemas);
        HashMap<String, ShardingSphereDatabase> alteredDatabases = new HashMap<String, ShardingSphereDatabase>(this.metaDataContexts.getMetaData().getDatabases());
        alteredDatabases.put(databaseName, alteredMetaData);
        FederationDatabaseMetaData alteredDatabaseMetaData = new FederationDatabaseMetaData(databaseName, schemas);
        this.metaDataContexts.getOptimizerContext().getFederationMetaData().getDatabases().put(databaseName, alteredDatabaseMetaData);
        this.metaDataContexts.getOptimizerContext().getPlannerContexts().put(databaseName, OptimizerPlannerContextFactory.create((FederationDatabaseMetaData)alteredDatabaseMetaData));
        this.renewMetaDataContexts(this.rebuildMetaDataContexts(new ShardingSphereMetaData(alteredDatabases, this.metaDataContexts.getMetaData().getGlobalRuleMetaData(), this.metaDataContexts.getMetaData().getProps())));
    }

    public void alterSchema(String databaseName, String schemaName, ShardingSphereTable changedTableMetaData, String deletedTable) {
        if (null != this.metaDataContexts.getMetaData().getDatabases().get(databaseName)) {
            Optional.ofNullable(changedTableMetaData).ifPresent(optional -> this.alterTableSchema(databaseName, schemaName, (ShardingSphereTable)optional));
            Optional.ofNullable(deletedTable).ifPresent(optional -> this.deleteTable(databaseName, schemaName, (String)optional));
        }
    }

    private void persistMetaData(MetaDataContexts metaDataContexts) {
        metaDataContexts.getMetaData().getDatabases().forEach((databaseName, schemas) -> schemas.getSchemas().forEach((schemaName, tables) -> metaDataContexts.getPersistService().ifPresent(optional -> optional.getSchemaMetaDataService().persistMetaData((String)databaseName, (String)schemaName, (ShardingSphereSchema)tables))));
    }

    private void alterTableSchema(String databaseName, String schemaName, ShardingSphereTable changedTableMetaData) {
        ShardingSphereDatabase database = (ShardingSphereDatabase)this.metaDataContexts.getMetaData().getDatabases().get(databaseName);
        this.alterSingleTableDataNodes(databaseName, database, changedTableMetaData);
        FederationDatabaseMetaData federationDatabaseMetaData = (FederationDatabaseMetaData)this.metaDataContexts.getOptimizerContext().getFederationMetaData().getDatabases().get(databaseName);
        ((ShardingSphereSchema)database.getSchemas().get(schemaName)).put(changedTableMetaData.getName(), changedTableMetaData);
        federationDatabaseMetaData.putTable(schemaName, changedTableMetaData);
        this.metaDataContexts.getOptimizerContext().getPlannerContexts().put(databaseName, OptimizerPlannerContextFactory.create((FederationDatabaseMetaData)federationDatabaseMetaData));
    }

    private void alterSingleTableDataNodes(String databaseName, ShardingSphereDatabase database, ShardingSphereTable changedTableMetaData) {
        if (!this.containsInImmutableDataNodeContainedRule(changedTableMetaData.getName(), database)) {
            this.refreshRules(databaseName, database);
        }
    }

    private void refreshRules(String databaseName, ShardingSphereDatabase database) {
        Collection databaseRules = DatabaseRulesBuilder.build((String)databaseName, (DatabaseConfiguration)new DataSourceProvidedDatabaseConfiguration(database.getResource().getDataSources(), database.getRuleMetaData().getConfigurations()), (ConfigurationProperties)new ConfigurationProperties(this.metaDataContexts.getMetaData().getProps().getProps()));
        database.getRuleMetaData().getRules().clear();
        database.getRuleMetaData().getRules().addAll(databaseRules);
    }

    private void deleteTable(String databaseName, String schemaName, String deletedTable) {
        if (null != ((ShardingSphereDatabase)this.metaDataContexts.getMetaData().getDatabases().get(databaseName)).getSchemas().get(schemaName)) {
            ((ShardingSphereSchema)((ShardingSphereDatabase)this.metaDataContexts.getMetaData().getDatabases().get(databaseName)).getSchemas().get(schemaName)).remove(deletedTable);
            FederationDatabaseMetaData databaseMetaData = (FederationDatabaseMetaData)this.metaDataContexts.getOptimizerContext().getFederationMetaData().getDatabases().get(databaseName);
            databaseMetaData.removeTableMetadata(schemaName, deletedTable);
            this.metaDataContexts.getOptimizerContext().getPlannerContexts().put(databaseName, OptimizerPlannerContextFactory.create((FederationDatabaseMetaData)databaseMetaData));
        }
    }

    private boolean containsInImmutableDataNodeContainedRule(String tableName, ShardingSphereDatabase schemaMetaData) {
        return schemaMetaData.getRuleMetaData().findRules(DataNodeContainedRule.class).stream().filter(each -> !(each instanceof MutableDataNodeRule)).anyMatch(each -> each.getAllTables().contains(tableName));
    }

    public void deleteDatabase(String databaseName) {
        if (this.metaDataContexts.getMetaData().getDatabases().containsKey(databaseName)) {
            this.metaDataContexts.getOptimizerContext().getFederationMetaData().getDatabases().remove(databaseName);
            this.metaDataContexts.getOptimizerContext().getParserContexts().remove(databaseName);
            this.metaDataContexts.getOptimizerContext().getPlannerContexts().remove(databaseName);
            ShardingSphereDatabase removeMetaData = (ShardingSphereDatabase)this.metaDataContexts.getMetaData().getDatabases().remove(databaseName);
            this.closeDataSources(removeMetaData);
            this.removeAndCloseTransactionEngine(databaseName);
            this.metaDataContexts.getPersistService().ifPresent(optional -> optional.getSchemaMetaDataService().deleteDatabase(databaseName));
        }
    }

    public void dropSchema(String databaseName, String schemaName) {
        ShardingSphereDatabase database = (ShardingSphereDatabase)this.metaDataContexts.getMetaData().getDatabases().get(databaseName);
        if (null == database || null == database.getSchemas().get(schemaName)) {
            return;
        }
        FederationDatabaseMetaData federationDatabaseMetaData = (FederationDatabaseMetaData)this.metaDataContexts.getOptimizerContext().getFederationMetaData().getDatabases().get(databaseName);
        federationDatabaseMetaData.removeSchemaMetadata(schemaName);
        database.getSchemas().remove(schemaName);
    }

    public void addResource(String databaseName, Map<String, DataSourceProperties> dataSourcePropsMap) throws SQLException {
        this.refreshMetaDataContext(databaseName, dataSourcePropsMap);
        this.metaDataContexts.getPersistService().ifPresent(optional -> optional.getDataSourceService().append(databaseName, dataSourcePropsMap));
    }

    public void alterResource(String databaseName, Map<String, DataSourceProperties> dataSourcePropsMap) throws SQLException {
        this.refreshMetaDataContext(databaseName, dataSourcePropsMap);
        this.metaDataContexts.getPersistService().ifPresent(optional -> optional.getDataSourceService().append(databaseName, dataSourcePropsMap));
    }

    public void dropResource(String databaseName, Collection<String> toBeDroppedResourceNames) {
        toBeDroppedResourceNames.forEach(((ShardingSphereDatabase)this.metaDataContexts.getMetaData().getDatabases().get(databaseName)).getResource().getDataSources()::remove);
        this.metaDataContexts.getPersistService().ifPresent(optional -> optional.getDataSourceService().drop(databaseName, toBeDroppedResourceNames));
    }

    public void alterRuleConfiguration(String databaseName, Collection<RuleConfiguration> ruleConfigs) {
        try {
            MetaDataContexts changedMetaDataContexts = this.buildChangedMetaDataContext((ShardingSphereDatabase)this.metaDataContexts.getMetaData().getDatabases().get(databaseName), ruleConfigs);
            this.metaDataContexts.getOptimizerContext().getFederationMetaData().getDatabases().putAll(changedMetaDataContexts.getOptimizerContext().getFederationMetaData().getDatabases());
            this.renewMetaDataContexts(this.rebuildMetaDataContexts(changedMetaDataContexts.getMetaData()));
        }
        catch (SQLException ex) {
            log.error("Alter database:{} rule configuration failed", (Object)databaseName, (Object)ex);
        }
    }

    public void alterDataSourceConfiguration(String databaseName, Map<String, DataSourceProperties> dataSourcePropsMap) {
        try {
            MetaDataContexts changedMetaDataContext = this.buildChangedMetaDataContextWithChangedDataSource((ShardingSphereDatabase)this.metaDataContexts.getMetaData().getDatabases().get(databaseName), dataSourcePropsMap);
            this.refreshMetaDataContext(databaseName, changedMetaDataContext, dataSourcePropsMap);
        }
        catch (SQLException ex) {
            log.error("Alter database:{} data source configuration failed", (Object)databaseName, (Object)ex);
        }
    }

    public void alterDataSourceAndRuleConfiguration(String databaseName, Map<String, DataSourceProperties> dataSourcePropsMap, Collection<RuleConfiguration> ruleConfigs) {
        try {
            MetaDataContexts changedMetaDataContext = this.buildChangedMetaDataContextWithChangedDataSourceAndRule((ShardingSphereDatabase)this.metaDataContexts.getMetaData().getDatabases().get(databaseName), dataSourcePropsMap, ruleConfigs);
            this.refreshMetaDataContext(databaseName, changedMetaDataContext, dataSourcePropsMap);
        }
        catch (SQLException ex) {
            log.error("Alter database:{} data source and rule configuration failed", (Object)databaseName, (Object)ex);
        }
    }

    public void alterGlobalRuleConfiguration(Collection<RuleConfiguration> ruleConfigs) {
        if (!ruleConfigs.isEmpty()) {
            boolean needRenewTransaction = this.isNeedRenewTransactionContext(ruleConfigs);
            ShardingSphereRuleMetaData newGlobalRuleMetaData = new ShardingSphereRuleMetaData(ruleConfigs, GlobalRulesBuilder.buildRules(ruleConfigs, (Map)this.metaDataContexts.getMetaData().getDatabases()));
            this.renewMetaDataContexts(this.rebuildMetaDataContexts(newGlobalRuleMetaData));
            if (needRenewTransaction) {
                this.renewAllTransactionContext();
            }
        }
    }

    private boolean isNeedRenewTransactionContext(Collection<RuleConfiguration> ruleConfigs) {
        Optional<RuleConfiguration> newConfig = ruleConfigs.stream().filter(each -> each instanceof TransactionRuleConfiguration).findFirst();
        Optional oldConfig = this.metaDataContexts.getMetaData().getGlobalRuleMetaData().findSingleRuleConfiguration(TransactionRuleConfiguration.class);
        return newConfig.isPresent() && oldConfig.isPresent() && !newConfig.get().equals(oldConfig.get());
    }

    public void alterProperties(Properties props) {
        this.renewMetaDataContexts(this.rebuildMetaDataContexts(new ConfigurationProperties(props)));
    }

    public void reloadMetaData(String databaseName) {
        try {
            Map<String, ShardingSphereSchema> schemas = this.loadActualSchema(databaseName);
            this.deleteSchemas(databaseName, schemas);
            this.alterSchemas(databaseName, schemas);
            this.persistMetaData(this.metaDataContexts);
        }
        catch (SQLException ex) {
            log.error("Reload database:{} failed", (Object)databaseName, (Object)ex);
        }
    }

    public void reloadMetaData(String databaseName, String schemaName, String tableName) {
        try {
            ShardingSphereDatabase database = (ShardingSphereDatabase)this.metaDataContexts.getMetaData().getDatabases().get(databaseName);
            GenericSchemaBuilderMaterials materials = new GenericSchemaBuilderMaterials(database.getProtocolType(), database.getResource().getDatabaseType(), database.getResource().getDataSources(), database.getRuleMetaData().getRules(), this.metaDataContexts.getMetaData().getProps(), schemaName);
            this.loadTableMetaData(databaseName, schemaName, tableName, materials);
        }
        catch (SQLException ex) {
            log.error("Reload table:{} meta data of database:{} schema:{} failed", new Object[]{tableName, databaseName, schemaName, ex});
        }
    }

    public void reloadMetaData(String databaseName, String schemaName, String dataSourceName, String tableName) {
        try {
            ShardingSphereDatabase database = (ShardingSphereDatabase)this.metaDataContexts.getMetaData().getDatabases().get(databaseName);
            GenericSchemaBuilderMaterials materials = new GenericSchemaBuilderMaterials(database.getProtocolType(), database.getResource().getDatabaseType(), Collections.singletonMap(dataSourceName, (DataSource)database.getResource().getDataSources().get(dataSourceName)), database.getRuleMetaData().getRules(), this.metaDataContexts.getMetaData().getProps(), schemaName);
            this.loadTableMetaData(databaseName, schemaName, tableName, materials);
        }
        catch (SQLException ex) {
            log.error("Reload table:{} meta data of database:{} schema:{} with data source:{} failed", new Object[]{tableName, databaseName, schemaName, dataSourceName, ex});
        }
    }

    public void reloadSchemaMetaData(String databaseName, String schemaName, String dataSourceName) {
        try {
            ShardingSphereDatabase database = (ShardingSphereDatabase)this.metaDataContexts.getMetaData().getDatabases().get(databaseName);
            this.refreshRules(databaseName, database);
            GenericSchemaBuilderMaterials materials = new GenericSchemaBuilderMaterials(database.getProtocolType(), database.getResource().getDatabaseType(), Collections.singletonMap(dataSourceName, (DataSource)database.getResource().getDataSources().get(dataSourceName)), database.getRuleMetaData().getRules(), this.metaDataContexts.getMetaData().getProps(), schemaName);
            this.loadTableMetaData(databaseName, schemaName, materials);
        }
        catch (SQLException ex) {
            log.error("Reload meta data of database:{} schema:{} with data source:{} failed", new Object[]{databaseName, schemaName, dataSourceName, ex});
        }
    }

    private void deleteSchemas(String databaseName, Map<String, ShardingSphereSchema> actualSchemas) {
        Map originalSchemas = ((ShardingSphereDatabase)this.metaDataContexts.getMetaData().getDatabases().get(databaseName)).getSchemas();
        if (originalSchemas.isEmpty()) {
            return;
        }
        originalSchemas.forEach((key, value) -> {
            if (null == actualSchemas.get(key)) {
                this.metaDataContexts.getPersistService().ifPresent(optional -> optional.getSchemaMetaDataService().deleteSchema(databaseName, (String)key));
            }
        });
    }

    private void loadTableMetaData(String databaseName, String schemaName, GenericSchemaBuilderMaterials materials) throws SQLException {
        Map schemaMap = GenericSchemaBuilder.build((GenericSchemaBuilderMaterials)materials);
        if (schemaMap.containsKey(schemaName)) {
            ((ShardingSphereDatabase)this.metaDataContexts.getMetaData().getDatabases().get(databaseName)).getSchemas().put(schemaName, (ShardingSphereSchema)schemaMap.get(schemaName));
            this.metaDataContexts.getPersistService().ifPresent(optional -> optional.getSchemaMetaDataService().persistMetaData(databaseName, schemaName, (ShardingSphereSchema)((ShardingSphereDatabase)this.metaDataContexts.getMetaData().getDatabases().get(databaseName)).getSchemas().get(schemaName)));
        }
    }

    private void loadTableMetaData(String databaseName, String schemaName, String tableName, GenericSchemaBuilderMaterials materials) throws SQLException {
        ShardingSphereSchema schema = GenericSchemaBuilder.build(Collections.singletonList(tableName), (GenericSchemaBuilderMaterials)materials).getOrDefault(schemaName, new ShardingSphereSchema());
        if (schema.getTables().containsKey(tableName)) {
            ((ShardingSphereSchema)((ShardingSphereDatabase)this.metaDataContexts.getMetaData().getDatabases().get(databaseName)).getSchemas().get(schemaName)).put(tableName, (ShardingSphereTable)schema.getTables().get(tableName));
            this.metaDataContexts.getPersistService().ifPresent(optional -> optional.getSchemaMetaDataService().persistMetaData(databaseName, schemaName, (ShardingSphereSchema)((ShardingSphereDatabase)this.metaDataContexts.getMetaData().getDatabases().get(databaseName)).getSchemas().get(schemaName)));
        }
    }

    private Map<String, ShardingSphereSchema> loadActualSchema(String databaseName) throws SQLException {
        ShardingSphereDatabase database = (ShardingSphereDatabase)this.metaDataContexts.getMetaData().getDatabases().get(databaseName);
        Map dataSourceMap = database.getResource().getDataSources();
        this.refreshRules(databaseName, database);
        DatabaseType databaseType = DatabaseTypeEngine.getDatabaseType(dataSourceMap.values());
        ConcurrentHashMap<String, ShardingSphereSchema> result = new ConcurrentHashMap<String, ShardingSphereSchema>();
        GenericSchemaBuilderMaterials materials = new GenericSchemaBuilderMaterials(database.getProtocolType(), databaseType, dataSourceMap, database.getRuleMetaData().getRules(), this.metaDataContexts.getMetaData().getProps(), databaseName);
        result.putAll(GenericSchemaBuilder.build((GenericSchemaBuilderMaterials)materials));
        result.putAll(SystemSchemaBuilder.build((String)databaseName, (DatabaseType)database.getProtocolType()));
        return result;
    }

    private Collection<DataSource> getPendingClosedDataSources(String databaseName, Map<String, DataSourceProperties> dataSourcePropsMap) {
        LinkedList<DataSource> result = new LinkedList<DataSource>();
        result.addAll(this.getDeletedDataSources((ShardingSphereDatabase)this.metaDataContexts.getMetaData().getDatabases().get(databaseName), dataSourcePropsMap).values());
        result.addAll(this.getChangedDataSources((ShardingSphereDatabase)this.metaDataContexts.getMetaData().getDatabases().get(databaseName), dataSourcePropsMap).values());
        return result;
    }

    private Map<String, DataSource> getDeletedDataSources(ShardingSphereDatabase originalMetaData, Map<String, DataSourceProperties> newDataSourcePropsMap) {
        return originalMetaData.getResource().getDataSources().entrySet().stream().filter(entry -> !newDataSourcePropsMap.containsKey(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Map<String, DataSource> getChangedDataSources(ShardingSphereDatabase originalMetaData, Map<String, DataSourceProperties> newDataSourcePropsMap) {
        Set<String> changedDataSourceNames = this.getChangedDataSourceConfiguration(originalMetaData, newDataSourcePropsMap).keySet();
        return originalMetaData.getResource().getDataSources().entrySet().stream().filter(entry -> changedDataSourceNames.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Map<String, DataSourceProperties> getChangedDataSourceConfiguration(ShardingSphereDatabase originalMetaData, Map<String, DataSourceProperties> dataSourcePropsMap) {
        return dataSourcePropsMap.entrySet().stream().filter(entry -> this.isModifiedDataSource(originalMetaData.getResource().getDataSources(), (String)entry.getKey(), (DataSourceProperties)entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
    }

    private boolean isModifiedDataSource(Map<String, DataSource> originalDataSources, String dataSourceName, DataSourceProperties dataSourceProps) {
        return originalDataSources.containsKey(dataSourceName) && !dataSourceProps.equals((Object)DataSourcePropertiesCreator.create((DataSource)originalDataSources.get(dataSourceName)));
    }

    private MetaDataContexts rebuildMetaDataContexts(ShardingSphereMetaData changedMetaData) {
        return new MetaDataContexts(this.metaDataContexts.getPersistService().orElse(null), changedMetaData, this.metaDataContexts.getOptimizerContext());
    }

    private MetaDataContexts rebuildMetaDataContexts(ShardingSphereRuleMetaData globalRuleMetaData) {
        ShardingSphereMetaData changedMetaData = new ShardingSphereMetaData(this.metaDataContexts.getMetaData().getDatabases(), globalRuleMetaData, this.metaDataContexts.getMetaData().getProps());
        return new MetaDataContexts(this.metaDataContexts.getPersistService().orElse(null), changedMetaData, this.metaDataContexts.getOptimizerContext());
    }

    private MetaDataContexts rebuildMetaDataContexts(ConfigurationProperties props) {
        ShardingSphereMetaData changedMetaData = new ShardingSphereMetaData(this.metaDataContexts.getMetaData().getDatabases(), this.metaDataContexts.getMetaData().getGlobalRuleMetaData(), props);
        return new MetaDataContexts(this.metaDataContexts.getPersistService().orElse(null), changedMetaData, this.metaDataContexts.getOptimizerContext());
    }

    private void refreshMetaDataContext(String databaseName, Map<String, DataSourceProperties> dataSourceProps) throws SQLException {
        MetaDataContexts changedMetaDataContext = this.buildChangedMetaDataContextWithAddedDataSource((ShardingSphereDatabase)this.metaDataContexts.getMetaData().getDatabases().get(databaseName), dataSourceProps);
        this.metaDataContexts.getMetaData().getDatabases().putAll(changedMetaDataContext.getMetaData().getDatabases());
        this.metaDataContexts.getOptimizerContext().getFederationMetaData().getDatabases().putAll(changedMetaDataContext.getOptimizerContext().getFederationMetaData().getDatabases());
        this.metaDataContexts.getOptimizerContext().getParserContexts().putAll(changedMetaDataContext.getOptimizerContext().getParserContexts());
        this.metaDataContexts.getOptimizerContext().getPlannerContexts().putAll(changedMetaDataContext.getOptimizerContext().getPlannerContexts());
        this.renewTransactionContext(databaseName, ((ShardingSphereDatabase)this.metaDataContexts.getMetaData().getDatabases().get(databaseName)).getResource());
    }

    private void refreshMetaDataContext(String databaseName, MetaDataContexts changedMetaDataContext, Map<String, DataSourceProperties> dataSourcePropsMap) {
        this.metaDataContexts.getOptimizerContext().getFederationMetaData().getDatabases().putAll(changedMetaDataContext.getOptimizerContext().getFederationMetaData().getDatabases());
        HashMap databases = new HashMap(this.metaDataContexts.getMetaData().getDatabases());
        databases.putAll(changedMetaDataContext.getMetaData().getDatabases());
        Collection<DataSource> pendingClosedDataSources = this.getPendingClosedDataSources(databaseName, dataSourcePropsMap);
        this.renewMetaDataContexts(this.rebuildMetaDataContexts(new ShardingSphereMetaData(databases, this.metaDataContexts.getMetaData().getGlobalRuleMetaData(), this.metaDataContexts.getMetaData().getProps())));
        this.renewTransactionContext(databaseName, ((ShardingSphereDatabase)this.metaDataContexts.getMetaData().getDatabases().get(databaseName)).getResource());
        this.closeDataSources(databaseName, pendingClosedDataSources);
    }

    private MetaDataContexts buildChangedMetaDataContextWithAddedDataSource(ShardingSphereDatabase originalDatabase, Map<String, DataSourceProperties> addedDataSourceProps) throws SQLException {
        HashMap dataSourceMap = new HashMap(originalDatabase.getResource().getDataSources());
        dataSourceMap.putAll(DataSourcePoolCreator.create(addedDataSourceProps));
        DataSourceProvidedDatabaseConfiguration databaseConfig = new DataSourceProvidedDatabaseConfiguration(dataSourceMap, originalDatabase.getRuleMetaData().getConfigurations());
        Optional<MetaDataPersistService> metaDataPersistService = this.metaDataContexts.getPersistService();
        metaDataPersistService.ifPresent(arg_0 -> this.lambda$buildChangedMetaDataContextWithAddedDataSource$20((DatabaseConfiguration)databaseConfig, arg_0));
        MetaDataContextsBuilder builder = new MetaDataContextsBuilder(Collections.singletonMap(originalDatabase.getName(), databaseConfig), this.metaDataContexts.getMetaData().getGlobalRuleMetaData().getConfigurations(), this.metaDataContexts.getMetaData().getProps());
        MetaDataContexts result = builder.build(this.metaDataContexts.getPersistService().orElse(null));
        this.persistMetaData(result);
        return result;
    }

    private void persistTransactionConfiguration(DatabaseConfiguration databaseConfig, MetaDataPersistService metaDataPersistService) {
        Optional fileGenerator = TransactionConfigurationFileGeneratorFactory.findInstance((String)this.getTransactionRule().getProviderType());
        fileGenerator.ifPresent(optional -> metaDataPersistService.persistTransactionRule(optional.getTransactionProps(this.getTransactionRule().getProps(), databaseConfig, this.instanceContext.getModeConfiguration().getType()), true));
    }

    private MetaDataContexts buildChangedMetaDataContext(ShardingSphereDatabase originalDatabase, Collection<RuleConfiguration> ruleConfigs) throws SQLException {
        MetaDataContextsBuilder builder = new MetaDataContextsBuilder(Collections.singletonMap(originalDatabase.getName(), new DataSourceProvidedDatabaseConfiguration(originalDatabase.getResource().getDataSources(), ruleConfigs)), this.metaDataContexts.getMetaData().getGlobalRuleMetaData().getConfigurations(), this.metaDataContexts.getMetaData().getProps());
        MetaDataContexts result = builder.build(this.metaDataContexts.getPersistService().orElse(null));
        this.persistMetaData(result);
        return result;
    }

    private MetaDataContexts buildChangedMetaDataContextWithChangedDataSource(ShardingSphereDatabase originalDatabase, Map<String, DataSourceProperties> newDataSourceProps) throws SQLException {
        Set<String> deletedDataSources = this.getDeletedDataSources(originalDatabase, newDataSourceProps).keySet();
        Map<String, DataSource> changedDataSources = this.buildChangedDataSources(originalDatabase, newDataSourceProps);
        DataSourceProvidedDatabaseConfiguration databaseConfig = new DataSourceProvidedDatabaseConfiguration(this.getNewDataSources(originalDatabase.getResource().getDataSources(), this.getAddedDataSources(originalDatabase, newDataSourceProps), changedDataSources, deletedDataSources), originalDatabase.getRuleMetaData().getConfigurations());
        MetaDataContextsBuilder builder = new MetaDataContextsBuilder(Collections.singletonMap(originalDatabase.getName(), databaseConfig), this.metaDataContexts.getMetaData().getGlobalRuleMetaData().getConfigurations(), this.metaDataContexts.getMetaData().getProps());
        MetaDataContexts result = builder.build(this.metaDataContexts.getPersistService().orElse(null));
        this.persistMetaData(result);
        return result;
    }

    private MetaDataContexts buildChangedMetaDataContextWithChangedDataSourceAndRule(ShardingSphereDatabase originalDatabase, Map<String, DataSourceProperties> newDataSourceProps, Collection<RuleConfiguration> ruleConfigs) throws SQLException {
        Set<String> deletedDataSources = this.getDeletedDataSources(originalDatabase, newDataSourceProps).keySet();
        Map<String, DataSource> changedDataSources = this.buildChangedDataSources(originalDatabase, newDataSourceProps);
        DataSourceProvidedDatabaseConfiguration databaseConfig = new DataSourceProvidedDatabaseConfiguration(this.getNewDataSources(originalDatabase.getResource().getDataSources(), this.getAddedDataSources(originalDatabase, newDataSourceProps), changedDataSources, deletedDataSources), ruleConfigs);
        MetaDataContextsBuilder builder = new MetaDataContextsBuilder(Collections.singletonMap(originalDatabase.getName(), databaseConfig), this.metaDataContexts.getMetaData().getGlobalRuleMetaData().getConfigurations(), this.metaDataContexts.getMetaData().getProps());
        MetaDataContexts result = builder.build(this.metaDataContexts.getPersistService().orElse(null));
        this.persistMetaData(result);
        return result;
    }

    private Map<String, DataSource> getNewDataSources(Map<String, DataSource> originalDataSources, Map<String, DataSource> addedDataSources, Map<String, DataSource> changedDataSources, Collection<String> deletedDataSources) {
        LinkedHashMap<String, DataSource> result = new LinkedHashMap<String, DataSource>(originalDataSources);
        result.keySet().removeAll(deletedDataSources);
        result.putAll(changedDataSources);
        result.putAll(addedDataSources);
        return result;
    }

    private Map<String, DataSource> getAddedDataSources(ShardingSphereDatabase originalDatabase, Map<String, DataSourceProperties> newDataSourcePropsMap) {
        return DataSourcePoolCreator.create(newDataSourcePropsMap.entrySet().stream().filter(entry -> !originalDatabase.getResource().getDataSources().containsKey(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    private Map<String, DataSource> buildChangedDataSources(ShardingSphereDatabase originalDatabase, Map<String, DataSourceProperties> newDataSourcePropsMap) {
        return DataSourcePoolCreator.create(this.getChangedDataSourceConfiguration(originalDatabase, newDataSourcePropsMap));
    }

    public void renewAllTransactionContext() {
        for (Map.Entry entry : this.metaDataContexts.getMetaData().getDatabases().entrySet()) {
            this.renewTransactionContext((String)entry.getKey(), ((ShardingSphereDatabase)entry.getValue()).getResource());
        }
    }

    private void renewTransactionContext(String databaseName, ShardingSphereResource resource) {
        ShardingSphereTransactionManagerEngine changedStaleEngine = (ShardingSphereTransactionManagerEngine)this.transactionContexts.getEngines().get(databaseName);
        if (null != changedStaleEngine) {
            this.closeTransactionEngine(changedStaleEngine);
        }
        this.transactionContexts.getEngines().put(databaseName, this.createNewEngine(resource.getDatabaseType(), resource.getDataSources()));
    }

    private ShardingSphereTransactionManagerEngine createNewEngine(DatabaseType databaseType, Map<String, DataSource> dataSources) {
        Optional fileGenerator = TransactionConfigurationFileGeneratorFactory.findInstance((String)this.getTransactionRule().getProviderType());
        fileGenerator.ifPresent(optional -> optional.generateFile(this.getTransactionRule().getProps(), this.instanceContext));
        ShardingSphereTransactionManagerEngine result = new ShardingSphereTransactionManagerEngine();
        result.init(databaseType, dataSources, this.getTransactionRule());
        return result;
    }

    private TransactionRule getTransactionRule() {
        Optional transactionRule = this.metaDataContexts.getMetaData().getGlobalRuleMetaData().findSingleRule(TransactionRule.class);
        return transactionRule.orElseGet(() -> new TransactionRule(new DefaultTransactionRuleConfigurationBuilder().build()));
    }

    private void closeDataSources(ShardingSphereDatabase removeMetaData) {
        if (null != removeMetaData.getResource()) {
            removeMetaData.getResource().getDataSources().values().forEach(each -> removeMetaData.getResource().close(each));
        }
    }

    private void closeDataSources(String databaseName, Collection<DataSource> dataSources) {
        ShardingSphereResource resource = ((ShardingSphereDatabase)this.metaDataContexts.getMetaData().getDatabases().get(databaseName)).getResource();
        dataSources.forEach(arg_0 -> ((ShardingSphereResource)resource).close(arg_0));
    }

    private void removeAndCloseTransactionEngine(String databaseName) {
        ShardingSphereTransactionManagerEngine staleEngine = (ShardingSphereTransactionManagerEngine)this.transactionContexts.getEngines().remove(databaseName);
        this.closeTransactionEngine(staleEngine);
    }

    private void closeTransactionEngine(ShardingSphereTransactionManagerEngine staleEngine) {
        if (null != staleEngine) {
            try {
                staleEngine.close();
            }
            catch (Exception ex) {
                log.error("Close transaction engine failed", (Throwable)ex);
            }
        }
    }

    @Override
    public void close() throws Exception {
        this.executorEngine.close();
        this.metaDataContexts.close();
        this.transactionContexts.close();
    }

    @Generated
    public MetaDataContexts getMetaDataContexts() {
        return this.metaDataContexts;
    }

    @Generated
    public TransactionContexts getTransactionContexts() {
        return this.transactionContexts;
    }

    @Generated
    public InstanceContext getInstanceContext() {
        return this.instanceContext;
    }

    @Generated
    public ExecutorEngine getExecutorEngine() {
        return this.executorEngine;
    }

    private /* synthetic */ void lambda$buildChangedMetaDataContextWithAddedDataSource$20(DatabaseConfiguration databaseConfig, MetaDataPersistService optional) {
        this.persistTransactionConfiguration(databaseConfig, optional);
    }
}

