/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.memory.lock;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.shardingsphere.infra.lock.ShardingSphereLock;
import org.apache.shardingsphere.mode.manager.memory.lock.MemoryMutexLock;

public final class ShardingSphereMemoryLock
implements ShardingSphereLock {
    private static final long DEFAULT_TRY_LOCK_TIMEOUT_MILLISECONDS = 180000L;
    private final Map<String, ReentrantLock> locks = new ConcurrentHashMap<String, ReentrantLock>();

    public boolean tryLock(String lockName) {
        return this.tryLock(lockName, 180000L);
    }

    public boolean tryLock(String lockName, long timeoutMillis) {
        return this.innerTryLock(lockName, timeoutMillis);
    }

    private synchronized boolean innerTryLock(String lockName, long timeoutMillis) {
        Preconditions.checkNotNull((Object)lockName, (Object)"Try lock args lockName name can not be null.");
        ReentrantLock lock = this.locks.get(lockName);
        if (null == lock) {
            lock = new MemoryMutexLock();
            this.locks.put(lockName, lock);
        }
        return this.innerTryLock(lock, timeoutMillis);
    }

    private boolean innerTryLock(ReentrantLock lock, long timeoutMillis) {
        try {
            return lock.tryLock(timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ignored) {
            return false;
        }
    }

    public void releaseLock(String lockName) {
        Preconditions.checkNotNull((Object)lockName, (Object)"Release lock args lockName name can not be null.");
        this.locks.get(lockName).unlock();
    }

    public boolean isLocked(String lockName) {
        Preconditions.checkNotNull((Object)lockName, (Object)"Is locked args lockName name can not be null.");
        if (this.locks.isEmpty()) {
            return false;
        }
        ReentrantLock lock = this.locks.get(lockName);
        if (null == lock) {
            return false;
        }
        return lock.isLocked();
    }
}

