/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.memory;

import java.sql.SQLException;
import java.util.Optional;
import org.apache.shardingsphere.infra.config.mode.ModeConfiguration;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstance;
import org.apache.shardingsphere.infra.instance.InstanceContext;
import org.apache.shardingsphere.infra.instance.workerid.WorkerIdGenerator;
import org.apache.shardingsphere.infra.lock.LockContext;
import org.apache.shardingsphere.infra.rule.identifier.type.InstanceAwareRule;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.ContextManagerBuilder;
import org.apache.shardingsphere.mode.manager.ContextManagerBuilderParameter;
import org.apache.shardingsphere.mode.manager.memory.lock.MemoryLockContext;
import org.apache.shardingsphere.mode.manager.memory.workerid.generator.MemoryWorkerIdGenerator;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.mode.metadata.MetaDataContextsBuilder;
import org.apache.shardingsphere.transaction.context.TransactionContexts;
import org.apache.shardingsphere.transaction.context.TransactionContextsBuilder;
import org.apache.shardingsphere.transaction.rule.TransactionRule;
import org.apache.shardingsphere.transaction.spi.TransactionConfigurationFileGeneratorFactory;

public final class MemoryContextManagerBuilder
implements ContextManagerBuilder {
    public ContextManager build(ContextManagerBuilderParameter parameter) throws SQLException {
        MetaDataContexts metaDataContexts = new MetaDataContextsBuilder(parameter.getDatabaseConfigs(), parameter.getGlobalRuleConfigs(), new ConfigurationProperties(parameter.getProps())).build(null);
        InstanceContext instanceContext = this.buildInstanceContext(parameter);
        this.generateTransactionConfigurationFile(instanceContext, metaDataContexts);
        TransactionContexts transactionContexts = new TransactionContextsBuilder(metaDataContexts.getMetaData().getDatabases(), metaDataContexts.getMetaData().getGlobalRuleMetaData().getRules()).build();
        ContextManager result = new ContextManager(metaDataContexts, transactionContexts, this.buildInstanceContext(parameter));
        this.setInstanceContext(result);
        return result;
    }

    private InstanceContext buildInstanceContext(ContextManagerBuilderParameter parameter) {
        ComputeNodeInstance instance = new ComputeNodeInstance(parameter.getInstanceDefinition());
        instance.setLabels(parameter.getLabels());
        return new InstanceContext(instance, (WorkerIdGenerator)new MemoryWorkerIdGenerator(), this.buildMemoryModeConfiguration(parameter.getModeConfig()), (LockContext)new MemoryLockContext());
    }

    private void generateTransactionConfigurationFile(InstanceContext instanceContext, MetaDataContexts metaDataContexts) {
        Optional<TransactionRule> transactionRule = metaDataContexts.getMetaData().getGlobalRuleMetaData().getRules().stream().filter(each -> each instanceof TransactionRule).map(each -> (TransactionRule)each).findFirst();
        if (transactionRule.isPresent()) {
            Optional fileGenerator = TransactionConfigurationFileGeneratorFactory.findInstance((String)transactionRule.get().getProviderType());
            fileGenerator.ifPresent(optional -> optional.generateFile(((TransactionRule)transactionRule.get()).getProps(), instanceContext));
        }
    }

    private void setInstanceContext(ContextManager contextManager) {
        contextManager.getMetaDataContexts().getMetaData().getDatabases().forEach((key, value) -> value.getRuleMetaData().getRules().stream().filter(each -> each instanceof InstanceAwareRule).forEach(each -> ((InstanceAwareRule)each).setInstanceContext(contextManager.getInstanceContext())));
    }

    private ModeConfiguration buildMemoryModeConfiguration(ModeConfiguration modeConfiguration) {
        return Optional.ofNullable(modeConfiguration).orElseGet(() -> new ModeConfiguration(this.getType(), null, false));
    }

    public String getType() {
        return "Memory";
    }

    public boolean isDefault() {
        return true;
    }
}

