/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.jdbc.core.resultset;

import java.math.BigDecimal;
import java.net.URL;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import lombok.Generated;
import org.apache.shardingsphere.driver.jdbc.core.resultset.ResultSetUtil;
import org.apache.shardingsphere.driver.jdbc.unsupported.AbstractUnsupportedDatabaseMetaDataResultSet;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.identifier.type.DataNodeContainedRule;

public final class DatabaseMetaDataResultSet
extends AbstractUnsupportedDatabaseMetaDataResultSet {
    private static final String TABLE_NAME = "TABLE_NAME";
    private static final String INDEX_NAME = "INDEX_NAME";
    private final int type;
    private final int concurrency;
    private final Collection<ShardingSphereRule> rules;
    private final ResultSetMetaData resultSetMetaData;
    private final Map<String, Integer> columnLabelIndexMap;
    private final Iterator<DatabaseMetaDataObject> databaseMetaDataObjectIterator;
    private final ResultSet resultSet;
    private volatile boolean closed;
    private DatabaseMetaDataObject currentDatabaseMetaDataObject;

    public DatabaseMetaDataResultSet(ResultSet resultSet, Collection<ShardingSphereRule> rules) throws SQLException {
        this.resultSet = resultSet;
        this.rules = rules;
        this.type = resultSet.getType();
        this.concurrency = resultSet.getConcurrency();
        this.resultSetMetaData = resultSet.getMetaData();
        this.columnLabelIndexMap = this.initIndexMap();
        this.databaseMetaDataObjectIterator = this.initIterator(resultSet);
    }

    private Map<String, Integer> initIndexMap() throws SQLException {
        TreeMap<String, Integer> result = new TreeMap<String, Integer>(String.CASE_INSENSITIVE_ORDER);
        for (int i = 1; i <= this.resultSetMetaData.getColumnCount(); ++i) {
            result.put(this.resultSetMetaData.getColumnLabel(i), i);
        }
        return result;
    }

    private Iterator<DatabaseMetaDataObject> initIterator(ResultSet resultSet) throws SQLException {
        LinkedList<DatabaseMetaDataObject> result = new LinkedList<DatabaseMetaDataObject>();
        HashSet<DatabaseMetaDataObject> removeDuplicationSet = new HashSet<DatabaseMetaDataObject>();
        int tableNameColumnIndex = this.columnLabelIndexMap.getOrDefault(TABLE_NAME, -1);
        int indexNameColumnIndex = this.columnLabelIndexMap.getOrDefault(INDEX_NAME, -1);
        while (resultSet.next()) {
            DatabaseMetaDataObject databaseMetaDataObject = this.generateDatabaseMetaDataObject(tableNameColumnIndex, indexNameColumnIndex, resultSet);
            if (removeDuplicationSet.contains(databaseMetaDataObject)) continue;
            result.add(databaseMetaDataObject);
            removeDuplicationSet.add(databaseMetaDataObject);
        }
        return result.iterator();
    }

    private DatabaseMetaDataObject generateDatabaseMetaDataObject(int tableNameColumnIndex, int indexNameColumnIndex, ResultSet resultSet) throws SQLException {
        DatabaseMetaDataObject result = new DatabaseMetaDataObject(this.resultSetMetaData.getColumnCount());
        Optional<DataNodeContainedRule> dataNodeContainedRule = this.findDataNodeContainedRule();
        for (int i = 1; i <= this.columnLabelIndexMap.size(); ++i) {
            String tableName;
            if (tableNameColumnIndex == i) {
                tableName = resultSet.getString(i);
                Optional logicTableName = dataNodeContainedRule.isPresent() ? dataNodeContainedRule.get().findLogicTableByActualTable(tableName) : Optional.empty();
                result.addObject(logicTableName.orElse(tableName));
                continue;
            }
            if (indexNameColumnIndex == i) {
                tableName = resultSet.getString(tableNameColumnIndex);
                String indexName = resultSet.getString(i);
                result.addObject(null != indexName && indexName.endsWith(tableName) ? indexName.substring(0, indexName.length() - tableName.length() - 1) : indexName);
                continue;
            }
            result.addObject(resultSet.getObject(i));
        }
        return result;
    }

    private Optional<DataNodeContainedRule> findDataNodeContainedRule() {
        return this.rules.stream().filter(each -> each instanceof DataNodeContainedRule).findFirst().map(optional -> (DataNodeContainedRule)optional);
    }

    @Override
    public boolean next() throws SQLException {
        this.checkClosed();
        if (this.databaseMetaDataObjectIterator.hasNext()) {
            this.currentDatabaseMetaDataObject = this.databaseMetaDataObjectIterator.next();
            return true;
        }
        return false;
    }

    @Override
    public void close() throws SQLException {
        this.checkClosed();
        this.closed = true;
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return this.getBigDecimal(columnIndex, true, scale);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel), scale);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return this.getBigDecimal(columnIndex, false, 0);
    }

    private BigDecimal getBigDecimal(int columnIndex, boolean needScale, int scale) throws SQLException {
        this.checkClosed();
        this.checkColumnIndex(columnIndex);
        return (BigDecimal)ResultSetUtil.convertBigDecimalValue(this.currentDatabaseMetaDataObject.getObject(columnIndex), needScale, scale);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel));
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkColumnIndex(columnIndex);
        return (String)ResultSetUtil.convertValue(this.currentDatabaseMetaDataObject.getObject(columnIndex), String.class);
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        return this.getString(this.findColumn(columnLabel));
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return this.getString(columnIndex);
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return this.getString(columnLabel);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkColumnIndex(columnIndex);
        return (Boolean)ResultSetUtil.convertValue(this.currentDatabaseMetaDataObject.getObject(columnIndex), Boolean.TYPE);
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        return this.getBoolean(this.findColumn(columnLabel));
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkColumnIndex(columnIndex);
        return (Byte)ResultSetUtil.convertValue(this.currentDatabaseMetaDataObject.getObject(columnIndex), Byte.TYPE);
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        return this.getByte(this.findColumn(columnLabel));
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkColumnIndex(columnIndex);
        return (Short)ResultSetUtil.convertValue(this.currentDatabaseMetaDataObject.getObject(columnIndex), Short.TYPE);
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        return this.getShort(this.findColumn(columnLabel));
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkColumnIndex(columnIndex);
        return (Integer)ResultSetUtil.convertValue(this.currentDatabaseMetaDataObject.getObject(columnIndex), Integer.TYPE);
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        return this.getInt(this.findColumn(columnLabel));
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkColumnIndex(columnIndex);
        return (Long)ResultSetUtil.convertValue(this.currentDatabaseMetaDataObject.getObject(columnIndex), Long.TYPE);
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        return this.getLong(this.findColumn(columnLabel));
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkColumnIndex(columnIndex);
        return ((Float)ResultSetUtil.convertValue(this.currentDatabaseMetaDataObject.getObject(columnIndex), Float.TYPE)).floatValue();
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        return this.getFloat(this.findColumn(columnLabel));
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkColumnIndex(columnIndex);
        return (Double)ResultSetUtil.convertValue(this.currentDatabaseMetaDataObject.getObject(columnIndex), Double.TYPE);
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        return this.getDouble(this.findColumn(columnLabel));
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkColumnIndex(columnIndex);
        return (byte[])ResultSetUtil.convertValue(this.currentDatabaseMetaDataObject.getObject(columnIndex), byte[].class);
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        return this.getBytes(this.findColumn(columnLabel));
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkColumnIndex(columnIndex);
        return (Date)ResultSetUtil.convertValue(this.currentDatabaseMetaDataObject.getObject(columnIndex), Date.class);
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        return this.getDate(this.findColumn(columnLabel));
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkColumnIndex(columnIndex);
        return (Time)ResultSetUtil.convertValue(this.currentDatabaseMetaDataObject.getObject(columnIndex), Time.class);
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        return this.getTime(this.findColumn(columnLabel));
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkColumnIndex(columnIndex);
        return (Timestamp)ResultSetUtil.convertValue(this.currentDatabaseMetaDataObject.getObject(columnIndex), Timestamp.class);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel));
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkColumnIndex(columnIndex);
        return (URL)ResultSetUtil.convertValue(this.currentDatabaseMetaDataObject.getObject(columnIndex), URL.class);
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        return this.getURL(this.findColumn(columnLabel));
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkClosed();
        return this.resultSetMetaData;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkColumnIndex(columnIndex);
        return this.currentDatabaseMetaDataObject.getObject(columnIndex);
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this.getObject(this.findColumn(columnLabel));
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        this.checkClosed();
        if (!this.columnLabelIndexMap.containsKey(columnLabel)) {
            throw new SQLException(String.format("Can not find columnLabel %s", columnLabel));
        }
        return this.columnLabelIndexMap.get(columnLabel);
    }

    @Override
    public int getType() throws SQLException {
        this.checkClosed();
        return this.type;
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.checkClosed();
        return this.concurrency;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.resultSet.setFetchDirection(direction);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.resultSet.getFetchDirection();
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.resultSet.getFetchSize();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.resultSet.setFetchSize(rows);
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    private void checkClosed() throws SQLException {
        if (this.closed) {
            throw new SQLException("ResultSet has closed.");
        }
    }

    private void checkColumnIndex(int columnIndex) throws SQLException {
        if (columnIndex < 1 || columnIndex > this.resultSetMetaData.getColumnCount()) {
            throw new SQLException(String.format("ColumnIndex %d out of range from %d to %d", columnIndex, 1, this.resultSetMetaData.getColumnCount()));
        }
    }

    private static final class DatabaseMetaDataObject {
        private final List<Object> objects;

        private DatabaseMetaDataObject(int columnCount) {
            this.objects = new ArrayList<Object>(columnCount);
        }

        public void addObject(Object object) {
            this.objects.add(object);
        }

        public Object getObject(int index) {
            return this.objects.get(index - 1);
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DatabaseMetaDataObject)) {
                return false;
            }
            DatabaseMetaDataObject other = (DatabaseMetaDataObject)o;
            List<Object> this$objects = this.objects;
            List<Object> other$objects = other.objects;
            return !(this$objects == null ? other$objects != null : !((Object)this$objects).equals(other$objects));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Object> $objects = this.objects;
            result = result * 59 + ($objects == null ? 43 : ((Object)$objects).hashCode());
            return result;
        }
    }
}

