/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.jdbc.core.driver;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.Objects;

public final class ShardingSphereDriverURL {
    private static final String CLASSPATH_TYPE = "classpath:";
    private final String file;
    private final boolean inClasspath;

    public ShardingSphereDriverURL(String url) {
        String configuredFile = url.substring("jdbc:shardingsphere:".length(), url.contains("?") ? url.indexOf("?") : url.length());
        if (configuredFile.startsWith(CLASSPATH_TYPE)) {
            this.file = configuredFile.substring(CLASSPATH_TYPE.length());
            this.inClasspath = true;
        } else {
            this.file = configuredFile;
            this.inClasspath = false;
        }
        Preconditions.checkArgument((!this.file.isEmpty() ? 1 : 0) != 0, (Object)"Configuration file is required in ShardingSphere driver URL.");
    }

    public File toConfigurationFile() {
        return new File(this.inClasspath ? Objects.requireNonNull(ShardingSphereDriverURL.class.getResource("/" + this.file), String.format("Can not find configuration file `%s` in classpath.", this.file)).getFile() : this.file);
    }
}

