/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.jdbc.core.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.apache.shardingsphere.driver.api.yaml.YamlShardingSphereDataSourceFactory;
import org.apache.shardingsphere.driver.jdbc.core.datasource.ShardingSphereDataSource;
import org.apache.shardingsphere.driver.jdbc.core.driver.ShardingSphereDriverURL;

public final class DriverDataSourceCache {
    private final Map<String, DataSource> dataSourceMap = new ConcurrentHashMap<String, DataSource>();

    public DataSource get(String url) throws SQLException {
        DataSource dataSource;
        if (this.dataSourceMap.containsKey(url)) {
            return this.dataSourceMap.get(url);
        }
        try {
            dataSource = YamlShardingSphereDataSourceFactory.createDataSource(new ShardingSphereDriverURL(url).toConfigurationFile());
        }
        catch (IOException ex) {
            throw new SQLException(ex);
        }
        DataSource previousDataSource = this.dataSourceMap.putIfAbsent(url, dataSource);
        if (null == previousDataSource) {
            return dataSource;
        }
        try {
            ((ShardingSphereDataSource)dataSource).close();
        }
        catch (Exception ex) {
            throw new SQLException(ex);
        }
        return previousDataSource;
    }
}

