/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.jdbc.core.connection;

import com.google.common.base.Preconditions;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.driver.jdbc.adapter.executor.ForceExecuteTemplate;
import org.apache.shardingsphere.driver.jdbc.adapter.invocation.MethodInvocationRecorder;
import org.apache.shardingsphere.driver.jdbc.core.ShardingSphereSavepoint;
import org.apache.shardingsphere.infra.datasource.pool.creator.DataSourcePoolCreator;
import org.apache.shardingsphere.infra.datasource.props.DataSourceProperties;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.ConnectionMode;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.jdbc.ExecutorJDBCConnectionManager;
import org.apache.shardingsphere.infra.instance.definition.InstanceDefinition;
import org.apache.shardingsphere.infra.instance.definition.InstanceType;
import org.apache.shardingsphere.infra.metadata.user.ShardingSphereUser;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.metadata.persist.MetaDataPersistService;
import org.apache.shardingsphere.traffic.rule.TrafficRule;
import org.apache.shardingsphere.transaction.ConnectionSavepointManager;
import org.apache.shardingsphere.transaction.ConnectionTransaction;
import org.apache.shardingsphere.transaction.core.TransactionType;
import org.apache.shardingsphere.transaction.core.TransactionTypeHolder;
import org.apache.shardingsphere.transaction.rule.TransactionRule;

public final class ConnectionManager
implements ExecutorJDBCConnectionManager,
AutoCloseable {
    private final Map<String, DataSource> dataSourceMap = new LinkedHashMap<String, DataSource>();
    private final Map<String, DataSource> physicalDataSourceMap = new LinkedHashMap<String, DataSource>();
    private final ConnectionTransaction connectionTransaction;
    private final Multimap<String, Connection> cachedConnections = LinkedHashMultimap.create();
    private final MethodInvocationRecorder<Connection> methodInvocationRecorder = new MethodInvocationRecorder();
    private final ForceExecuteTemplate<Connection> forceExecuteTemplate = new ForceExecuteTemplate();
    private final Random random = new SecureRandom();

    public ConnectionManager(String databaseName, ContextManager contextManager) {
        this.dataSourceMap.putAll(contextManager.getDataSourceMap(databaseName));
        this.dataSourceMap.putAll(this.getTrafficDataSourceMap(databaseName, contextManager));
        this.physicalDataSourceMap.putAll(contextManager.getDataSourceMap(databaseName));
        this.connectionTransaction = this.createConnectionTransaction(databaseName, contextManager);
    }

    private Map<String, DataSource> getTrafficDataSourceMap(String schema, ContextManager contextManager) {
        Optional trafficRule = contextManager.getMetaDataContexts().getMetaData().getGlobalRuleMetaData().findSingleRule(TrafficRule.class);
        Optional metaDataPersistService = contextManager.getMetaDataContexts().getPersistService();
        if (!trafficRule.isPresent() || ((TrafficRule)trafficRule.get()).getStrategyRules().isEmpty() || !metaDataPersistService.isPresent()) {
            return Collections.emptyMap();
        }
        Map dataSourcePropsMap = ((MetaDataPersistService)metaDataPersistService.get()).getDataSourceService().load(schema);
        Preconditions.checkState((!dataSourcePropsMap.isEmpty() ? 1 : 0) != 0, (Object)"Can not get data source properties from meta data.");
        DataSourceProperties dataSourcePropsSample = (DataSourceProperties)dataSourcePropsMap.values().iterator().next();
        Collection users = ((MetaDataPersistService)metaDataPersistService.get()).getGlobalRuleService().loadUsers();
        List instances = contextManager.getInstanceContext().getComputeNodeInstances(InstanceType.PROXY, ((TrafficRule)trafficRule.get()).getLabels());
        return DataSourcePoolCreator.create(this.createDataSourcePropertiesMap(instances, users, dataSourcePropsSample, schema));
    }

    private Map<String, DataSourceProperties> createDataSourcePropertiesMap(Collection<InstanceDefinition> instances, Collection<ShardingSphereUser> users, DataSourceProperties dataSourcePropsSample, String schema) {
        LinkedHashMap<String, DataSourceProperties> result = new LinkedHashMap<String, DataSourceProperties>();
        for (InstanceDefinition each : instances) {
            result.put(each.getInstanceId(), this.createDataSourceProperties(each, users, dataSourcePropsSample, schema));
        }
        return result;
    }

    private DataSourceProperties createDataSourceProperties(InstanceDefinition instanceDefinition, Collection<ShardingSphereUser> users, DataSourceProperties dataSourcePropsSample, String schema) {
        Map props = dataSourcePropsSample.getAllLocalProperties();
        props.put("jdbcUrl", this.createJdbcUrl(instanceDefinition, schema, props));
        ShardingSphereUser user = users.iterator().next();
        props.put("username", user.getGrantee().getUsername());
        props.put("password", user.getPassword());
        return new DataSourceProperties("com.zaxxer.hikari.HikariDataSource", props);
    }

    private String createJdbcUrl(InstanceDefinition instanceDefinition, String schema, Map<String, Object> props) {
        String jdbcUrl = String.valueOf(props.get("jdbcUrl"));
        String jdbcUrlPrefix = jdbcUrl.substring(0, jdbcUrl.indexOf("//"));
        String jdbcUrlSuffix = jdbcUrl.contains("?") ? jdbcUrl.substring(jdbcUrl.indexOf("?")) : "";
        return String.format("%s//%s:%s/%s%s", jdbcUrlPrefix, instanceDefinition.getIp(), instanceDefinition.getUniqueSign(), schema, jdbcUrlSuffix);
    }

    private ConnectionTransaction createConnectionTransaction(String databaseName, ContextManager contextManager) {
        TransactionType type = TransactionTypeHolder.get();
        if (null == type) {
            Optional transactionRule = contextManager.getMetaDataContexts().getMetaData().getGlobalRuleMetaData().findSingleRule(TransactionRule.class);
            return transactionRule.map(optional -> new ConnectionTransaction(databaseName, optional, contextManager.getTransactionContexts())).orElseGet(() -> new ConnectionTransaction(databaseName, contextManager.getTransactionContexts()));
        }
        return new ConnectionTransaction(databaseName, type, contextManager.getTransactionContexts());
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.methodInvocationRecorder.record("setAutoCommit", target -> target.setAutoCommit(autoCommit));
        this.forceExecuteTemplate.execute(this.cachedConnections.values(), connection -> connection.setAutoCommit(autoCommit));
    }

    public void commit() throws SQLException {
        if (this.connectionTransaction.isLocalTransaction() && this.connectionTransaction.isRollbackOnly()) {
            this.forceExecuteTemplate.execute(this.cachedConnections.values(), Connection::rollback);
        } else if (this.connectionTransaction.isLocalTransaction() && !this.connectionTransaction.isRollbackOnly()) {
            this.forceExecuteTemplate.execute(this.cachedConnections.values(), Connection::commit);
        } else {
            this.connectionTransaction.commit();
        }
    }

    public void rollback() throws SQLException {
        if (this.connectionTransaction.isLocalTransaction()) {
            this.forceExecuteTemplate.execute(this.cachedConnections.values(), Connection::rollback);
        } else {
            this.connectionTransaction.rollback();
        }
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        for (Connection each : this.cachedConnections.values()) {
            ConnectionSavepointManager.getInstance().rollbackToSavepoint(each, savepoint.getSavepointName());
        }
    }

    public Savepoint setSavepoint(String savepointName) throws SQLException {
        ShardingSphereSavepoint result = new ShardingSphereSavepoint(savepointName);
        for (Connection each : this.cachedConnections.values()) {
            ConnectionSavepointManager.getInstance().setSavepoint(each, savepointName);
        }
        this.methodInvocationRecorder.record("setSavepoint", target -> ConnectionSavepointManager.getInstance().setSavepoint(target, savepointName));
        return result;
    }

    public Savepoint setSavepoint() throws SQLException {
        ShardingSphereSavepoint result = new ShardingSphereSavepoint();
        for (Connection each : this.cachedConnections.values()) {
            ConnectionSavepointManager.getInstance().setSavepoint(each, result.getSavepointName());
        }
        this.methodInvocationRecorder.record("setSavepoint", target -> ConnectionSavepointManager.getInstance().setSavepoint(target, result.getSavepointName()));
        return result;
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        for (Connection each : this.cachedConnections.values()) {
            ConnectionSavepointManager.getInstance().releaseSavepoint(each, savepoint.getSavepointName());
        }
    }

    public Optional<Integer> getTransactionIsolation() throws SQLException {
        return this.cachedConnections.values().isEmpty() ? Optional.empty() : Optional.of(((Connection)this.cachedConnections.values().iterator().next()).getTransactionIsolation());
    }

    public void setTransactionIsolation(int level) throws SQLException {
        this.methodInvocationRecorder.record("setTransactionIsolation", connection -> connection.setTransactionIsolation(level));
        this.forceExecuteTemplate.execute(this.cachedConnections.values(), connection -> connection.setTransactionIsolation(level));
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        this.methodInvocationRecorder.record("setReadOnly", connection -> connection.setReadOnly(readOnly));
        this.forceExecuteTemplate.execute(this.cachedConnections.values(), connection -> connection.setReadOnly(readOnly));
    }

    public boolean isValid(int timeout) throws SQLException {
        for (Connection each : this.cachedConnections.values()) {
            if (each.isValid(timeout)) continue;
            return false;
        }
        return true;
    }

    public String getRandomPhysicalDataSourceName() {
        Sets.SetView cachedPhysicalDataSourceNames = Sets.intersection(this.physicalDataSourceMap.keySet(), (Set)this.cachedConnections.keySet());
        Sets.SetView datasourceNames = cachedPhysicalDataSourceNames.isEmpty() ? this.physicalDataSourceMap.keySet() : cachedPhysicalDataSourceNames;
        return (String)new ArrayList(datasourceNames).get(this.random.nextInt(datasourceNames.size()));
    }

    public Connection getRandomConnection() throws SQLException {
        return this.getConnections(this.getRandomPhysicalDataSourceName(), 1, ConnectionMode.MEMORY_STRICTLY).get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Connection> getConnections(String dataSourceName, int connectionSize, ConnectionMode connectionMode) throws SQLException {
        List<Connection> result;
        Collection connections;
        DataSource dataSource = this.dataSourceMap.get(dataSourceName);
        Preconditions.checkState((null != dataSource ? 1 : 0) != 0, (String)"Missing the data source name: '%s'", (Object)dataSourceName);
        Multimap<String, Connection> multimap = this.cachedConnections;
        synchronized (multimap) {
            connections = this.cachedConnections.get((Object)dataSourceName);
        }
        if (connections.size() >= connectionSize) {
            result = new ArrayList(connections).subList(0, connectionSize);
        } else {
            if (!connections.isEmpty()) {
                result = new ArrayList(connectionSize);
                result.addAll(connections);
                List<Connection> newConnections = this.createConnections(dataSourceName, dataSource, connectionSize - connections.size(), connectionMode);
                result.addAll(newConnections);
                Multimap<String, Connection> multimap2 = this.cachedConnections;
                synchronized (multimap2) {
                    this.cachedConnections.putAll((Object)dataSourceName, newConnections);
                }
            }
            result = new ArrayList<Connection>(this.createConnections(dataSourceName, dataSource, connectionSize, connectionMode));
            Multimap<String, Connection> multimap3 = this.cachedConnections;
            synchronized (multimap3) {
                this.cachedConnections.putAll((Object)dataSourceName, result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Connection> createConnections(String dataSourceName, DataSource dataSource, int connectionSize, ConnectionMode connectionMode) throws SQLException {
        if (1 == connectionSize) {
            Connection connection = this.createConnection(dataSourceName, dataSource);
            this.methodInvocationRecorder.replay(connection);
            return Collections.singletonList(connection);
        }
        if (ConnectionMode.CONNECTION_STRICTLY == connectionMode) {
            return this.createConnections(dataSourceName, dataSource, connectionSize);
        }
        DataSource dataSource2 = dataSource;
        synchronized (dataSource2) {
            return this.createConnections(dataSourceName, dataSource, connectionSize);
        }
    }

    private List<Connection> createConnections(String dataSourceName, DataSource dataSource, int connectionSize) throws SQLException {
        ArrayList<Connection> result = new ArrayList<Connection>(connectionSize);
        for (int i = 0; i < connectionSize; ++i) {
            try {
                Connection connection = this.createConnection(dataSourceName, dataSource);
                this.methodInvocationRecorder.replay(connection);
                result.add(connection);
                continue;
            }
            catch (SQLException ex) {
                for (Connection each : result) {
                    each.close();
                }
                throw new SQLException(String.format("Can not get %d connections one time, partition succeed connection(%d) have released!", connectionSize, result.size()), ex);
            }
        }
        return result;
    }

    private Connection createConnection(String dataSourceName, DataSource dataSource) throws SQLException {
        Optional connectionInTransaction = this.isRawJdbcDataSource(dataSourceName) ? this.connectionTransaction.getConnection(dataSourceName) : Optional.empty();
        return connectionInTransaction.isPresent() ? (Connection)connectionInTransaction.get() : dataSource.getConnection();
    }

    private boolean isRawJdbcDataSource(String dataSourceName) {
        return this.physicalDataSourceMap.containsKey(dataSourceName);
    }

    @Override
    public void close() throws SQLException {
        try {
            this.forceExecuteTemplate.execute(this.cachedConnections.values(), Connection::close);
        }
        finally {
            this.cachedConnections.clear();
        }
    }

    @Generated
    public ConnectionTransaction getConnectionTransaction() {
        return this.connectionTransaction;
    }
}

