/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.executor.callback;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Optional;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.ConnectionMode;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.driver.jdbc.type.memory.JDBCMemoryQueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.driver.jdbc.type.stream.JDBCStreamQueryResult;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public abstract class ExecuteQueryCallback
extends JDBCExecutorCallback<QueryResult> {
    protected ExecuteQueryCallback(DatabaseType databaseType, SQLStatement sqlStatement, boolean isExceptionThrown) {
        super(databaseType, sqlStatement, isExceptionThrown);
    }

    protected final QueryResult executeSQL(String sql, Statement statement, ConnectionMode connectionMode) throws SQLException {
        ResultSet resultSet = this.executeQuery(sql, statement);
        return ConnectionMode.MEMORY_STRICTLY == connectionMode ? new JDBCStreamQueryResult(resultSet) : new JDBCMemoryQueryResult(resultSet, this.getDatabaseType());
    }

    protected final Optional<QueryResult> getSaneResult(SQLStatement sqlStatement) {
        return Optional.empty();
    }

    protected abstract ResultSet executeQuery(String var1, Statement var2) throws SQLException;
}

