/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.executor;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.driver.executor.callback.ExecuteQueryCallback;
import org.apache.shardingsphere.infra.binder.LogicSQL;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.context.refresher.MetaDataRefreshEngine;
import org.apache.shardingsphere.infra.eventbus.ShardingSphereEventBus;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupContext;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutor;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.executor.sql.process.ExecuteProcessEngine;
import org.apache.shardingsphere.infra.federation.optimizer.metadata.FederationDatabaseMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.identifier.type.DataNodeContainedRule;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;

public final class DriverJDBCExecutor {
    private final String databaseName;
    private final MetaDataContexts metaDataContexts;
    private final ContextManager contextManager;
    private final JDBCExecutor jdbcExecutor;
    private final MetaDataRefreshEngine metadataRefreshEngine;

    public DriverJDBCExecutor(String databaseName, ContextManager contextManager, JDBCExecutor jdbcExecutor) {
        this.databaseName = databaseName;
        this.contextManager = contextManager;
        this.jdbcExecutor = jdbcExecutor;
        this.metaDataContexts = contextManager.getMetaDataContexts();
        this.metadataRefreshEngine = new MetaDataRefreshEngine((ShardingSphereDatabase)this.metaDataContexts.getMetaData().getDatabases().get(databaseName), (FederationDatabaseMetaData)this.metaDataContexts.getOptimizerContext().getFederationMetaData().getDatabases().get(databaseName), this.metaDataContexts.getOptimizerContext().getPlannerContexts(), this.metaDataContexts.getMetaData().getProps());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<QueryResult> executeQuery(ExecutionGroupContext<JDBCExecutionUnit> executionGroupContext, LogicSQL logicSQL, ExecuteQueryCallback callback) throws SQLException {
        try {
            ExecuteProcessEngine.initialize((LogicSQL)logicSQL, executionGroupContext, (ConfigurationProperties)this.metaDataContexts.getMetaData().getProps());
            List result = this.jdbcExecutor.execute(executionGroupContext, (JDBCExecutorCallback)callback);
            ExecuteProcessEngine.finish((String)executionGroupContext.getExecutionID());
            List list = result;
            return list;
        }
        finally {
            ExecuteProcessEngine.clean();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(ExecutionGroupContext<JDBCExecutionUnit> executionGroupContext, LogicSQL logicSQL, Collection<RouteUnit> routeUnits, JDBCExecutorCallback<Integer> callback) throws SQLException {
        try {
            ExecuteProcessEngine.initialize((LogicSQL)logicSQL, executionGroupContext, (ConfigurationProperties)this.metaDataContexts.getMetaData().getProps());
            SQLStatementContext sqlStatementContext = logicSQL.getSqlStatementContext();
            List<Integer> results = this.doExecute(executionGroupContext, sqlStatementContext, routeUnits, callback);
            int result = this.isNeedAccumulate(((ShardingSphereDatabase)this.metaDataContexts.getMetaData().getDatabases().get(this.databaseName)).getRuleMetaData().getRules(), sqlStatementContext) ? this.accumulate(results) : results.get(0).intValue();
            ExecuteProcessEngine.finish((String)executionGroupContext.getExecutionID());
            int n = result;
            return n;
        }
        finally {
            ExecuteProcessEngine.clean();
        }
    }

    private boolean isNeedAccumulate(Collection<ShardingSphereRule> rules, SQLStatementContext<?> sqlStatementContext) {
        for (ShardingSphereRule each : rules) {
            if (!(each instanceof DataNodeContainedRule) || !((DataNodeContainedRule)each).isNeedAccumulate(sqlStatementContext.getTablesContext().getTableNames())) continue;
            return true;
        }
        return false;
    }

    private int accumulate(List<Integer> updateResults) {
        int result = 0;
        for (Integer each : updateResults) {
            result += null != each ? each : 0;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(ExecutionGroupContext<JDBCExecutionUnit> executionGroupContext, LogicSQL logicSQL, Collection<RouteUnit> routeUnits, JDBCExecutorCallback<Boolean> callback) throws SQLException {
        try {
            ExecuteProcessEngine.initialize((LogicSQL)logicSQL, executionGroupContext, (ConfigurationProperties)this.metaDataContexts.getMetaData().getProps());
            List<Boolean> results = this.doExecute(executionGroupContext, logicSQL.getSqlStatementContext(), routeUnits, callback);
            boolean result = null != results && !results.isEmpty() && null != results.get(0) && results.get(0) != false;
            ExecuteProcessEngine.finish((String)executionGroupContext.getExecutionID());
            boolean bl = result;
            return bl;
        }
        finally {
            ExecuteProcessEngine.clean();
        }
    }

    private <T> List<T> doExecute(ExecutionGroupContext<JDBCExecutionUnit> executionGroupContext, SQLStatementContext<?> sqlStatementContext, Collection<RouteUnit> routeUnits, JDBCExecutorCallback<T> callback) throws SQLException {
        List results = this.jdbcExecutor.execute(executionGroupContext, callback);
        this.refreshMetaData(sqlStatementContext, routeUnits);
        return results;
    }

    private void refreshMetaData(SQLStatementContext<?> sqlStatementContext, Collection<RouteUnit> routeUnits) throws SQLException {
        Optional event = this.metadataRefreshEngine.refresh(sqlStatementContext, () -> routeUnits.stream().map(each -> each.getDataSourceMapper().getLogicName()).collect(Collectors.toCollection(() -> new ArrayList(routeUnits.size()))));
        if (this.contextManager.getInstanceContext().isCluster() && event.isPresent()) {
            ShardingSphereEventBus.getInstance().post(event.get());
        }
    }

    @Generated
    public JDBCExecutor getJdbcExecutor() {
        return this.jdbcExecutor;
    }
}

