/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.executor;

import java.sql.SQLException;
import lombok.Generated;
import org.apache.shardingsphere.driver.executor.DriverJDBCExecutor;
import org.apache.shardingsphere.driver.jdbc.core.connection.ShardingSphereConnection;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.executor.kernel.ExecutorEngine;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutor;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.raw.RawExecutor;
import org.apache.shardingsphere.infra.federation.executor.FederationExecutor;
import org.apache.shardingsphere.infra.federation.executor.FederationExecutorFactory;
import org.apache.shardingsphere.infra.federation.optimizer.context.OptimizerContext;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.traffic.executor.TrafficExecutor;

public final class DriverExecutor
implements AutoCloseable {
    private final DriverJDBCExecutor regularExecutor;
    private final RawExecutor rawExecutor;
    private final FederationExecutor federationExecutor;
    private final TrafficExecutor trafficExecutor;

    public DriverExecutor(ShardingSphereConnection connection) {
        MetaDataContexts metaDataContexts = connection.getContextManager().getMetaDataContexts();
        ExecutorEngine executorEngine = connection.getContextManager().getExecutorEngine();
        JDBCExecutor jdbcExecutor = new JDBCExecutor(executorEngine, connection.isHoldTransaction());
        this.regularExecutor = new DriverJDBCExecutor(connection.getDatabaseName(), connection.getContextManager(), jdbcExecutor);
        this.rawExecutor = new RawExecutor(executorEngine, connection.isHoldTransaction(), metaDataContexts.getMetaData().getProps());
        DatabaseType databaseType = ((ShardingSphereDatabase)metaDataContexts.getMetaData().getDatabases().get(connection.getDatabaseName())).getResource().getDatabaseType();
        String schemaName = DatabaseTypeEngine.getDefaultSchemaName((DatabaseType)databaseType, (String)connection.getDatabaseName());
        this.federationExecutor = FederationExecutorFactory.newInstance((String)connection.getDatabaseName(), (String)schemaName, (OptimizerContext)metaDataContexts.getOptimizerContext(), (ConfigurationProperties)metaDataContexts.getMetaData().getProps(), (JDBCExecutor)jdbcExecutor);
        this.trafficExecutor = new TrafficExecutor();
    }

    @Override
    public void close() throws SQLException {
        this.federationExecutor.close();
        this.trafficExecutor.close();
    }

    @Generated
    public DriverJDBCExecutor getRegularExecutor() {
        return this.regularExecutor;
    }

    @Generated
    public RawExecutor getRawExecutor() {
        return this.rawExecutor;
    }

    @Generated
    public FederationExecutor getFederationExecutor() {
        return this.federationExecutor;
    }

    @Generated
    public TrafficExecutor getTrafficExecutor() {
        return this.trafficExecutor;
    }
}

