/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.data.pipeline.datasource.creator;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.shardingsphere.data.pipeline.core.datasource.creator.PipelineDataSourceCreator;
import org.apache.shardingsphere.driver.api.ShardingSphereDataSourceFactory;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.datasource.pool.destroyer.DataSourcePoolDestroyer;
import org.apache.shardingsphere.infra.yaml.config.pojo.YamlRootConfiguration;
import org.apache.shardingsphere.infra.yaml.config.pojo.algorithm.YamlShardingSphereAlgorithmConfiguration;
import org.apache.shardingsphere.infra.yaml.config.swapper.YamlDataSourceConfigurationSwapper;
import org.apache.shardingsphere.infra.yaml.config.swapper.YamlRuleConfigurationSwapperEngine;
import org.apache.shardingsphere.sharding.yaml.config.YamlShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.yaml.swapper.ShardingRuleConfigurationConverter;

public final class ShardingSpherePipelineDataSourceCreator
implements PipelineDataSourceCreator {
    public DataSource createPipelineDataSource(Object pipelineDataSourceConfig) throws SQLException {
        YamlRootConfiguration rootConfig = (YamlRootConfiguration)pipelineDataSourceConfig;
        YamlShardingRuleConfiguration shardingRuleConfig = ShardingRuleConfigurationConverter.findYamlShardingRuleConfiguration((Collection)rootConfig.getRules());
        this.enableRangeQueryForInline(shardingRuleConfig);
        String databaseName = null;
        Map dataSourceMap = new YamlDataSourceConfigurationSwapper().swapToDataSources(rootConfig.getDataSources(), false);
        Collection ruleConfigs = new YamlRuleConfigurationSwapperEngine().swapToRuleConfigurations(rootConfig.getRules());
        try {
            return ShardingSphereDataSourceFactory.createDataSource(databaseName, (Map<String, DataSource>)dataSourceMap, (Collection<RuleConfiguration>)ruleConfigs, null);
        }
        catch (Exception ex) {
            this.closeDataSources(dataSourceMap.values());
            throw ex;
        }
    }

    private void enableRangeQueryForInline(YamlShardingRuleConfiguration shardingRuleConfig) {
        for (YamlShardingSphereAlgorithmConfiguration each : shardingRuleConfig.getShardingAlgorithms().values()) {
            if (!"INLINE".equalsIgnoreCase(each.getType())) continue;
            each.getProps().put("allow-range-query-with-inline-sharding", Boolean.TRUE.toString());
        }
    }

    private void closeDataSources(Collection<DataSource> dataSources) {
        dataSources.stream().map(DataSourcePoolDestroyer::new).forEach(DataSourcePoolDestroyer::asyncDestroy);
    }

    public String getType() {
        return "ShardingSphereJDBC";
    }
}

