/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.executor.sql.prepare.driver;

import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroup;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.context.SQLUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.ConnectionMode;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.DriverExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.prepare.AbstractExecutionPrepareEngine;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.ExecutorConnectionManager;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.ExecutorStatementManager;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.SQLExecutionUnitBuilder;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.SQLExecutionUnitBuilderFactory;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.StorageResourceOption;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;

public final class DriverExecutionPrepareEngine<T extends DriverExecutionUnit<?>, C>
extends AbstractExecutionPrepareEngine<T> {
    private static final Map<String, SQLExecutionUnitBuilder> TYPE_TO_BUILDER_MAP = new ConcurrentHashMap<String, SQLExecutionUnitBuilder>(8, 1.0f);
    private final ExecutorConnectionManager<C> connectionManager;
    private final ExecutorStatementManager<C, ?, ?> statementManager;
    private final StorageResourceOption option;
    private final SQLExecutionUnitBuilder sqlExecutionUnitBuilder;

    public DriverExecutionPrepareEngine(String type, int maxConnectionsSizePerQuery, ExecutorConnectionManager<C> connectionManager, ExecutorStatementManager<C, ?, ?> statementManager, StorageResourceOption option, Collection<ShardingSphereRule> rules) {
        super(maxConnectionsSizePerQuery, rules);
        this.connectionManager = connectionManager;
        this.statementManager = statementManager;
        this.option = option;
        this.sqlExecutionUnitBuilder = this.getCachedSqlExecutionUnitBuilder(type);
    }

    private SQLExecutionUnitBuilder getCachedSqlExecutionUnitBuilder(String type) {
        SQLExecutionUnitBuilder result = TYPE_TO_BUILDER_MAP.get(type);
        if (null == result) {
            result = TYPE_TO_BUILDER_MAP.computeIfAbsent(type, SQLExecutionUnitBuilderFactory::getInstance);
        }
        return result;
    }

    @Override
    protected List<ExecutionGroup<T>> group(String dataSourceName, List<List<SQLUnit>> sqlUnitGroups, ConnectionMode connectionMode) throws SQLException {
        LinkedList<ExecutionGroup<T>> result = new LinkedList<ExecutionGroup<T>>();
        List<C> connections = this.connectionManager.getConnections(dataSourceName, sqlUnitGroups.size(), connectionMode);
        int count = 0;
        for (List<SQLUnit> each : sqlUnitGroups) {
            result.add(this.createExecutionGroup(dataSourceName, each, connections.get(count++), connectionMode));
        }
        return result;
    }

    private ExecutionGroup<T> createExecutionGroup(String dataSourceName, List<SQLUnit> sqlUnits, C connection, ConnectionMode connectionMode) throws SQLException {
        LinkedList result = new LinkedList();
        for (SQLUnit each : sqlUnits) {
            result.add(this.sqlExecutionUnitBuilder.build(new ExecutionUnit(dataSourceName, each), this.statementManager, connection, connectionMode, this.option));
        }
        return new ExecutionGroup(result);
    }
}

