/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.distsql.handler.converter;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shardingsphere.encrypt.api.config.EncryptRuleConfiguration;
import org.apache.shardingsphere.encrypt.api.config.rule.EncryptColumnRuleConfiguration;
import org.apache.shardingsphere.encrypt.api.config.rule.EncryptTableRuleConfiguration;
import org.apache.shardingsphere.encrypt.distsql.parser.segment.EncryptColumnSegment;
import org.apache.shardingsphere.encrypt.distsql.parser.segment.EncryptRuleSegment;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithmConfiguration;

public final class EncryptRuleStatementConverter {
    public static EncryptRuleConfiguration convert(Collection<EncryptRuleSegment> ruleSegments) {
        LinkedList<EncryptTableRuleConfiguration> tables = new LinkedList<EncryptTableRuleConfiguration>();
        HashMap<String, ShardingSphereAlgorithmConfiguration> encryptors = new HashMap<String, ShardingSphereAlgorithmConfiguration>();
        for (EncryptRuleSegment each : ruleSegments) {
            tables.add(EncryptRuleStatementConverter.createEncryptTableRuleConfiguration(each));
            encryptors.putAll(EncryptRuleStatementConverter.createEncryptorConfigurations(each));
        }
        return new EncryptRuleConfiguration(tables, encryptors);
    }

    private static EncryptTableRuleConfiguration createEncryptTableRuleConfiguration(EncryptRuleSegment ruleSegment) {
        LinkedList<EncryptColumnRuleConfiguration> columns = new LinkedList<EncryptColumnRuleConfiguration>();
        for (EncryptColumnSegment each : ruleSegment.getColumns()) {
            columns.add(EncryptRuleStatementConverter.createEncryptColumnRuleConfiguration(ruleSegment.getTableName(), each));
        }
        return new EncryptTableRuleConfiguration(ruleSegment.getTableName(), columns, ruleSegment.getQueryWithCipherColumn());
    }

    private static EncryptColumnRuleConfiguration createEncryptColumnRuleConfiguration(String tableName, EncryptColumnSegment columnSegment) {
        return new EncryptColumnRuleConfiguration(columnSegment.getName(), columnSegment.getCipherColumn(), columnSegment.getAssistedQueryColumn(), columnSegment.getPlainColumn(), EncryptRuleStatementConverter.getEncryptorName(tableName, columnSegment.getName()), null);
    }

    private static Map<String, ShardingSphereAlgorithmConfiguration> createEncryptorConfigurations(EncryptRuleSegment ruleSegment) {
        return ruleSegment.getColumns().stream().collect(Collectors.toMap(each -> EncryptRuleStatementConverter.getEncryptorName(ruleSegment.getTableName(), each.getName()), EncryptRuleStatementConverter::createEncryptorConfiguration));
    }

    private static ShardingSphereAlgorithmConfiguration createEncryptorConfiguration(EncryptColumnSegment columnSegment) {
        return new ShardingSphereAlgorithmConfiguration(columnSegment.getEncryptor().getName(), columnSegment.getEncryptor().getProps());
    }

    private static String getEncryptorName(String tableName, String columnName) {
        return String.format("%s_%s", tableName, columnName);
    }
}

