/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.yaml.swapper;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.shardingsphere.encrypt.api.config.EncryptRuleConfiguration;
import org.apache.shardingsphere.encrypt.api.config.rule.EncryptTableRuleConfiguration;
import org.apache.shardingsphere.encrypt.yaml.config.YamlEncryptRuleConfiguration;
import org.apache.shardingsphere.encrypt.yaml.config.rule.YamlEncryptTableRuleConfiguration;
import org.apache.shardingsphere.encrypt.yaml.swapper.rule.EncryptTableRuleConfigurationYamlSwapper;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithmConfiguration;
import org.apache.shardingsphere.infra.yaml.config.pojo.algorithm.YamlShardingSphereAlgorithmConfiguration;
import org.apache.shardingsphere.infra.yaml.config.swapper.YamlRuleConfigurationSwapper;
import org.apache.shardingsphere.infra.yaml.config.swapper.algorithm.ShardingSphereAlgorithmConfigurationYamlSwapper;
import org.apache.shardingsphere.infra.yaml.config.swapper.rulealtered.OnRuleAlteredActionConfigurationYamlSwapper;

public final class EncryptRuleConfigurationYamlSwapper
implements YamlRuleConfigurationSwapper<YamlEncryptRuleConfiguration, EncryptRuleConfiguration> {
    private final EncryptTableRuleConfigurationYamlSwapper tableYamlSwapper = new EncryptTableRuleConfigurationYamlSwapper();
    private final ShardingSphereAlgorithmConfigurationYamlSwapper algorithmSwapper = new ShardingSphereAlgorithmConfigurationYamlSwapper();
    private final OnRuleAlteredActionConfigurationYamlSwapper onRuleAlteredActionYamlSwapper = new OnRuleAlteredActionConfigurationYamlSwapper();

    public YamlEncryptRuleConfiguration swapToYamlConfiguration(EncryptRuleConfiguration data) {
        YamlEncryptRuleConfiguration result = new YamlEncryptRuleConfiguration();
        data.getTables().forEach(each -> result.getTables().put(each.getName(), this.tableYamlSwapper.swapToYamlConfiguration((EncryptTableRuleConfiguration)each)));
        data.getEncryptors().forEach((key, value) -> result.getEncryptors().put((String)key, this.algorithmSwapper.swapToYamlConfiguration(value)));
        result.setQueryWithCipherColumn(data.isQueryWithCipherColumn());
        result.setDataConverterName(data.getDataConverterName());
        data.getDataConverters().forEach((key, value) -> result.getDataConverters().put((String)key, this.onRuleAlteredActionYamlSwapper.swapToYamlConfiguration(value)));
        return result;
    }

    public EncryptRuleConfiguration swapToObject(YamlEncryptRuleConfiguration yamlConfig) {
        LinkedHashMap dataConverters = new LinkedHashMap();
        yamlConfig.getDataConverters().forEach((key, value) -> dataConverters.put(key, this.onRuleAlteredActionYamlSwapper.swapToObject(value)));
        return new EncryptRuleConfiguration(this.swapTables(yamlConfig), this.swapEncryptAlgorithm(yamlConfig), yamlConfig.isQueryWithCipherColumn(), yamlConfig.getDataConverterName(), dataConverters);
    }

    private Collection<EncryptTableRuleConfiguration> swapTables(YamlEncryptRuleConfiguration yamlConfig) {
        LinkedList<EncryptTableRuleConfiguration> result = new LinkedList<EncryptTableRuleConfiguration>();
        for (Map.Entry<String, YamlEncryptTableRuleConfiguration> entry : yamlConfig.getTables().entrySet()) {
            YamlEncryptTableRuleConfiguration yamlEncryptTableRuleConfig = entry.getValue();
            yamlEncryptTableRuleConfig.setName(entry.getKey());
            result.add(this.tableYamlSwapper.swapToObject(yamlEncryptTableRuleConfig));
        }
        return result;
    }

    private Map<String, ShardingSphereAlgorithmConfiguration> swapEncryptAlgorithm(YamlEncryptRuleConfiguration yamlConfig) {
        LinkedHashMap<String, ShardingSphereAlgorithmConfiguration> result = new LinkedHashMap<String, ShardingSphereAlgorithmConfiguration>(yamlConfig.getEncryptors().size(), 1.0f);
        for (Map.Entry<String, YamlShardingSphereAlgorithmConfiguration> entry : yamlConfig.getEncryptors().entrySet()) {
            result.put(entry.getKey(), this.algorithmSwapper.swapToObject(entry.getValue()));
        }
        return result;
    }

    public Class<EncryptRuleConfiguration> getTypeClass() {
        return EncryptRuleConfiguration.class;
    }

    public String getRuleTagName() {
        return "ENCRYPT";
    }

    public int getOrder() {
        return 10;
    }
}

