/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rule;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.algorithm.config.AlgorithmProvidedEncryptRuleConfiguration;
import org.apache.shardingsphere.encrypt.api.config.EncryptRuleConfiguration;
import org.apache.shardingsphere.encrypt.api.config.rule.EncryptColumnRuleConfiguration;
import org.apache.shardingsphere.encrypt.api.config.rule.EncryptTableRuleConfiguration;
import org.apache.shardingsphere.encrypt.context.EncryptContextBuilder;
import org.apache.shardingsphere.encrypt.factory.EncryptAlgorithmFactory;
import org.apache.shardingsphere.encrypt.rule.EncryptColumn;
import org.apache.shardingsphere.encrypt.rule.EncryptTable;
import org.apache.shardingsphere.encrypt.spi.EncryptAlgorithm;
import org.apache.shardingsphere.encrypt.spi.QueryAssistedEncryptAlgorithm;
import org.apache.shardingsphere.encrypt.spi.context.EncryptContext;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithmConfiguration;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.aware.SchemaMetaDataAware;
import org.apache.shardingsphere.infra.rule.identifier.scope.SchemaRule;
import org.apache.shardingsphere.infra.rule.identifier.type.TableContainedRule;

public final class EncryptRule
implements SchemaRule,
TableContainedRule {
    private final Map<String, EncryptAlgorithm> encryptors = new LinkedHashMap<String, EncryptAlgorithm>();
    private final Map<String, EncryptTable> tables = new LinkedHashMap<String, EncryptTable>();
    private final boolean queryWithCipherColumn;

    public EncryptRule(EncryptRuleConfiguration config) {
        Preconditions.checkArgument((boolean)this.isValidRuleConfiguration(config), (Object)"Invalid encrypt column configurations in EncryptTableRuleConfigurations.");
        config.getEncryptors().forEach((key, value) -> this.encryptors.put((String)key, EncryptAlgorithmFactory.newInstance((ShardingSphereAlgorithmConfiguration)value)));
        config.getTables().forEach(each -> this.tables.put(each.getName().toLowerCase(), new EncryptTable((EncryptTableRuleConfiguration)each)));
        this.queryWithCipherColumn = config.isQueryWithCipherColumn();
    }

    public EncryptRule(AlgorithmProvidedEncryptRuleConfiguration config) {
        Preconditions.checkArgument((boolean)this.isValidRuleConfigurationWithAlgorithmProvided(config), (Object)"Invalid encrypt column configurations in EncryptTableRuleConfigurations.");
        this.encryptors.putAll(config.getEncryptors());
        config.getTables().forEach(each -> this.tables.put(each.getName().toLowerCase(), new EncryptTable((EncryptTableRuleConfiguration)each)));
        this.queryWithCipherColumn = config.isQueryWithCipherColumn();
    }

    private boolean isValidRuleConfiguration(EncryptRuleConfiguration config) {
        return config.getEncryptors().isEmpty() && config.getTables().isEmpty() || this.isValidTableConfiguration(config);
    }

    private boolean isValidTableConfiguration(EncryptRuleConfiguration config) {
        for (EncryptTableRuleConfiguration table : config.getTables()) {
            for (EncryptColumnRuleConfiguration column : table.getColumns()) {
                if (this.isValidColumnConfiguration(config, column)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isValidColumnConfiguration(EncryptRuleConfiguration encryptRuleConfig, EncryptColumnRuleConfiguration column) {
        return !Strings.isNullOrEmpty((String)column.getEncryptorName()) && !Strings.isNullOrEmpty((String)column.getCipherColumn()) && this.containsEncryptors(encryptRuleConfig, column);
    }

    private boolean containsEncryptors(EncryptRuleConfiguration encryptRuleConfig, EncryptColumnRuleConfiguration column) {
        return encryptRuleConfig.getEncryptors().keySet().stream().anyMatch(each -> each.equals(column.getEncryptorName()));
    }

    private boolean isValidRuleConfigurationWithAlgorithmProvided(AlgorithmProvidedEncryptRuleConfiguration config) {
        return config.getEncryptors().isEmpty() && config.getTables().isEmpty() || this.isValidTableConfigurationWithAlgorithmProvided(config);
    }

    private boolean isValidTableConfigurationWithAlgorithmProvided(AlgorithmProvidedEncryptRuleConfiguration config) {
        for (EncryptTableRuleConfiguration table : config.getTables()) {
            for (EncryptColumnRuleConfiguration column : table.getColumns()) {
                if (this.isValidColumnConfigurationWithAlgorithmProvided(config, column)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isValidColumnConfigurationWithAlgorithmProvided(AlgorithmProvidedEncryptRuleConfiguration encryptRuleConfig, EncryptColumnRuleConfiguration column) {
        return !Strings.isNullOrEmpty((String)column.getEncryptorName()) && !Strings.isNullOrEmpty((String)column.getCipherColumn()) && encryptRuleConfig.getEncryptors().containsKey(column.getEncryptorName());
    }

    public Optional<EncryptTable> findEncryptTable(String logicTable) {
        return Optional.ofNullable(this.tables.get(logicTable.toLowerCase()));
    }

    public Optional<EncryptColumn> findEncryptColumn(String logicTable, String columnName) {
        return this.findEncryptTable(logicTable).flatMap(optional -> optional.findEncryptColumn(columnName));
    }

    public Optional<EncryptAlgorithm> findEncryptor(String logicTable, String logicColumn) {
        String lowerCaseLogicTable = logicTable.toLowerCase();
        return this.tables.containsKey(lowerCaseLogicTable) ? this.tables.get(lowerCaseLogicTable).findEncryptorName(logicColumn).map(this.encryptors::get) : Optional.empty();
    }

    public List<Object> getEncryptValues(String databaseName, String schemaName, String logicTable, String logicColumn, List<Object> originalValues) {
        Optional<EncryptAlgorithm> encryptor = this.findEncryptor(logicTable, logicColumn);
        EncryptContext encryptContext = EncryptContextBuilder.build(databaseName, schemaName, logicTable, logicColumn);
        Preconditions.checkArgument((boolean)encryptor.isPresent(), (String)"Can not find EncryptAlgorithm by %s.%s.", (Object)logicTable, (Object)logicColumn);
        return this.getEncryptValues(encryptor.get(), originalValues, encryptContext);
    }

    private List<Object> getEncryptValues(EncryptAlgorithm encryptor, List<Object> originalValues, EncryptContext encryptContext) {
        LinkedList<Object> result = new LinkedList<Object>();
        for (Object each : originalValues) {
            Object encryptValue = null == each ? null : encryptor.encrypt(each, encryptContext);
            result.add(encryptValue);
        }
        return result;
    }

    public String getCipherColumn(String logicTable, String logicColumn) {
        return this.tables.get(logicTable.toLowerCase()).getCipherColumn(logicColumn);
    }

    public Map<String, String> getLogicAndCipherColumns(String logicTable) {
        String lowerCaseLogicTable = logicTable.toLowerCase();
        return this.tables.containsKey(lowerCaseLogicTable) ? this.tables.get(lowerCaseLogicTable).getLogicAndCipherColumns() : Collections.emptyMap();
    }

    public Optional<String> findAssistedQueryColumn(String logicTable, String logicColumn) {
        String lowerCaseLogicTable = logicTable.toLowerCase();
        return this.tables.containsKey(lowerCaseLogicTable) ? this.tables.get(lowerCaseLogicTable).findAssistedQueryColumn(logicColumn) : Optional.empty();
    }

    public Collection<String> getAssistedQueryColumns(String logicTable) {
        return this.tables.containsKey(logicTable.toLowerCase()) ? this.tables.get(logicTable.toLowerCase()).getAssistedQueryColumns() : Collections.emptyList();
    }

    public List<Object> getEncryptAssistedQueryValues(String databaseName, String schemaName, String logicTable, String logicColumn, List<Object> originalValues) {
        Optional<EncryptAlgorithm> encryptor = this.findEncryptor(logicTable, logicColumn);
        EncryptContext encryptContext = EncryptContextBuilder.build(databaseName, schemaName, logicTable, logicColumn);
        Preconditions.checkArgument((encryptor.isPresent() && encryptor.get() instanceof QueryAssistedEncryptAlgorithm ? 1 : 0) != 0, (String)"Can not find QueryAssistedEncryptAlgorithm by %s.%s.", (Object)logicTable, (Object)logicColumn);
        return this.getEncryptAssistedQueryValues((QueryAssistedEncryptAlgorithm)encryptor.get(), originalValues, encryptContext);
    }

    private List<Object> getEncryptAssistedQueryValues(QueryAssistedEncryptAlgorithm encryptor, List<Object> originalValues, EncryptContext encryptContext) {
        LinkedList<Object> result = new LinkedList<Object>();
        for (Object each : originalValues) {
            result.add(null == each ? null : encryptor.queryAssistedEncrypt(each, encryptContext));
        }
        return result;
    }

    public Optional<String> findPlainColumn(String logicTable, String logicColumn) {
        Optional<String> originColumnName = this.findOriginColumnName(logicTable, logicColumn);
        return originColumnName.isPresent() && this.tables.containsKey(logicTable.toLowerCase()) ? this.tables.get(logicTable.toLowerCase()).findPlainColumn(originColumnName.get()) : Optional.empty();
    }

    public boolean isQueryWithCipherColumn(String logicTable, String logicColumn) {
        return this.findEncryptTable(logicTable).flatMap(encryptTable -> encryptTable.getQueryWithCipherColumn(logicColumn)).orElse(this.queryWithCipherColumn);
    }

    private Optional<String> findOriginColumnName(String logicTable, String logicColumn) {
        for (String each : this.tables.get(logicTable.toLowerCase()).getLogicColumns()) {
            if (!logicColumn.equalsIgnoreCase(each)) continue;
            return Optional.of(each);
        }
        return Optional.empty();
    }

    public Collection<String> getTables() {
        return this.tables.keySet();
    }

    public String getType() {
        return EncryptRule.class.getSimpleName();
    }

    public void setSchemaMetaData(String databaseName, Map<String, ShardingSphereSchema> schemas) {
        for (EncryptAlgorithm each : this.encryptors.values()) {
            if (!(each instanceof SchemaMetaDataAware)) continue;
            ((SchemaMetaDataAware)each).setDatabaseName(databaseName);
            ((SchemaMetaDataAware)each).setSchemas(schemas);
        }
    }

    @Generated
    public boolean isQueryWithCipherColumn() {
        return this.queryWithCipherColumn;
    }
}

