/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.token.generator;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.rewrite.aware.DatabaseNameAware;
import org.apache.shardingsphere.encrypt.rewrite.token.pojo.EncryptAssignmentToken;
import org.apache.shardingsphere.encrypt.rewrite.token.pojo.EncryptLiteralAssignmentToken;
import org.apache.shardingsphere.encrypt.rewrite.token.pojo.EncryptParameterAssignmentToken;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.rule.aware.EncryptRuleAware;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.UpdateStatementContext;
import org.apache.shardingsphere.infra.binder.type.TableAvailable;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.CollectionSQLTokenGenerator;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.assignment.AssignmentSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.assignment.SetAssignmentSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.InsertStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.UpdateStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.dml.InsertStatementHandler;

public final class EncryptAssignmentTokenGenerator
implements CollectionSQLTokenGenerator,
EncryptRuleAware,
DatabaseNameAware {
    private EncryptRule encryptRule;
    private String databaseName;

    public boolean isGenerateSQLToken(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof UpdateStatementContext || sqlStatementContext instanceof InsertStatementContext && InsertStatementHandler.getSetAssignmentSegment((InsertStatement)((InsertStatement)((InsertStatementContext)sqlStatementContext).getSqlStatement())).isPresent();
    }

    public Collection<EncryptAssignmentToken> generateSQLTokens(SQLStatementContext sqlStatementContext) {
        LinkedList<EncryptAssignmentToken> result = new LinkedList<EncryptAssignmentToken>();
        String tableName = ((SimpleTableSegment)((TableAvailable)sqlStatementContext).getAllTables().iterator().next()).getTableName().getIdentifier().getValue();
        String schemaName = sqlStatementContext.getTablesContext().getSchemaName().orElseGet(() -> DatabaseTypeEngine.getDefaultSchemaName((DatabaseType)sqlStatementContext.getDatabaseType(), (String)this.databaseName));
        for (AssignmentSegment each : this.getSetAssignmentSegment(sqlStatementContext.getSqlStatement()).getAssignments()) {
            if (!this.encryptRule.findEncryptor(tableName, ((ColumnSegment)each.getColumns().get(0)).getIdentifier().getValue()).isPresent()) continue;
            this.generateSQLToken(schemaName, tableName, each).ifPresent(result::add);
        }
        return result;
    }

    private SetAssignmentSegment getSetAssignmentSegment(SQLStatement sqlStatement) {
        if (sqlStatement instanceof InsertStatement) {
            Optional result = InsertStatementHandler.getSetAssignmentSegment((InsertStatement)((InsertStatement)sqlStatement));
            Preconditions.checkState((boolean)result.isPresent());
            return (SetAssignmentSegment)result.get();
        }
        return ((UpdateStatement)sqlStatement).getSetAssignment();
    }

    private Optional<EncryptAssignmentToken> generateSQLToken(String schemaName, String tableName, AssignmentSegment assignmentSegment) {
        if (assignmentSegment.getValue() instanceof ParameterMarkerExpressionSegment) {
            return Optional.of(this.generateParameterSQLToken(tableName, assignmentSegment));
        }
        if (assignmentSegment.getValue() instanceof LiteralExpressionSegment) {
            return Optional.of(this.generateLiteralSQLToken(schemaName, tableName, assignmentSegment));
        }
        return Optional.empty();
    }

    private EncryptAssignmentToken generateParameterSQLToken(String tableName, AssignmentSegment assignmentSegment) {
        EncryptParameterAssignmentToken result = new EncryptParameterAssignmentToken(((ColumnSegment)assignmentSegment.getColumns().get(0)).getStartIndex(), assignmentSegment.getStopIndex());
        String columnName = ((ColumnSegment)assignmentSegment.getColumns().get(0)).getIdentifier().getValue();
        this.addCipherColumn(tableName, columnName, result);
        this.addAssistedQueryColumn(tableName, columnName, result);
        this.addPlainColumn(tableName, columnName, result);
        return result;
    }

    private void addCipherColumn(String tableName, String columnName, EncryptParameterAssignmentToken token) {
        token.addColumnName(this.encryptRule.getCipherColumn(tableName, columnName));
    }

    private void addAssistedQueryColumn(String tableName, String columnName, EncryptParameterAssignmentToken token) {
        this.encryptRule.findAssistedQueryColumn(tableName, columnName).ifPresent(token::addColumnName);
    }

    private void addPlainColumn(String tableName, String columnName, EncryptParameterAssignmentToken token) {
        this.encryptRule.findPlainColumn(tableName, columnName).ifPresent(token::addColumnName);
    }

    private EncryptAssignmentToken generateLiteralSQLToken(String schemaName, String tableName, AssignmentSegment assignmentSegment) {
        EncryptLiteralAssignmentToken result = new EncryptLiteralAssignmentToken(((ColumnSegment)assignmentSegment.getColumns().get(0)).getStartIndex(), assignmentSegment.getStopIndex());
        this.addCipherAssignment(schemaName, tableName, assignmentSegment, result);
        this.addAssistedQueryAssignment(schemaName, tableName, assignmentSegment, result);
        this.addPlainAssignment(tableName, assignmentSegment, result);
        return result;
    }

    private void addCipherAssignment(String schemaName, String tableName, AssignmentSegment assignmentSegment, EncryptLiteralAssignmentToken token) {
        Object originalValue = ((LiteralExpressionSegment)assignmentSegment.getValue()).getLiterals();
        Object cipherValue = this.encryptRule.getEncryptValues(this.databaseName, schemaName, tableName, ((ColumnSegment)assignmentSegment.getColumns().get(0)).getIdentifier().getValue(), Collections.singletonList(originalValue)).iterator().next();
        token.addAssignment(this.encryptRule.getCipherColumn(tableName, ((ColumnSegment)assignmentSegment.getColumns().get(0)).getIdentifier().getValue()), cipherValue);
    }

    private void addAssistedQueryAssignment(String schemaName, String tableName, AssignmentSegment assignmentSegment, EncryptLiteralAssignmentToken token) {
        Object originalValue = ((LiteralExpressionSegment)assignmentSegment.getValue()).getLiterals();
        Optional<String> assistedQueryColumn = this.encryptRule.findAssistedQueryColumn(tableName, ((ColumnSegment)assignmentSegment.getColumns().get(0)).getIdentifier().getValue());
        if (assistedQueryColumn.isPresent()) {
            Object assistedQueryValue = this.encryptRule.getEncryptAssistedQueryValues(this.databaseName, schemaName, tableName, ((ColumnSegment)assignmentSegment.getColumns().get(0)).getIdentifier().getValue(), Collections.singletonList(originalValue)).iterator().next();
            token.addAssignment(assistedQueryColumn.get(), assistedQueryValue);
        }
    }

    private void addPlainAssignment(String tableName, AssignmentSegment assignmentSegment, EncryptLiteralAssignmentToken token) {
        Object originalValue = ((LiteralExpressionSegment)assignmentSegment.getValue()).getLiterals();
        this.encryptRule.findPlainColumn(tableName, ((ColumnSegment)assignmentSegment.getColumns().get(0)).getIdentifier().getValue()).ifPresent(optional -> token.addAssignment((String)optional, originalValue));
    }

    @Override
    @Generated
    public void setEncryptRule(EncryptRule encryptRule) {
        this.encryptRule = encryptRule;
    }

    @Override
    @Generated
    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }
}

