/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.parameter.rewriter;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.context.EncryptContextBuilder;
import org.apache.shardingsphere.encrypt.rewrite.aware.DatabaseNameAware;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.rule.aware.EncryptRuleAware;
import org.apache.shardingsphere.encrypt.spi.EncryptAlgorithm;
import org.apache.shardingsphere.encrypt.spi.QueryAssistedEncryptAlgorithm;
import org.apache.shardingsphere.encrypt.spi.context.EncryptContext;
import org.apache.shardingsphere.infra.binder.segment.insert.values.InsertValueContext;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.exception.ShardingSphereException;
import org.apache.shardingsphere.infra.rewrite.parameter.builder.ParameterBuilder;
import org.apache.shardingsphere.infra.rewrite.parameter.builder.impl.GroupedParameterBuilder;
import org.apache.shardingsphere.infra.rewrite.parameter.builder.impl.StandardParameterBuilder;
import org.apache.shardingsphere.infra.rewrite.parameter.rewriter.ParameterRewriter;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.InsertStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.dml.InsertStatementHandler;

public final class EncryptInsertValueParameterRewriter
implements ParameterRewriter<InsertStatementContext>,
EncryptRuleAware,
DatabaseNameAware {
    private EncryptRule encryptRule;
    private String databaseName;

    public boolean isNeedRewrite(SQLStatementContext<?> sqlStatementContext) {
        return sqlStatementContext instanceof InsertStatementContext && !InsertStatementHandler.getSetAssignmentSegment((InsertStatement)((InsertStatement)((InsertStatementContext)sqlStatementContext).getSqlStatement())).isPresent() && null == ((InsertStatementContext)sqlStatementContext).getInsertSelectContext();
    }

    public void rewrite(ParameterBuilder parameterBuilder, InsertStatementContext insertStatementContext, List<Object> parameters) {
        String tableName = ((InsertStatement)insertStatementContext.getSqlStatement()).getTable().getTableName().getIdentifier().getValue();
        Iterator descendingColumnNames = insertStatementContext.getDescendingColumnNames();
        String schemaName = insertStatementContext.getTablesContext().getSchemaName().orElseGet(() -> DatabaseTypeEngine.getDefaultSchemaName((DatabaseType)insertStatementContext.getDatabaseType(), (String)this.databaseName));
        while (descendingColumnNames.hasNext()) {
            String columnName = (String)descendingColumnNames.next();
            EncryptContext encryptContext = EncryptContextBuilder.build(this.databaseName, schemaName, tableName, columnName);
            this.encryptRule.findEncryptor(tableName, columnName).ifPresent(optional -> this.encryptInsertValues((GroupedParameterBuilder)parameterBuilder, insertStatementContext, (EncryptAlgorithm<?, ?>)optional, encryptContext));
        }
    }

    private void encryptInsertValues(GroupedParameterBuilder parameterBuilder, InsertStatementContext insertStatementContext, EncryptAlgorithm<?, ?> encryptAlgorithm, EncryptContext encryptContext) {
        int columnIndex = this.getColumnIndex(parameterBuilder, insertStatementContext, encryptContext.getColumnName());
        int count = 0;
        for (List each : insertStatementContext.getGroupedParameters()) {
            int parameterIndex = ((InsertValueContext)insertStatementContext.getInsertValueContexts().get(count)).getParameterIndex(columnIndex);
            if (!each.isEmpty()) {
                StandardParameterBuilder standardParameterBuilder = (StandardParameterBuilder)parameterBuilder.getParameterBuilders().get(count);
                ExpressionSegment expressionSegment = (ExpressionSegment)((InsertValueContext)insertStatementContext.getInsertValueContexts().get(count)).getValueExpressions().get(columnIndex);
                if (expressionSegment instanceof ParameterMarkerExpressionSegment) {
                    this.encryptInsertValue(encryptAlgorithm, parameterIndex, ((InsertValueContext)insertStatementContext.getInsertValueContexts().get(count)).getValue(columnIndex).orElseThrow(() -> new ShardingSphereException("Not support for encrypt!", new Object[0])), standardParameterBuilder, encryptContext);
                }
            }
            ++count;
        }
    }

    private int getColumnIndex(GroupedParameterBuilder parameterBuilder, InsertStatementContext insertStatementContext, String encryptLogicColumnName) {
        ArrayList columnNames;
        if (parameterBuilder.getDerivedColumnName().isPresent()) {
            columnNames = new ArrayList(insertStatementContext.getColumnNames());
            columnNames.remove(parameterBuilder.getDerivedColumnName().get());
        } else {
            columnNames = insertStatementContext.getColumnNames();
        }
        return columnNames.indexOf(encryptLogicColumnName);
    }

    private void encryptInsertValue(EncryptAlgorithm encryptAlgorithm, int parameterIndex, Object originalValue, StandardParameterBuilder parameterBuilder, EncryptContext encryptContext) {
        parameterBuilder.addReplacedParameters(parameterIndex, encryptAlgorithm.encrypt(originalValue, encryptContext));
        LinkedList<Object> addedParameters = new LinkedList<Object>();
        if (encryptAlgorithm instanceof QueryAssistedEncryptAlgorithm) {
            Optional<String> assistedColumnName = this.encryptRule.findAssistedQueryColumn(encryptContext.getTableName(), encryptContext.getColumnName());
            Preconditions.checkArgument((boolean)assistedColumnName.isPresent(), (Object)"Can not find assisted query Column Name");
            addedParameters.add(((QueryAssistedEncryptAlgorithm)encryptAlgorithm).queryAssistedEncrypt(originalValue, encryptContext));
        }
        if (this.encryptRule.findPlainColumn(encryptContext.getTableName(), encryptContext.getColumnName()).isPresent()) {
            addedParameters.add(originalValue);
        }
        if (!addedParameters.isEmpty()) {
            if (!parameterBuilder.getAddedIndexAndParameters().containsKey(parameterIndex + 1)) {
                parameterBuilder.getAddedIndexAndParameters().put(parameterIndex + 1, new LinkedList());
            }
            ((Collection)parameterBuilder.getAddedIndexAndParameters().get(parameterIndex + 1)).addAll(addedParameters);
        }
    }

    @Override
    @Generated
    public void setEncryptRule(EncryptRule encryptRule) {
        this.encryptRule = encryptRule;
    }

    @Override
    @Generated
    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }
}

