/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.parameter;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.rewrite.aware.DatabaseNameAware;
import org.apache.shardingsphere.encrypt.rewrite.aware.EncryptConditionsAware;
import org.apache.shardingsphere.encrypt.rewrite.condition.EncryptCondition;
import org.apache.shardingsphere.encrypt.rewrite.parameter.rewriter.EncryptAssignmentParameterRewriter;
import org.apache.shardingsphere.encrypt.rewrite.parameter.rewriter.EncryptInsertOnDuplicateKeyUpdateValueParameterRewriter;
import org.apache.shardingsphere.encrypt.rewrite.parameter.rewriter.EncryptInsertValueParameterRewriter;
import org.apache.shardingsphere.encrypt.rewrite.parameter.rewriter.EncryptPredicateParameterRewriter;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.rule.aware.EncryptRuleAware;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.rewrite.parameter.rewriter.ParameterRewriter;
import org.apache.shardingsphere.infra.rewrite.parameter.rewriter.ParameterRewriterBuilder;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.aware.SchemaMetaDataAware;

public final class EncryptParameterRewriterBuilder
implements ParameterRewriterBuilder {
    private final EncryptRule encryptRule;
    private final String databaseName;
    private final Map<String, ShardingSphereSchema> schemas;
    private final SQLStatementContext<?> sqlStatementContext;
    private final Collection<EncryptCondition> encryptConditions;

    public Collection<ParameterRewriter> getParameterRewriters() {
        LinkedList<ParameterRewriter> result = new LinkedList<ParameterRewriter>();
        this.addParameterRewriter(result, new EncryptAssignmentParameterRewriter());
        this.addParameterRewriter(result, new EncryptPredicateParameterRewriter());
        this.addParameterRewriter(result, new EncryptInsertValueParameterRewriter());
        this.addParameterRewriter(result, new EncryptInsertOnDuplicateKeyUpdateValueParameterRewriter());
        return result;
    }

    private void addParameterRewriter(Collection<ParameterRewriter> parameterRewriters, ParameterRewriter<?> toBeAddedParameterRewriter) {
        if (toBeAddedParameterRewriter.isNeedRewrite(this.sqlStatementContext)) {
            this.setUpParameterRewriter(toBeAddedParameterRewriter);
            parameterRewriters.add(toBeAddedParameterRewriter);
        }
    }

    private void setUpParameterRewriter(ParameterRewriter toBeAddedParameterRewriter) {
        if (toBeAddedParameterRewriter instanceof SchemaMetaDataAware) {
            ((SchemaMetaDataAware)toBeAddedParameterRewriter).setSchemas(this.schemas);
        }
        if (toBeAddedParameterRewriter instanceof EncryptRuleAware) {
            ((EncryptRuleAware)toBeAddedParameterRewriter).setEncryptRule(this.encryptRule);
        }
        if (toBeAddedParameterRewriter instanceof EncryptConditionsAware) {
            ((EncryptConditionsAware)toBeAddedParameterRewriter).setEncryptConditions(this.encryptConditions);
        }
        if (toBeAddedParameterRewriter instanceof DatabaseNameAware) {
            ((DatabaseNameAware)toBeAddedParameterRewriter).setDatabaseName(this.databaseName);
        }
    }

    @Generated
    public EncryptParameterRewriterBuilder(EncryptRule encryptRule, String databaseName, Map<String, ShardingSphereSchema> schemas, SQLStatementContext<?> sqlStatementContext, Collection<EncryptCondition> encryptConditions) {
        this.encryptRule = encryptRule;
        this.databaseName = databaseName;
        this.schemas = schemas;
        this.sqlStatementContext = sqlStatementContext;
        this.encryptConditions = encryptConditions;
    }
}

