/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.condition;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.rewrite.condition.EncryptCondition;
import org.apache.shardingsphere.encrypt.rewrite.condition.impl.EncryptEqualCondition;
import org.apache.shardingsphere.encrypt.rewrite.condition.impl.EncryptInCondition;
import org.apache.shardingsphere.encrypt.rule.EncryptColumn;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.exception.ShardingSphereException;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereSchema;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.BetweenExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.InExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.SimpleExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.subquery.SubqueryExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.AndPredicate;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.sql.common.util.ColumnExtractor;
import org.apache.shardingsphere.sql.parser.sql.common.util.ExpressionExtractUtil;

public final class EncryptConditionEngine {
    private static final Set<String> LOGICAL_OPERATOR = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    private static final Set<String> SUPPORTED_COMPARE_OPERATOR = new HashSet<String>();
    private final EncryptRule encryptRule;
    private final Map<String, ShardingSphereSchema> schemas;

    public Collection<EncryptCondition> createEncryptConditions(Collection<WhereSegment> whereSegments, Collection<ColumnSegment> columnSegments, SQLStatementContext<?> sqlStatementContext, String databaseName) {
        LinkedList<EncryptCondition> result = new LinkedList<EncryptCondition>();
        String defaultSchema = DatabaseTypeEngine.getDefaultSchemaName((DatabaseType)sqlStatementContext.getDatabaseType(), (String)databaseName);
        ShardingSphereSchema schema = sqlStatementContext.getTablesContext().getSchemaName().map(this.schemas::get).orElse(this.schemas.get(defaultSchema));
        Map expressionTableNames = sqlStatementContext.getTablesContext().findTableNamesByColumnSegment(columnSegments, schema);
        for (WhereSegment each : whereSegments) {
            Collection andPredicates = ExpressionExtractUtil.getAndPredicates((ExpressionSegment)each.getExpr());
            for (AndPredicate predicate : andPredicates) {
                this.addEncryptConditions(result, predicate.getPredicates(), (Map<String, String>)expressionTableNames);
            }
        }
        return result;
    }

    private void addEncryptConditions(Collection<EncryptCondition> encryptConditions, Collection<ExpressionSegment> predicates, Map<String, String> expressionTableNames) {
        HashSet<Integer> stopIndexes = new HashSet<Integer>(predicates.size(), 1.0f);
        for (ExpressionSegment each : predicates) {
            if (!stopIndexes.add(each.getStopIndex())) continue;
            this.addEncryptConditions(encryptConditions, each, expressionTableNames);
        }
    }

    private void addEncryptConditions(Collection<EncryptCondition> encryptConditions, ExpressionSegment expression, Map<String, String> expressionTableNames) {
        if (!ExpressionExtractUtil.findNotContainsNullLiteralsExpression((ExpressionSegment)expression).isPresent()) {
            return;
        }
        for (ColumnSegment each : ColumnExtractor.extract((ExpressionSegment)expression)) {
            String tableName = expressionTableNames.getOrDefault(each.getExpression(), "");
            Optional<EncryptColumn> encryptColumn = this.encryptRule.findEncryptColumn(tableName, each.getIdentifier().getValue());
            Optional<EncryptCondition> encryptCondition = encryptColumn.isPresent() ? this.createEncryptCondition(expression, tableName) : Optional.empty();
            encryptCondition.ifPresent(encryptConditions::add);
        }
    }

    private Optional<EncryptCondition> createEncryptCondition(ExpressionSegment expression, String tableName) {
        if (expression instanceof BinaryOperationExpression) {
            return this.createBinaryEncryptCondition((BinaryOperationExpression)expression, tableName);
        }
        if (expression instanceof InExpression) {
            return EncryptConditionEngine.createInEncryptCondition(tableName, (InExpression)expression, ((InExpression)expression).getRight());
        }
        if (expression instanceof BetweenExpression) {
            throw new ShardingSphereException("The SQL clause 'BETWEEN...AND...' is unsupported in encrypt rule.", new Object[0]);
        }
        return Optional.empty();
    }

    private Optional<EncryptCondition> createBinaryEncryptCondition(BinaryOperationExpression expression, String tableName) {
        String operator = expression.getOperator();
        if (!LOGICAL_OPERATOR.contains(operator)) {
            if (SUPPORTED_COMPARE_OPERATOR.contains(operator)) {
                return this.createCompareEncryptCondition(tableName, expression, expression.getRight());
            }
            throw new ShardingSphereException("The SQL clause '%s' is unsupported in encrypt rule.", new Object[]{operator});
        }
        return Optional.empty();
    }

    private Optional<EncryptCondition> createCompareEncryptCondition(String tableName, BinaryOperationExpression expression, ExpressionSegment compareRightValue) {
        if (!(expression.getLeft() instanceof ColumnSegment)) {
            return Optional.empty();
        }
        return compareRightValue instanceof SimpleExpressionSegment && !(compareRightValue instanceof SubqueryExpressionSegment) ? Optional.of(this.createEncryptEqualCondition(tableName, expression, compareRightValue)) : Optional.empty();
    }

    private EncryptEqualCondition createEncryptEqualCondition(String tableName, BinaryOperationExpression expression, ExpressionSegment compareRightValue) {
        String columnName = ((ColumnSegment)expression.getLeft()).getIdentifier().getValue();
        return new EncryptEqualCondition(columnName, tableName, compareRightValue.getStartIndex(), expression.getStopIndex(), compareRightValue);
    }

    private static Optional<EncryptCondition> createInEncryptCondition(String tableName, InExpression inExpression, ExpressionSegment inRightValue) {
        if (!(inExpression.getLeft() instanceof ColumnSegment)) {
            return Optional.empty();
        }
        LinkedList<ExpressionSegment> expressionSegments = new LinkedList<ExpressionSegment>();
        for (ExpressionSegment each : inExpression.getExpressionList()) {
            if (!(each instanceof SimpleExpressionSegment)) continue;
            expressionSegments.add(each);
        }
        if (expressionSegments.isEmpty()) {
            return Optional.empty();
        }
        String columnName = ((ColumnSegment)inExpression.getLeft()).getIdentifier().getValue();
        return Optional.of(new EncryptInCondition(columnName, tableName, inRightValue.getStartIndex(), inRightValue.getStopIndex(), expressionSegments));
    }

    @Generated
    public EncryptConditionEngine(EncryptRule encryptRule, Map<String, ShardingSphereSchema> schemas) {
        this.encryptRule = encryptRule;
        this.schemas = schemas;
    }

    static {
        LOGICAL_OPERATOR.add("AND");
        LOGICAL_OPERATOR.add("&&");
        LOGICAL_OPERATOR.add("OR");
        LOGICAL_OPERATOR.add("||");
        SUPPORTED_COMPARE_OPERATOR.add("=");
        SUPPORTED_COMPARE_OPERATOR.add("<>");
        SUPPORTED_COMPARE_OPERATOR.add("!=");
        SUPPORTED_COMPARE_OPERATOR.add(">");
        SUPPORTED_COMPARE_OPERATOR.add("<");
        SUPPORTED_COMPARE_OPERATOR.add(">=");
        SUPPORTED_COMPARE_OPERATOR.add("<=");
        SUPPORTED_COMPARE_OPERATOR.add("IS");
    }
}

