/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.metadata;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.rule.EncryptTable;
import org.apache.shardingsphere.infra.metadata.database.schema.builder.GenericSchemaBuilderMaterials;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.spi.RuleBasedSchemaMetaDataDecorator;
import org.apache.shardingsphere.infra.metadata.database.schema.loader.model.ColumnMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.loader.model.SchemaMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.loader.model.TableMetaData;

public final class EncryptSchemaMetaDataDecorator
implements RuleBasedSchemaMetaDataDecorator<EncryptRule> {
    public Map<String, SchemaMetaData> decorate(Map<String, SchemaMetaData> schemaMetaDataMap, EncryptRule rule, GenericSchemaBuilderMaterials materials) {
        LinkedHashMap<String, SchemaMetaData> result = new LinkedHashMap<String, SchemaMetaData>(schemaMetaDataMap.size(), 1.0f);
        for (Map.Entry<String, SchemaMetaData> entry : schemaMetaDataMap.entrySet()) {
            LinkedList<TableMetaData> tables = new LinkedList<TableMetaData>();
            for (TableMetaData each : entry.getValue().getTables()) {
                tables.add(this.decorate(each.getName(), each, rule));
            }
            result.put(entry.getKey(), new SchemaMetaData(entry.getKey(), tables));
        }
        return result;
    }

    private TableMetaData decorate(String tableName, TableMetaData tableMetaData, EncryptRule encryptRule) {
        return encryptRule.findEncryptTable(tableName).map(optional -> new TableMetaData(tableName, this.getEncryptColumnMetaDataList((EncryptTable)optional, tableMetaData.getColumns()), tableMetaData.getIndexes(), tableMetaData.getConstrains())).orElse(tableMetaData);
    }

    private Collection<ColumnMetaData> getEncryptColumnMetaDataList(EncryptTable encryptTable, Collection<ColumnMetaData> originalColumnMetaDataList) {
        LinkedList<ColumnMetaData> result = new LinkedList<ColumnMetaData>();
        Collection<String> plainColumns = encryptTable.getPlainColumns();
        Collection<String> assistedQueryColumns = encryptTable.getAssistedQueryColumns();
        for (ColumnMetaData each : originalColumnMetaDataList) {
            String columnName = each.getName();
            if (encryptTable.isCipherColumn(columnName)) {
                result.add(this.createColumnMetaData(encryptTable.getLogicColumn(columnName), each));
                continue;
            }
            if (plainColumns.contains(columnName) || assistedQueryColumns.contains(columnName)) continue;
            result.add(each);
        }
        return result;
    }

    private ColumnMetaData createColumnMetaData(String columnName, ColumnMetaData columnMetaData) {
        return new ColumnMetaData(columnName, columnMetaData.getDataType(), columnMetaData.isPrimaryKey(), columnMetaData.isGenerated(), columnMetaData.isCaseSensitive());
    }

    public int getOrder() {
        return 10;
    }

    public Class<EncryptRule> getTypeClass() {
        return EncryptRule.class;
    }
}

