/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.merge.dql;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.context.EncryptContextBuilder;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.spi.EncryptAlgorithm;
import org.apache.shardingsphere.encrypt.spi.context.EncryptContext;
import org.apache.shardingsphere.infra.binder.segment.select.projection.Projection;
import org.apache.shardingsphere.infra.binder.segment.select.projection.impl.ColumnProjection;
import org.apache.shardingsphere.infra.binder.segment.table.TablesContext;
import org.apache.shardingsphere.infra.binder.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereSchema;

public final class EncryptAlgorithmMetaData {
    private final ShardingSphereDatabase database;
    private final EncryptRule encryptRule;
    private final SelectStatementContext selectStatementContext;

    public Optional<EncryptAlgorithm> findEncryptor(String tableName, String columnName) {
        return this.encryptRule.findEncryptor(tableName, columnName);
    }

    public boolean isQueryWithCipherColumn(String tableName, String columnName) {
        return this.encryptRule.isQueryWithCipherColumn(tableName, columnName);
    }

    public Optional<EncryptContext> findEncryptContext(int columnIndex) {
        Optional<ColumnProjection> columnProjection = this.findColumnProjection(columnIndex);
        if (!columnProjection.isPresent()) {
            return Optional.empty();
        }
        TablesContext tablesContext = this.selectStatementContext.getTablesContext();
        String schemaName = tablesContext.getSchemaName().orElse(DatabaseTypeEngine.getDefaultSchemaName((DatabaseType)this.selectStatementContext.getDatabaseType(), (String)this.database.getName()));
        Map expressionTableNames = tablesContext.findTableNamesByColumnProjection(Collections.singletonList(columnProjection.get()), (ShardingSphereSchema)this.database.getSchemas().get(schemaName));
        Optional<String> tableName = this.findTableName(columnProjection.get(), expressionTableNames);
        return tableName.map(optional -> EncryptContextBuilder.build(this.database.getName(), schemaName, optional, ((ColumnProjection)columnProjection.get()).getName()));
    }

    private Optional<ColumnProjection> findColumnProjection(int columnIndex) {
        List expandProjections = this.selectStatementContext.getProjectionsContext().getExpandProjections();
        if (expandProjections.size() < columnIndex) {
            return Optional.empty();
        }
        Projection projection = (Projection)expandProjections.get(columnIndex - 1);
        return projection instanceof ColumnProjection ? Optional.of((ColumnProjection)projection) : Optional.empty();
    }

    private Optional<String> findTableName(ColumnProjection columnProjection, Map<String, String> columnTableNames) {
        String tableName = columnTableNames.get(columnProjection.getExpression());
        if (null != tableName) {
            return Optional.of(tableName);
        }
        for (String each : this.selectStatementContext.getTablesContext().getTableNames()) {
            if (!this.encryptRule.findEncryptor(each, columnProjection.getName()).isPresent()) continue;
            return Optional.of(each);
        }
        return Optional.empty();
    }

    @Generated
    public EncryptAlgorithmMetaData(ShardingSphereDatabase database, EncryptRule encryptRule, SelectStatementContext selectStatementContext) {
        this.database = database;
        this.encryptRule = encryptRule;
        this.selectStatementContext = selectStatementContext;
    }
}

