/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.distsql.parser.core.advanced;

import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.apache.shardingsphere.distsql.parser.core.advanced.AdvancedDistSQLLexer;
import org.apache.shardingsphere.distsql.parser.core.advanced.AdvancedDistSQLParser;
import org.apache.shardingsphere.distsql.parser.core.advanced.AdvancedDistSQLStatementVisitor;
import org.apache.shardingsphere.sql.parser.api.visitor.ASTNode;
import org.apache.shardingsphere.sql.parser.core.ParseASTNode;
import org.apache.shardingsphere.sql.parser.core.SQLParserFactory;
import org.apache.shardingsphere.sql.parser.exception.SQLParsingException;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class AdvancedDistSQLStatementParserEngine {
    public SQLStatement parse(String sql) {
        ASTNode astNode = this.parseToASTNode(sql);
        return this.getSQLStatement(sql, (ParseASTNode)astNode);
    }

    private ASTNode parseToASTNode(String sql) {
        try {
            return SQLParserFactory.newInstance((String)sql, AdvancedDistSQLLexer.class, AdvancedDistSQLParser.class).parse();
        }
        catch (ParseCancellationException | SQLParsingException ignored) {
            throw new SQLParsingException("You have an error in your SQL syntax.");
        }
    }

    private SQLStatement getSQLStatement(String sql, ParseASTNode parseASTNode) {
        if (parseASTNode.getRootNode() instanceof ErrorNode) {
            throw new SQLParsingException("Unsupported SQL of `%s`", new Object[]{sql});
        }
        return (SQLStatement)new AdvancedDistSQLStatementVisitor().visit(parseASTNode.getRootNode());
    }
}

