/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.core.job.environment;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.config.TableNameSchemaNameMapping;
import org.apache.shardingsphere.data.pipeline.api.config.rulealtered.RuleAlteredJobConfiguration;
import org.apache.shardingsphere.data.pipeline.api.datasource.PipelineDataSourceWrapper;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.PipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.PipelineDataSourceConfigurationFactory;
import org.apache.shardingsphere.data.pipeline.core.context.PipelineContext;
import org.apache.shardingsphere.data.pipeline.core.datasource.PipelineDataSourceFactory;
import org.apache.shardingsphere.data.pipeline.core.sqlbuilder.PipelineSQLBuilderFactory;
import org.apache.shardingsphere.data.pipeline.spi.sqlbuilder.PipelineSQLBuilder;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ScalingEnvironmentManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ScalingEnvironmentManager.class);

    public void cleanupTargetTables(RuleAlteredJobConfiguration jobConfig) throws SQLException {
        List tables = jobConfig.splitLogicTableNames();
        log.info("cleanupTargetTables, tables={}", (Object)tables);
        PipelineDataSourceConfiguration target = jobConfig.getTarget();
        PipelineSQLBuilder pipelineSQLBuilder = PipelineSQLBuilderFactory.getInstance(jobConfig.getTargetDatabaseType());
        ShardingSphereDatabase database = (ShardingSphereDatabase)PipelineContext.getContextManager().getMetaDataContexts().getMetaData().getDatabases().get(jobConfig.getDatabaseName());
        TableNameSchemaNameMapping tableNameSchemaNameMapping = new TableNameSchemaNameMapping(TableNameSchemaNameMapping.convert((Map)database.getSchemas()));
        try (PipelineDataSourceWrapper dataSource = PipelineDataSourceFactory.newInstance(PipelineDataSourceConfigurationFactory.newInstance((String)target.getType(), (String)target.getParameter()));
             Connection connection = dataSource.getConnection();){
            for (String each : tables) {
                String sql = pipelineSQLBuilder.buildTruncateSQL(tableNameSchemaNameMapping.getSchemaName(each), each);
                log.info("cleanupTargetTables, tableName={}, sql={}", (Object)each, (Object)sql);
                PreparedStatement preparedStatement = connection.prepareStatement(sql);
                try {
                    preparedStatement.execute();
                }
                finally {
                    if (preparedStatement == null) continue;
                    preparedStatement.close();
                }
            }
        }
    }
}

