/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.scenario.rulealtered.spi;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.detect.RuleAlteredJobAlmostCompletedParameter;
import org.apache.shardingsphere.data.pipeline.api.ingest.position.FinishedPosition;
import org.apache.shardingsphere.data.pipeline.api.job.progress.JobProgress;
import org.apache.shardingsphere.data.pipeline.spi.detect.JobCompletionDetectAlgorithm;

public final class IdleRuleAlteredJobCompletionDetectAlgorithm
implements JobCompletionDetectAlgorithm<RuleAlteredJobAlmostCompletedParameter> {
    private static final String IDLE_SECOND_THRESHOLD_KEY = "incremental-task-idle-seconds-threshold";
    private static final long DEFAULT_IDLE_SECONDS_THRESHOLD = 1800L;
    private Properties props;
    private volatile long incrementalTaskIdleSecondsThreshold;

    public void init(Properties props) {
        this.props = props;
        this.incrementalTaskIdleSecondsThreshold = this.getIncrementalTaskIdleSecondsThreshold(props);
    }

    private long getIncrementalTaskIdleSecondsThreshold(Properties props) {
        long result = Long.parseLong(props.getOrDefault((Object)IDLE_SECOND_THRESHOLD_KEY, (Object)1800L).toString());
        Preconditions.checkArgument((result > 0L ? 1 : 0) != 0, (Object)"Incremental task idle threshold seconds must be positive.");
        return result;
    }

    public boolean isAlmostCompleted(RuleAlteredJobAlmostCompletedParameter parameter) {
        Collection jobProgresses;
        int jobShardingCount = parameter.getJobShardingCount();
        if (!IdleRuleAlteredJobCompletionDetectAlgorithm.isAllProgressesFilled(jobShardingCount, jobProgresses = parameter.getJobProgresses())) {
            return false;
        }
        if (!IdleRuleAlteredJobCompletionDetectAlgorithm.isAllInventoryTasksCompleted(jobProgresses)) {
            return false;
        }
        Collection<Long> incrementalTasksIdleSeconds = IdleRuleAlteredJobCompletionDetectAlgorithm.getIncrementalTasksIdleSeconds(jobProgresses);
        return incrementalTasksIdleSeconds.stream().allMatch(each -> each >= this.incrementalTaskIdleSecondsThreshold);
    }

    private static boolean isAllProgressesFilled(int jobShardingCount, Collection<JobProgress> jobProgresses) {
        return jobShardingCount == jobProgresses.size() && jobProgresses.stream().allMatch(Objects::nonNull);
    }

    private static boolean isAllInventoryTasksCompleted(Collection<JobProgress> jobProgresses) {
        return jobProgresses.stream().flatMap(each -> each.getInventoryTaskProgressMap().values().stream()).allMatch(each -> each.getPosition() instanceof FinishedPosition);
    }

    private static Collection<Long> getIncrementalTasksIdleSeconds(Collection<JobProgress> jobProgresses) {
        long currentTimeMillis = System.currentTimeMillis();
        return jobProgresses.stream().flatMap(each -> each.getIncrementalTaskProgressMap().values().stream()).map(each -> {
            long latestActiveTimeMillis = each.getIncrementalTaskDelay().getLatestActiveTimeMillis();
            return latestActiveTimeMillis > 0L ? TimeUnit.MILLISECONDS.toSeconds(currentTimeMillis - latestActiveTimeMillis) : 0L;
        }).collect(Collectors.toList());
    }

    public String getType() {
        return "IDLE";
    }

    public String toString() {
        return "IdleRuleAlteredJobCompletionDetectAlgorithm{props=" + this.props + '}';
    }

    @Generated
    public Properties getProps() {
        return this.props;
    }
}

