/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.scenario.rulealtered.prepare;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.config.ingest.DumperConfiguration;
import org.apache.shardingsphere.data.pipeline.api.config.ingest.InventoryDumperConfiguration;
import org.apache.shardingsphere.data.pipeline.api.config.rulealtered.RuleAlteredJobConfiguration;
import org.apache.shardingsphere.data.pipeline.api.config.rulealtered.TaskConfiguration;
import org.apache.shardingsphere.data.pipeline.api.datasource.PipelineDataSourceWrapper;
import org.apache.shardingsphere.data.pipeline.api.ingest.position.IngestPosition;
import org.apache.shardingsphere.data.pipeline.api.ingest.position.IntegerPrimaryKeyPosition;
import org.apache.shardingsphere.data.pipeline.api.ingest.position.PlaceholderPosition;
import org.apache.shardingsphere.data.pipeline.api.ingest.position.PrimaryKeyPosition;
import org.apache.shardingsphere.data.pipeline.api.ingest.position.StringPrimaryKeyPosition;
import org.apache.shardingsphere.data.pipeline.api.job.JobStatus;
import org.apache.shardingsphere.data.pipeline.api.job.progress.JobProgress;
import org.apache.shardingsphere.data.pipeline.api.metadata.LogicTableName;
import org.apache.shardingsphere.data.pipeline.core.datasource.PipelineDataSourceManager;
import org.apache.shardingsphere.data.pipeline.core.exception.PipelineJobCreationException;
import org.apache.shardingsphere.data.pipeline.core.exception.PipelineJobPrepareFailedException;
import org.apache.shardingsphere.data.pipeline.core.execute.ExecuteEngine;
import org.apache.shardingsphere.data.pipeline.core.metadata.loader.PipelineTableMetaDataLoader;
import org.apache.shardingsphere.data.pipeline.core.metadata.model.PipelineColumnMetaData;
import org.apache.shardingsphere.data.pipeline.core.metadata.model.PipelineIndexMetaData;
import org.apache.shardingsphere.data.pipeline.core.metadata.model.PipelineTableMetaData;
import org.apache.shardingsphere.data.pipeline.core.sqlbuilder.PipelineSQLBuilderFactory;
import org.apache.shardingsphere.data.pipeline.core.task.InventoryTask;
import org.apache.shardingsphere.data.pipeline.core.util.PipelineJdbcUtils;
import org.apache.shardingsphere.data.pipeline.scenario.rulealtered.RuleAlteredContext;
import org.apache.shardingsphere.data.pipeline.scenario.rulealtered.RuleAlteredJobContext;
import org.apache.shardingsphere.data.pipeline.spi.ingest.channel.PipelineChannelCreator;
import org.apache.shardingsphere.data.pipeline.spi.ratelimit.JobRateLimitAlgorithm;
import org.apache.shardingsphere.infra.config.rulealtered.OnRuleAlteredActionConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InventoryTaskSplitter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InventoryTaskSplitter.class);

    public List<InventoryTask> splitInventoryData(RuleAlteredJobContext jobContext) {
        LinkedList<InventoryTask> result = new LinkedList<InventoryTask>();
        TaskConfiguration taskConfig = jobContext.getTaskConfig();
        PipelineChannelCreator pipelineChannelCreator = jobContext.getRuleAlteredContext().getPipelineChannelCreator();
        PipelineDataSourceManager dataSourceManager = jobContext.getDataSourceManager();
        PipelineDataSourceWrapper dataSource = jobContext.getSourceDataSource();
        PipelineTableMetaDataLoader metaDataLoader = jobContext.getSourceMetaDataLoader();
        ExecuteEngine importerExecuteEngine = jobContext.getRuleAlteredContext().getImporterExecuteEngine();
        for (InventoryDumperConfiguration each : this.splitDumperConfig(jobContext, taskConfig.getDumperConfig())) {
            result.add(new InventoryTask(each, taskConfig.getImporterConfig(), pipelineChannelCreator, dataSourceManager, (DataSource)dataSource, metaDataLoader, importerExecuteEngine));
        }
        return result;
    }

    private Collection<InventoryDumperConfiguration> splitDumperConfig(RuleAlteredJobContext jobContext, DumperConfiguration dumperConfig) {
        LinkedList<InventoryDumperConfiguration> result = new LinkedList<InventoryDumperConfiguration>();
        PipelineDataSourceWrapper dataSource = jobContext.getSourceDataSource();
        PipelineTableMetaDataLoader metaDataLoader = jobContext.getSourceMetaDataLoader();
        for (InventoryDumperConfiguration each : this.splitByTable(dumperConfig)) {
            result.addAll(this.splitByPrimaryKey(jobContext, (DataSource)dataSource, metaDataLoader, each));
        }
        return result;
    }

    private Collection<InventoryDumperConfiguration> splitByTable(DumperConfiguration dumperConfig) {
        LinkedList<InventoryDumperConfiguration> result = new LinkedList<InventoryDumperConfiguration>();
        dumperConfig.getTableNameMap().forEach((key, value) -> {
            InventoryDumperConfiguration inventoryDumperConfig = new InventoryDumperConfiguration(dumperConfig);
            inventoryDumperConfig.setActualTableName(key.getLowercase());
            inventoryDumperConfig.setLogicTableName(value.getLowercase());
            inventoryDumperConfig.setPosition((IngestPosition)new PlaceholderPosition());
            result.add(inventoryDumperConfig);
        });
        return result;
    }

    private Collection<InventoryDumperConfiguration> splitByPrimaryKey(RuleAlteredJobContext jobContext, DataSource dataSource, PipelineTableMetaDataLoader metaDataLoader, InventoryDumperConfiguration dumperConfig) {
        LinkedList<InventoryDumperConfiguration> result = new LinkedList<InventoryDumperConfiguration>();
        RuleAlteredContext ruleAlteredContext = jobContext.getRuleAlteredContext();
        OnRuleAlteredActionConfiguration.InputConfiguration inputConfig = ruleAlteredContext.getOnRuleAlteredActionConfig().getInput();
        int batchSize = inputConfig.getBatchSize();
        JobRateLimitAlgorithm rateLimitAlgorithm = ruleAlteredContext.getInputRateLimitAlgorithm();
        Collection<IngestPosition<?>> inventoryPositions = this.getInventoryPositions(jobContext, dumperConfig, dataSource, metaDataLoader);
        int i = 0;
        for (IngestPosition<?> inventoryPosition : inventoryPositions) {
            InventoryDumperConfiguration splitDumperConfig = new InventoryDumperConfiguration((DumperConfiguration)dumperConfig);
            splitDumperConfig.setPosition(inventoryPosition);
            splitDumperConfig.setShardingItem(Integer.valueOf(i++));
            splitDumperConfig.setActualTableName(dumperConfig.getActualTableName());
            splitDumperConfig.setLogicTableName(dumperConfig.getLogicTableName());
            splitDumperConfig.setUniqueKey(dumperConfig.getUniqueKey());
            splitDumperConfig.setUniqueKeyDataType(dumperConfig.getUniqueKeyDataType());
            splitDumperConfig.setBatchSize(batchSize);
            splitDumperConfig.setRateLimitAlgorithm(rateLimitAlgorithm);
            result.add(splitDumperConfig);
        }
        return result;
    }

    private Collection<IngestPosition<?>> getInventoryPositions(RuleAlteredJobContext jobContext, InventoryDumperConfiguration dumperConfig, DataSource dataSource, PipelineTableMetaDataLoader metaDataLoader) {
        JobProgress initProgress = jobContext.getInitProgress();
        String schemaName = dumperConfig.getSchemaName(new LogicTableName(dumperConfig.getLogicTableName()));
        String actualTableName = dumperConfig.getActualTableName();
        PipelineTableMetaData tableMetaData = metaDataLoader.getTableMetaData(schemaName, actualTableName);
        PipelineColumnMetaData uniqueKeyColumn = this.mustGetAnAppropriateUniqueKeyColumn(tableMetaData, actualTableName);
        if (null != initProgress && initProgress.getStatus() != JobStatus.PREPARING_FAILURE) {
            Collection<IngestPosition<?>> result = initProgress.getInventoryPosition(dumperConfig.getActualTableName()).values();
            for (IngestPosition ingestPosition : result) {
                if (!(ingestPosition instanceof PrimaryKeyPosition)) continue;
                dumperConfig.setUniqueKey(uniqueKeyColumn.getName());
                dumperConfig.setUniqueKeyDataType(Integer.valueOf(uniqueKeyColumn.getDataType()));
                break;
            }
            return result;
        }
        dumperConfig.setUniqueKey(uniqueKeyColumn.getName());
        int uniqueKeyDataType = uniqueKeyColumn.getDataType();
        dumperConfig.setUniqueKeyDataType(Integer.valueOf(uniqueKeyDataType));
        if (PipelineJdbcUtils.isIntegerColumn(uniqueKeyDataType)) {
            return this.getPositionByIntegerPrimaryKeyRange(jobContext, dataSource, dumperConfig);
        }
        if (PipelineJdbcUtils.isStringColumn(uniqueKeyDataType)) {
            return this.getPositionByStringPrimaryKeyRange();
        }
        throw new PipelineJobCreationException(String.format("Can not split range for table %s, reason: primary key is not integer or string type", actualTableName));
    }

    private PipelineColumnMetaData mustGetAnAppropriateUniqueKeyColumn(PipelineTableMetaData tableMetaData, String tableName) {
        PipelineColumnMetaData column;
        if (null == tableMetaData) {
            throw new PipelineJobCreationException(String.format("Can not split range for table %s, reason: can not get table metadata ", tableName));
        }
        List<String> primaryKeys = tableMetaData.getPrimaryKeyColumns();
        if (primaryKeys.size() > 1) {
            throw new PipelineJobCreationException(String.format("Can not split range for table %s, reason: primary key is union primary", tableName));
        }
        if (1 == primaryKeys.size()) {
            return tableMetaData.getColumnMetaData(tableMetaData.getPrimaryKeyColumns().get(0));
        }
        Collection<PipelineIndexMetaData> uniqueIndexes = tableMetaData.getUniqueIndexes();
        if (uniqueIndexes.isEmpty()) {
            throw new PipelineJobCreationException(String.format("Can not split range for table %s, reason: no primary key or unique index", tableName));
        }
        if (1 == uniqueIndexes.size() && 1 == uniqueIndexes.iterator().next().getColumns().size() && !(column = uniqueIndexes.iterator().next().getColumns().get(0)).isNullable()) {
            return column;
        }
        throw new PipelineJobCreationException(String.format("Can not split range for table %s, reason: table contains multiple unique index or unique index contains nullable/multiple column(s)", tableName));
    }

    private Collection<IngestPosition<?>> getPositionByIntegerPrimaryKeyRange(RuleAlteredJobContext jobContext, DataSource dataSource, InventoryDumperConfiguration dumperConfig) {
        LinkedList result = new LinkedList();
        RuleAlteredJobConfiguration jobConfig = jobContext.getJobConfig();
        String sql = PipelineSQLBuilderFactory.getInstance(jobConfig.getSourceDatabaseType()).buildSplitByPrimaryKeyRangeSQL(dumperConfig.getSchemaName(new LogicTableName(dumperConfig.getLogicTableName())), dumperConfig.getActualTableName(), dumperConfig.getUniqueKey());
        int shardingSize = jobContext.getRuleAlteredContext().getOnRuleAlteredActionConfig().getInput().getShardingSize();
        try (Connection connection = dataSource.getConnection();
             PreparedStatement ps = connection.prepareStatement(sql);){
            long beginId = 0L;
            for (int i = 0; i < Integer.MAX_VALUE; ++i) {
                ps.setLong(1, beginId);
                ps.setLong(2, shardingSize);
                try (ResultSet rs = ps.executeQuery();){
                    if (!rs.next()) {
                        log.info("getPositionByPrimaryKeyRange, rs.next false, break");
                        break;
                    }
                    long endId = rs.getLong(1);
                    if (endId == 0L) {
                        log.info("getPositionByPrimaryKeyRange, endId is 0, break, tableName={}, primaryKey={}, beginId={}", new Object[]{dumperConfig.getActualTableName(), dumperConfig.getUniqueKey(), beginId});
                        break;
                    }
                    result.add((IngestPosition<?>)new IntegerPrimaryKeyPosition(beginId, endId));
                    beginId = endId + 1L;
                    continue;
                }
            }
            if (0 == result.size()) {
                result.add((IngestPosition<?>)new IntegerPrimaryKeyPosition(0L, 0L));
            }
        }
        catch (SQLException ex) {
            throw new PipelineJobPrepareFailedException(String.format("Split task for table %s by primary key %s error", dumperConfig.getActualTableName(), dumperConfig.getUniqueKey()), ex);
        }
        return result;
    }

    private Collection<IngestPosition<?>> getPositionByStringPrimaryKeyRange() {
        LinkedList result = new LinkedList();
        result.add((IngestPosition<?>)new StringPrimaryKeyPosition("!", "~"));
        return result;
    }
}

