/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.scenario.rulealtered;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.job.JobStatus;
import org.apache.shardingsphere.data.pipeline.core.api.GovernanceRepositoryAPI;
import org.apache.shardingsphere.data.pipeline.core.api.PipelineAPIFactory;
import org.apache.shardingsphere.data.pipeline.scenario.rulealtered.RuleAlteredJobContext;
import org.apache.shardingsphere.data.pipeline.scenario.rulealtered.RuleAlteredJobScheduler;
import org.apache.shardingsphere.infra.executor.kernel.thread.ExecutorThreadFactoryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RuleAlteredJobSchedulerCenter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RuleAlteredJobSchedulerCenter.class);
    private static final Map<String, Map<Integer, RuleAlteredJobScheduler>> JOB_SCHEDULER_MAP = new ConcurrentHashMap<String, Map<Integer, RuleAlteredJobScheduler>>();
    private static final ScheduledExecutorService JOB_PERSIST_EXECUTOR = Executors.newSingleThreadScheduledExecutor(ExecutorThreadFactoryBuilder.build((String)"scaling-job-persist-%d"));

    public static void start(RuleAlteredJobContext jobContext) {
        int shardingItem;
        String jobId = jobContext.getJobId();
        Map schedulerMap = JOB_SCHEDULER_MAP.computeIfAbsent(jobId, key -> new ConcurrentHashMap());
        if (schedulerMap.containsKey(shardingItem = jobContext.getShardingItem())) {
            log.warn("schedulerMap contains shardingItem {}, ignore", (Object)shardingItem);
            return;
        }
        log.info("start RuleAlteredJobScheduler, jobId={}, shardingItem={}", (Object)jobId, (Object)shardingItem);
        RuleAlteredJobScheduler jobScheduler = new RuleAlteredJobScheduler(jobContext);
        jobScheduler.start();
        schedulerMap.put(shardingItem, jobScheduler);
    }

    static void stop(String jobId) {
        log.info("remove and stop {}", (Object)jobId);
        Map<Integer, RuleAlteredJobScheduler> schedulerMap = JOB_SCHEDULER_MAP.get(jobId);
        if (null == schedulerMap) {
            log.info("schedulerMap is null, ignore");
            return;
        }
        for (Map.Entry<Integer, RuleAlteredJobScheduler> entry : schedulerMap.entrySet()) {
            entry.getValue().stop();
        }
        JOB_SCHEDULER_MAP.remove(jobId);
    }

    public static boolean existJob(String jobId) {
        return JOB_SCHEDULER_MAP.containsKey(jobId);
    }

    public static void updateJobStatus(String jobId, JobStatus jobStatus) {
        Map<Integer, RuleAlteredJobScheduler> schedulerMap = JOB_SCHEDULER_MAP.get(jobId);
        if (null == schedulerMap) {
            log.info("updateJobStatus, schedulerMap is null, ignore");
            return;
        }
        for (Map.Entry<Integer, RuleAlteredJobScheduler> entry : schedulerMap.entrySet()) {
            entry.getValue().getJobContext().setStatus(jobStatus);
        }
    }

    @Generated
    private RuleAlteredJobSchedulerCenter() {
    }

    static {
        JOB_PERSIST_EXECUTOR.scheduleWithFixedDelay(new PersistJobContextRunnable(), 10L, 10L, TimeUnit.SECONDS);
    }

    private static final class PersistJobContextRunnable
    implements Runnable {
        private PersistJobContextRunnable() {
        }

        @Override
        public void run() {
            GovernanceRepositoryAPI repositoryAPI = PipelineAPIFactory.getGovernanceRepositoryAPI();
            for (Map.Entry entry : JOB_SCHEDULER_MAP.entrySet()) {
                try {
                    ((Map)entry.getValue()).forEach((shardingItem, jobScheduler) -> repositoryAPI.persistJobProgress(jobScheduler.getJobContext()));
                }
                catch (Exception ex) {
                    log.error("persist job {} context failed.", entry.getKey(), (Object)ex);
                }
            }
        }
    }
}

