/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.scenario.rulealtered;

import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.config.TableNameSchemaNameMapping;
import org.apache.shardingsphere.data.pipeline.api.config.rulealtered.ImporterConfiguration;
import org.apache.shardingsphere.data.pipeline.api.config.rulealtered.RuleAlteredJobConfiguration;
import org.apache.shardingsphere.data.pipeline.api.config.rulealtered.TaskConfiguration;
import org.apache.shardingsphere.data.pipeline.api.datasource.PipelineDataSourceWrapper;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.PipelineDataSourceConfigurationFactory;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.impl.ShardingSpherePipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.api.ingest.position.IngestPosition;
import org.apache.shardingsphere.data.pipeline.api.job.JobStatus;
import org.apache.shardingsphere.data.pipeline.api.job.progress.JobProgress;
import org.apache.shardingsphere.data.pipeline.core.context.PipelineContext;
import org.apache.shardingsphere.data.pipeline.core.datasource.PipelineDataSourceManager;
import org.apache.shardingsphere.data.pipeline.core.exception.PipelineJobPrepareFailedException;
import org.apache.shardingsphere.data.pipeline.core.execute.ExecuteEngine;
import org.apache.shardingsphere.data.pipeline.core.ingest.position.PositionInitializerFactory;
import org.apache.shardingsphere.data.pipeline.core.metadata.loader.PipelineTableMetaDataLoader;
import org.apache.shardingsphere.data.pipeline.core.prepare.datasource.DataSourcePreparer;
import org.apache.shardingsphere.data.pipeline.core.prepare.datasource.PrepareTargetSchemasParameter;
import org.apache.shardingsphere.data.pipeline.core.prepare.datasource.PrepareTargetTablesParameter;
import org.apache.shardingsphere.data.pipeline.core.task.IncrementalTask;
import org.apache.shardingsphere.data.pipeline.core.task.InventoryTask;
import org.apache.shardingsphere.data.pipeline.core.util.ThreadUtil;
import org.apache.shardingsphere.data.pipeline.scenario.rulealtered.RuleAlteredJobContext;
import org.apache.shardingsphere.data.pipeline.scenario.rulealtered.prepare.InventoryTaskSplitter;
import org.apache.shardingsphere.data.pipeline.spi.check.datasource.DataSourceChecker;
import org.apache.shardingsphere.data.pipeline.spi.check.datasource.DataSourceCheckerFactory;
import org.apache.shardingsphere.data.pipeline.spi.ingest.channel.PipelineChannelCreator;
import org.apache.shardingsphere.data.pipeline.spi.ingest.position.PositionInitializer;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeFactory;
import org.apache.shardingsphere.infra.datasource.pool.creator.DataSourcePoolCreator;
import org.apache.shardingsphere.infra.datasource.props.DataSourceProperties;
import org.apache.shardingsphere.infra.lock.ShardingSphereLock;
import org.apache.shardingsphere.infra.yaml.config.swapper.YamlDataSourceConfigurationSwapper;
import org.apache.shardingsphere.scaling.core.job.check.EnvironmentCheckerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RuleAlteredJobPreparer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RuleAlteredJobPreparer.class);
    private final InventoryTaskSplitter inventoryTaskSplitter = new InventoryTaskSplitter();

    public void prepare(RuleAlteredJobContext jobContext) {
        this.checkSourceDataSource(jobContext);
        if (jobContext.isStopping()) {
            throw new PipelineJobPrepareFailedException("Job stopping, jobId=" + jobContext.getJobId());
        }
        this.prepareAndCheckTargetWithLock(jobContext);
        if (jobContext.isStopping()) {
            throw new PipelineJobPrepareFailedException("Job stopping, jobId=" + jobContext.getJobId());
        }
        try {
            this.initIncrementalTasks(jobContext);
            if (jobContext.isStopping()) {
                throw new PipelineJobPrepareFailedException("Job stopping, jobId=" + jobContext.getJobId());
            }
            this.initInventoryTasks(jobContext);
            log.info("prepare, jobId={}, shardingItem={}, inventoryTasks={}, incrementalTasks={}", new Object[]{jobContext.getJobId(), jobContext.getShardingItem(), jobContext.getInventoryTasks(), jobContext.getIncrementalTasks()});
        }
        catch (SQLException ex) {
            log.error("Scaling job preparing failed, jobId={}", (Object)jobContext.getJobId());
            throw new PipelineJobPrepareFailedException("Scaling job preparing failed, jobId=" + jobContext.getJobId(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareAndCheckTargetWithLock(RuleAlteredJobContext jobContext) {
        RuleAlteredJobConfiguration jobConfig = jobContext.getJobConfig();
        String lockName = "prepare-" + jobConfig.getJobId();
        ShardingSphereLock lock = PipelineContext.getContextManager().getInstanceContext().getLockContext().getLock();
        if (lock.tryLock(lockName, 3000L)) {
            try {
                this.prepareAndCheckTarget(jobContext);
            }
            finally {
                lock.releaseLock(lockName);
            }
        } else {
            this.waitUntilLockReleased(lock, lockName);
        }
    }

    private void waitUntilLockReleased(ShardingSphereLock lock, String lockName) {
        for (int loopCount = 0; loopCount < 30; ++loopCount) {
            ThreadUtil.sleep(TimeUnit.SECONDS.toMillis(5L));
            if (lock.isLocked(lockName)) continue;
            log.info("unlocked, lockName={}", (Object)lockName);
            return;
        }
    }

    private void prepareAndCheckTarget(RuleAlteredJobContext jobContext) {
        this.prepareTarget(jobContext);
        JobProgress initProgress = jobContext.getInitProgress();
        if (null == initProgress || initProgress.getStatus() == JobStatus.PREPARING_FAILURE) {
            PipelineDataSourceWrapper targetDataSource = jobContext.getDataSourceManager().getDataSource(jobContext.getTaskConfig().getImporterConfig().getDataSourceConfig());
            this.checkTargetDataSource(jobContext, targetDataSource);
        }
    }

    private void prepareTarget(RuleAlteredJobContext jobContext) {
        RuleAlteredJobConfiguration jobConfig = jobContext.getJobConfig();
        Optional<DataSourcePreparer> dataSourcePreparer = EnvironmentCheckerFactory.getDataSourcePreparer(jobConfig.getTargetDatabaseType());
        if (!dataSourcePreparer.isPresent()) {
            log.info("dataSourcePreparer null, ignore prepare target");
            return;
        }
        TableNameSchemaNameMapping tableNameSchemaNameMapping = jobContext.getTaskConfig().getDumperConfig().getTableNameSchemaNameMapping();
        PrepareTargetSchemasParameter prepareTargetSchemasParameter = new PrepareTargetSchemasParameter(jobContext.getTaskConfig(), jobContext.getDataSourceManager(), tableNameSchemaNameMapping);
        dataSourcePreparer.get().prepareTargetSchemas(prepareTargetSchemasParameter);
        PrepareTargetTablesParameter prepareTargetTablesParameter = new PrepareTargetTablesParameter(jobContext.getTaskConfig(), jobContext.getDataSourceManager(), tableNameSchemaNameMapping);
        dataSourcePreparer.get().prepareTargetTables(prepareTargetTablesParameter);
    }

    private void checkSourceDataSource(RuleAlteredJobContext jobContext) {
        DataSourceChecker dataSourceChecker = DataSourceCheckerFactory.getInstance((String)jobContext.getJobConfig().getSourceDatabaseType());
        Set<PipelineDataSourceWrapper> sourceDataSources = Collections.singleton(jobContext.getSourceDataSource());
        dataSourceChecker.checkConnection(sourceDataSources);
        dataSourceChecker.checkPrivilege(sourceDataSources);
        dataSourceChecker.checkVariable(sourceDataSources);
    }

    private void checkTargetDataSource(RuleAlteredJobContext jobContext, PipelineDataSourceWrapper targetDataSource) {
        DataSourceChecker dataSourceChecker = DataSourceCheckerFactory.getInstance((String)jobContext.getJobConfig().getTargetDatabaseType());
        List<PipelineDataSourceWrapper> targetDataSources = Collections.singletonList(targetDataSource);
        dataSourceChecker.checkConnection(targetDataSources);
        ImporterConfiguration importerConfig = jobContext.getTaskConfig().getImporterConfig();
        dataSourceChecker.checkTargetTable(targetDataSources, importerConfig.getTableNameSchemaNameMapping(), importerConfig.getLogicTableNames());
    }

    private void initInventoryTasks(RuleAlteredJobContext jobContext) {
        List<InventoryTask> allInventoryTasks = this.inventoryTaskSplitter.splitInventoryData(jobContext);
        jobContext.getInventoryTasks().addAll(allInventoryTasks);
    }

    private void initIncrementalTasks(RuleAlteredJobContext jobContext) throws SQLException {
        PipelineChannelCreator pipelineChannelCreator = jobContext.getRuleAlteredContext().getPipelineChannelCreator();
        ExecuteEngine incrementalDumperExecuteEngine = jobContext.getRuleAlteredContext().getIncrementalDumperExecuteEngine();
        TaskConfiguration taskConfig = jobContext.getTaskConfig();
        PipelineDataSourceManager dataSourceManager = jobContext.getDataSourceManager();
        taskConfig.getDumperConfig().setPosition(this.getIncrementalPosition(jobContext, taskConfig, dataSourceManager));
        PipelineTableMetaDataLoader sourceMetaDataLoader = jobContext.getSourceMetaDataLoader();
        IncrementalTask incrementalTask = new IncrementalTask(taskConfig.getJobConfig().getConcurrency(), taskConfig.getDumperConfig(), taskConfig.getImporterConfig(), pipelineChannelCreator, dataSourceManager, sourceMetaDataLoader, incrementalDumperExecuteEngine);
        jobContext.getIncrementalTasks().add(incrementalTask);
    }

    private IngestPosition<?> getIncrementalPosition(RuleAlteredJobContext jobContext, TaskConfiguration taskConfig, PipelineDataSourceManager dataSourceManager) throws SQLException {
        Optional position;
        if (null != jobContext.getInitProgress() && (position = jobContext.getInitProgress().getIncrementalPosition(taskConfig.getDumperConfig().getDataSourceName())).isPresent()) {
            return (IngestPosition)position.get();
        }
        String databaseType = taskConfig.getJobConfig().getSourceDatabaseType();
        PipelineDataSourceWrapper dataSource = dataSourceManager.getDataSource(taskConfig.getDumperConfig().getDataSourceConfig());
        return PositionInitializerFactory.getInstance(databaseType).init((DataSource)dataSource);
    }

    public void cleanup(RuleAlteredJobConfiguration jobConfig) {
        try {
            this.cleanup0(jobConfig);
        }
        catch (SQLException ex) {
            log.warn("Scaling job destroying failed", (Throwable)ex);
        }
    }

    private void cleanup0(RuleAlteredJobConfiguration jobConfig) throws SQLException {
        DatabaseType databaseType = DatabaseTypeFactory.getInstance((String)jobConfig.getSourceDatabaseType());
        PositionInitializer positionInitializer = PositionInitializerFactory.getInstance(databaseType.getType());
        ShardingSpherePipelineDataSourceConfiguration sourceDataSourceConfig = (ShardingSpherePipelineDataSourceConfiguration)PipelineDataSourceConfigurationFactory.newInstance((String)jobConfig.getSource().getType(), (String)jobConfig.getSource().getParameter());
        for (DataSourceProperties each : new YamlDataSourceConfigurationSwapper().getDataSourcePropertiesMap(sourceDataSourceConfig.getRootConfig()).values()) {
            try (PipelineDataSourceWrapper dataSource = new PipelineDataSourceWrapper(DataSourcePoolCreator.create((DataSourceProperties)each), databaseType);){
                positionInitializer.destroy((DataSource)dataSource);
            }
        }
    }
}

