/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.scenario.rulealtered;

import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.config.rulealtered.RuleAlteredJobConfiguration;
import org.apache.shardingsphere.data.pipeline.api.config.rulealtered.yaml.RuleAlteredJobConfigurationSwapper;
import org.apache.shardingsphere.data.pipeline.api.job.progress.JobProgress;
import org.apache.shardingsphere.data.pipeline.core.api.GovernanceRepositoryAPI;
import org.apache.shardingsphere.data.pipeline.core.api.PipelineAPIFactory;
import org.apache.shardingsphere.data.pipeline.core.datasource.PipelineDataSourceManager;
import org.apache.shardingsphere.data.pipeline.scenario.rulealtered.RuleAlteredJobContext;
import org.apache.shardingsphere.data.pipeline.scenario.rulealtered.RuleAlteredJobPreparer;
import org.apache.shardingsphere.data.pipeline.scenario.rulealtered.RuleAlteredJobSchedulerCenter;
import org.apache.shardingsphere.elasticjob.api.ShardingContext;
import org.apache.shardingsphere.elasticjob.simple.job.SimpleJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RuleAlteredJob
implements SimpleJob {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RuleAlteredJob.class);
    private final GovernanceRepositoryAPI governanceRepositoryAPI = PipelineAPIFactory.getGovernanceRepositoryAPI();
    private volatile String jobId;
    private final PipelineDataSourceManager dataSourceManager = new PipelineDataSourceManager();
    private final RuleAlteredJobPreparer jobPreparer = new RuleAlteredJobPreparer();
    private volatile boolean stopping;

    public void execute(ShardingContext shardingContext) {
        log.info("Execute job {}-{}", (Object)shardingContext.getJobName(), (Object)shardingContext.getShardingItem());
        if (this.stopping) {
            log.info("stopping true, ignore");
            return;
        }
        this.jobId = shardingContext.getJobName();
        RuleAlteredJobConfiguration jobConfig = RuleAlteredJobConfigurationSwapper.swapToObject((String)shardingContext.getJobParameter());
        JobProgress initProgress = this.governanceRepositoryAPI.getJobProgress(shardingContext.getJobName(), shardingContext.getShardingItem());
        RuleAlteredJobContext jobContext = new RuleAlteredJobContext(jobConfig, shardingContext.getShardingItem(), initProgress, this.dataSourceManager, this.jobPreparer);
        RuleAlteredJobSchedulerCenter.start(jobContext);
    }

    public void stop() {
        this.stopping = true;
        this.dataSourceManager.close();
        if (null == this.jobId) {
            log.info("stop, jobId is null, ignore");
            return;
        }
        log.info("stop, jobId={}", (Object)this.jobId);
        RuleAlteredJobSchedulerCenter.stop(this.jobId);
    }
}

