/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.scenario.rulealtered;

import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.detect.RuleAlteredJobAlmostCompletedParameter;
import org.apache.shardingsphere.data.pipeline.core.check.consistency.DataConsistencyCalculateAlgorithmFactory;
import org.apache.shardingsphere.data.pipeline.core.execute.ExecuteEngine;
import org.apache.shardingsphere.data.pipeline.spi.check.consistency.DataConsistencyCalculateAlgorithm;
import org.apache.shardingsphere.data.pipeline.spi.detect.JobCompletionDetectAlgorithm;
import org.apache.shardingsphere.data.pipeline.spi.detect.JobCompletionDetectAlgorithmFactory;
import org.apache.shardingsphere.data.pipeline.spi.ingest.channel.PipelineChannelCreator;
import org.apache.shardingsphere.data.pipeline.spi.ingest.channel.PipelineChannelCreatorFactory;
import org.apache.shardingsphere.data.pipeline.spi.lock.RowBasedJobLock;
import org.apache.shardingsphere.data.pipeline.spi.lock.RowBasedJobLockFactory;
import org.apache.shardingsphere.data.pipeline.spi.lock.RuleBasedJobLock;
import org.apache.shardingsphere.data.pipeline.spi.lock.RuleBasedJobLockFactory;
import org.apache.shardingsphere.data.pipeline.spi.ratelimit.JobRateLimitAlgorithm;
import org.apache.shardingsphere.data.pipeline.spi.ratelimit.JobRateLimitAlgorithmFactory;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithmConfiguration;
import org.apache.shardingsphere.infra.config.rulealtered.OnRuleAlteredActionConfiguration;
import org.apache.shardingsphere.infra.yaml.config.pojo.algorithm.YamlShardingSphereAlgorithmConfiguration;
import org.apache.shardingsphere.infra.yaml.config.pojo.rulealtered.YamlOnRuleAlteredActionConfiguration;
import org.apache.shardingsphere.infra.yaml.config.swapper.rulealtered.OnRuleAlteredActionConfigurationYamlSwapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RuleAlteredContext {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RuleAlteredContext.class);
    private static final String INVENTORY_THREAD_PREFIX = "Inventory-";
    private static final String INCREMENTAL_THREAD_PREFIX = "Incremental-";
    private static final String IMPORTER_THREAD_PREFIX = "Importer-";
    private static final OnRuleAlteredActionConfigurationYamlSwapper SWAPPER = new OnRuleAlteredActionConfigurationYamlSwapper();
    private final OnRuleAlteredActionConfiguration onRuleAlteredActionConfig;
    private final JobRateLimitAlgorithm inputRateLimitAlgorithm;
    private final JobRateLimitAlgorithm outputRateLimitAlgorithm;
    private final PipelineChannelCreator pipelineChannelCreator;
    private final JobCompletionDetectAlgorithm<RuleAlteredJobAlmostCompletedParameter> completionDetectAlgorithm;
    private final DataConsistencyCalculateAlgorithm dataConsistencyCalculateAlgorithm;
    private final RowBasedJobLock rowBasedJobLock;
    private final RuleBasedJobLock ruleBasedJobLock;
    private final ExecuteEngine inventoryDumperExecuteEngine;
    private final ExecuteEngine incrementalDumperExecuteEngine;
    private final ExecuteEngine importerExecuteEngine;

    public RuleAlteredContext(String jobId, OnRuleAlteredActionConfiguration actionConfig) {
        OnRuleAlteredActionConfiguration onRuleAlteredActionConfig;
        this.onRuleAlteredActionConfig = onRuleAlteredActionConfig = this.convertActionConfig(actionConfig);
        OnRuleAlteredActionConfiguration.InputConfiguration inputConfig = onRuleAlteredActionConfig.getInput();
        ShardingSphereAlgorithmConfiguration inputRateLimiter = inputConfig.getRateLimiter();
        this.inputRateLimitAlgorithm = null != inputRateLimiter ? JobRateLimitAlgorithmFactory.newInstance((ShardingSphereAlgorithmConfiguration)inputRateLimiter) : null;
        OnRuleAlteredActionConfiguration.OutputConfiguration outputConfig = onRuleAlteredActionConfig.getOutput();
        ShardingSphereAlgorithmConfiguration outputRateLimiter = outputConfig.getRateLimiter();
        this.outputRateLimitAlgorithm = null != outputRateLimiter ? JobRateLimitAlgorithmFactory.newInstance((ShardingSphereAlgorithmConfiguration)outputRateLimiter) : null;
        ShardingSphereAlgorithmConfiguration streamChannel = onRuleAlteredActionConfig.getStreamChannel();
        this.pipelineChannelCreator = PipelineChannelCreatorFactory.newInstance((ShardingSphereAlgorithmConfiguration)streamChannel);
        ShardingSphereAlgorithmConfiguration completionDetector = onRuleAlteredActionConfig.getCompletionDetector();
        this.completionDetectAlgorithm = null != completionDetector ? JobCompletionDetectAlgorithmFactory.newInstance((ShardingSphereAlgorithmConfiguration)completionDetector) : null;
        ShardingSphereAlgorithmConfiguration dataConsistencyCheckerConfig = onRuleAlteredActionConfig.getDataConsistencyCalculator();
        this.dataConsistencyCalculateAlgorithm = null != dataConsistencyCheckerConfig ? DataConsistencyCalculateAlgorithmFactory.newInstance(dataConsistencyCheckerConfig.getType(), dataConsistencyCheckerConfig.getProps()) : null;
        this.rowBasedJobLock = RowBasedJobLockFactory.getInstance();
        this.ruleBasedJobLock = RuleBasedJobLockFactory.getInstance();
        this.inventoryDumperExecuteEngine = ExecuteEngine.newFixedThreadInstance(inputConfig.getWorkerThread(), INVENTORY_THREAD_PREFIX + jobId);
        this.incrementalDumperExecuteEngine = ExecuteEngine.newCachedThreadInstance(INCREMENTAL_THREAD_PREFIX + jobId);
        this.importerExecuteEngine = ExecuteEngine.newFixedThreadInstance(outputConfig.getWorkerThread(), IMPORTER_THREAD_PREFIX + jobId);
    }

    private OnRuleAlteredActionConfiguration convertActionConfig(OnRuleAlteredActionConfiguration actionConfig) {
        YamlOnRuleAlteredActionConfiguration yamlActionConfig = SWAPPER.swapToYamlConfiguration(actionConfig);
        if (null == yamlActionConfig.getInput()) {
            yamlActionConfig.setInput(YamlOnRuleAlteredActionConfiguration.YamlInputConfiguration.buildWithDefaultValue());
        } else {
            yamlActionConfig.getInput().fillInNullFieldsWithDefaultValue();
        }
        if (null == yamlActionConfig.getOutput()) {
            yamlActionConfig.setOutput(YamlOnRuleAlteredActionConfiguration.YamlOutputConfiguration.buildWithDefaultValue());
        } else {
            yamlActionConfig.getOutput().fillInNullFieldsWithDefaultValue();
        }
        if (null == yamlActionConfig.getStreamChannel()) {
            yamlActionConfig.setStreamChannel(new YamlShardingSphereAlgorithmConfiguration("MEMORY", new Properties()));
        }
        return SWAPPER.swapToObject(yamlActionConfig);
    }

    @Generated
    public OnRuleAlteredActionConfiguration getOnRuleAlteredActionConfig() {
        return this.onRuleAlteredActionConfig;
    }

    @Generated
    public JobRateLimitAlgorithm getInputRateLimitAlgorithm() {
        return this.inputRateLimitAlgorithm;
    }

    @Generated
    public JobRateLimitAlgorithm getOutputRateLimitAlgorithm() {
        return this.outputRateLimitAlgorithm;
    }

    @Generated
    public PipelineChannelCreator getPipelineChannelCreator() {
        return this.pipelineChannelCreator;
    }

    @Generated
    public JobCompletionDetectAlgorithm<RuleAlteredJobAlmostCompletedParameter> getCompletionDetectAlgorithm() {
        return this.completionDetectAlgorithm;
    }

    @Generated
    public DataConsistencyCalculateAlgorithm getDataConsistencyCalculateAlgorithm() {
        return this.dataConsistencyCalculateAlgorithm;
    }

    @Generated
    public RowBasedJobLock getRowBasedJobLock() {
        return this.rowBasedJobLock;
    }

    @Generated
    public RuleBasedJobLock getRuleBasedJobLock() {
        return this.ruleBasedJobLock;
    }

    @Generated
    public ExecuteEngine getInventoryDumperExecuteEngine() {
        return this.inventoryDumperExecuteEngine;
    }

    @Generated
    public ExecuteEngine getIncrementalDumperExecuteEngine() {
        return this.incrementalDumperExecuteEngine;
    }

    @Generated
    public ExecuteEngine getImporterExecuteEngine() {
        return this.importerExecuteEngine;
    }
}

