/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.sqlbuilder;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import lombok.NonNull;
import org.apache.shardingsphere.data.pipeline.api.ingest.record.Column;
import org.apache.shardingsphere.data.pipeline.api.ingest.record.DataRecord;
import org.apache.shardingsphere.data.pipeline.api.metadata.LogicTableName;
import org.apache.shardingsphere.data.pipeline.core.record.RecordUtil;
import org.apache.shardingsphere.data.pipeline.core.util.PipelineJdbcUtils;
import org.apache.shardingsphere.data.pipeline.spi.sqlbuilder.PipelineSQLBuilder;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeFactory;

public abstract class AbstractPipelineSQLBuilder
implements PipelineSQLBuilder {
    private static final String INSERT_SQL_CACHE_KEY_PREFIX = "INSERT_";
    private static final String UPDATE_SQL_CACHE_KEY_PREFIX = "UPDATE_";
    private static final String DELETE_SQL_CACHE_KEY_PREFIX = "DELETE_";
    private final ConcurrentMap<String, String> sqlCacheMap = new ConcurrentHashMap<String, String>();

    protected abstract String getLeftIdentifierQuoteString();

    protected abstract String getRightIdentifierQuoteString();

    public String quote(String item) {
        return this.getLeftIdentifierQuoteString() + item + this.getRightIdentifierQuoteString();
    }

    public String buildInventoryDumpSQL(String schemaName, String tableName, String uniqueKey, int uniqueKeyDataType, boolean firstQuery) {
        String decoratedTableName = this.decorate(schemaName, tableName);
        String quotedUniqueKey = this.quote(uniqueKey);
        if (PipelineJdbcUtils.isIntegerColumn(uniqueKeyDataType)) {
            return "SELECT * FROM " + decoratedTableName + " WHERE " + quotedUniqueKey + " " + (firstQuery ? ">=" : ">") + " ? AND " + quotedUniqueKey + " <= ? ORDER BY " + quotedUniqueKey + " ASC LIMIT ?";
        }
        if (PipelineJdbcUtils.isStringColumn(uniqueKeyDataType)) {
            return "SELECT * FROM " + decoratedTableName + " WHERE " + quotedUniqueKey + " " + (firstQuery ? ">=" : ">") + " ? ORDER BY " + quotedUniqueKey + " ASC LIMIT ?";
        }
        throw new IllegalArgumentException("Unknown uniqueKeyDataType: " + uniqueKeyDataType);
    }

    protected String decorate(String schemaName, String tableName) {
        StringBuilder result = new StringBuilder();
        if (this.isSchemaAvailable() && !Strings.isNullOrEmpty((String)schemaName)) {
            result.append(this.quote(schemaName)).append(".");
        }
        result.append(this.quote(tableName));
        return result.toString();
    }

    private boolean isSchemaAvailable() {
        return DatabaseTypeFactory.getInstance((String)this.getType()).isSchemaAvailable();
    }

    public String buildInsertSQL(String schemaName, DataRecord dataRecord, Map<LogicTableName, Set<String>> shardingColumnsMap) {
        String sqlCacheKey = INSERT_SQL_CACHE_KEY_PREFIX + dataRecord.getTableName();
        if (!this.sqlCacheMap.containsKey(sqlCacheKey)) {
            this.sqlCacheMap.put(sqlCacheKey, this.buildInsertSQLInternal(schemaName, dataRecord.getTableName(), dataRecord.getColumns()));
        }
        return (String)this.sqlCacheMap.get(sqlCacheKey);
    }

    private String buildInsertSQLInternal(String schemaName, String tableName, List<Column> columns) {
        StringBuilder columnsLiteral = new StringBuilder();
        StringBuilder holder = new StringBuilder();
        for (Column each : columns) {
            columnsLiteral.append(String.format("%s,", this.quote(each.getName())));
            holder.append("?,");
        }
        columnsLiteral.setLength(columnsLiteral.length() - 1);
        holder.setLength(holder.length() - 1);
        return String.format("INSERT INTO %s(%s) VALUES(%s)", this.decorate(schemaName, tableName), columnsLiteral, holder);
    }

    protected final boolean isShardingColumn(Map<LogicTableName, Set<String>> shardingColumnsMap, String tableName, String columnName) {
        Set<String> shardingColumns = shardingColumnsMap.get(new LogicTableName(tableName));
        return null != shardingColumns && shardingColumns.contains(columnName);
    }

    public String buildUpdateSQL(String schemaName, DataRecord dataRecord, Collection<Column> conditionColumns, Map<LogicTableName, Set<String>> shardingColumnsMap) {
        String sqlCacheKey = UPDATE_SQL_CACHE_KEY_PREFIX + dataRecord.getTableName();
        if (!this.sqlCacheMap.containsKey(sqlCacheKey)) {
            this.sqlCacheMap.put(sqlCacheKey, this.buildUpdateSQLInternal(schemaName, dataRecord.getTableName(), conditionColumns));
        }
        StringBuilder updatedColumnString = new StringBuilder();
        for (Column each : this.extractUpdatedColumns(dataRecord, shardingColumnsMap)) {
            updatedColumnString.append(String.format("%s = ?,", this.quote(each.getName())));
        }
        updatedColumnString.setLength(updatedColumnString.length() - 1);
        return String.format((String)this.sqlCacheMap.get(sqlCacheKey), updatedColumnString);
    }

    private String buildUpdateSQLInternal(String schemaName, String tableName, Collection<Column> conditionColumns) {
        return String.format("UPDATE %s SET %%s WHERE %s", this.decorate(schemaName, tableName), this.buildWhereSQL(conditionColumns));
    }

    public List<Column> extractUpdatedColumns(DataRecord record, Map<LogicTableName, Set<String>> shardingColumnsMap) {
        return new ArrayList<Column>(RecordUtil.extractUpdatedColumns(record));
    }

    public String buildDeleteSQL(String schemaName, DataRecord dataRecord, Collection<Column> conditionColumns) {
        String sqlCacheKey = DELETE_SQL_CACHE_KEY_PREFIX + dataRecord.getTableName();
        if (!this.sqlCacheMap.containsKey(sqlCacheKey)) {
            this.sqlCacheMap.put(sqlCacheKey, this.buildDeleteSQLInternal(schemaName, dataRecord.getTableName(), conditionColumns));
        }
        return (String)this.sqlCacheMap.get(sqlCacheKey);
    }

    public String buildTruncateSQL(String schemaName, String tableName) {
        return String.format("TRUNCATE TABLE %s", this.decorate(schemaName, tableName));
    }

    private String buildDeleteSQLInternal(String schemaName, String tableName, Collection<Column> conditionColumns) {
        return String.format("DELETE FROM %s WHERE %s", this.decorate(schemaName, tableName), this.buildWhereSQL(conditionColumns));
    }

    private String buildWhereSQL(Collection<Column> conditionColumns) {
        StringBuilder where = new StringBuilder();
        for (Column each : conditionColumns) {
            where.append(String.format("%s = ? and ", this.quote(each.getName())));
        }
        where.setLength(where.length() - 5);
        return where.toString();
    }

    public String buildCountSQL(String schemaName, String tableName) {
        return String.format("SELECT COUNT(*) FROM %s", this.decorate(schemaName, tableName));
    }

    public String buildChunkedQuerySQL(@NonNull String schemaName, @NonNull String tableName, @NonNull String uniqueKey, boolean firstQuery) {
        if (schemaName == null) {
            throw new NullPointerException("schemaName is marked non-null but is null");
        }
        if (tableName == null) {
            throw new NullPointerException("tableName is marked non-null but is null");
        }
        if (uniqueKey == null) {
            throw new NullPointerException("uniqueKey is marked non-null but is null");
        }
        if (firstQuery) {
            return "SELECT * FROM " + this.decorate(schemaName, tableName) + " ORDER BY " + this.quote(uniqueKey) + " ASC LIMIT ?";
        }
        return "SELECT * FROM " + this.decorate(schemaName, tableName) + " WHERE " + this.quote(uniqueKey) + " > ? ORDER BY " + this.quote(uniqueKey) + " ASC LIMIT ?";
    }

    public String buildCheckEmptySQL(String schemaName, String tableName) {
        return String.format("SELECT * FROM %s LIMIT 1", this.decorate(schemaName, tableName));
    }

    public String buildSplitByPrimaryKeyRangeSQL(String schemaName, String tableName, String primaryKey) {
        String quotedKey = this.quote(primaryKey);
        return String.format("SELECT MAX(%s) FROM (SELECT %s FROM %s WHERE %s>=? ORDER BY %s LIMIT ?) t", quotedKey, quotedKey, this.decorate(schemaName, tableName), quotedKey, quotedKey);
    }
}

