/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.prepare.datasource;

import lombok.Generated;
import lombok.NonNull;
import org.apache.shardingsphere.data.pipeline.api.config.TableNameSchemaNameMapping;
import org.apache.shardingsphere.data.pipeline.api.config.rulealtered.RuleAlteredJobConfiguration;
import org.apache.shardingsphere.data.pipeline.api.config.rulealtered.TaskConfiguration;
import org.apache.shardingsphere.data.pipeline.api.datanode.JobDataNodeLine;
import org.apache.shardingsphere.data.pipeline.core.datasource.PipelineDataSourceManager;

public final class PrepareTargetTablesParameter {
    private final TaskConfiguration taskConfig;
    private final JobDataNodeLine tablesFirstDataNodes;
    private final PipelineDataSourceManager dataSourceManager;
    private final TableNameSchemaNameMapping tableNameSchemaNameMapping;

    public PrepareTargetTablesParameter(@NonNull TaskConfiguration taskConfig, @NonNull PipelineDataSourceManager dataSourceManager, TableNameSchemaNameMapping tableNameSchemaNameMapping) {
        if (taskConfig == null) {
            throw new NullPointerException("taskConfig is marked non-null but is null");
        }
        if (dataSourceManager == null) {
            throw new NullPointerException("dataSourceManager is marked non-null but is null");
        }
        this.taskConfig = taskConfig;
        this.tablesFirstDataNodes = JobDataNodeLine.unmarshal((String)taskConfig.getJobConfig().getTablesFirstDataNodes());
        this.dataSourceManager = dataSourceManager;
        this.tableNameSchemaNameMapping = tableNameSchemaNameMapping;
    }

    public RuleAlteredJobConfiguration getJobConfig() {
        return this.taskConfig.getJobConfig();
    }

    @Generated
    public TaskConfiguration getTaskConfig() {
        return this.taskConfig;
    }

    @Generated
    public JobDataNodeLine getTablesFirstDataNodes() {
        return this.tablesFirstDataNodes;
    }

    @Generated
    public PipelineDataSourceManager getDataSourceManager() {
        return this.dataSourceManager;
    }

    @Generated
    public TableNameSchemaNameMapping getTableNameSchemaNameMapping() {
        return this.tableNameSchemaNameMapping;
    }
}

