/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.prepare.datasource;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import lombok.Generated;
import lombok.NonNull;
import org.apache.shardingsphere.data.pipeline.api.config.rulealtered.RuleAlteredJobConfiguration;
import org.apache.shardingsphere.data.pipeline.api.config.rulealtered.TaskConfiguration;
import org.apache.shardingsphere.data.pipeline.api.datasource.PipelineDataSourceWrapper;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.PipelineDataSourceConfigurationFactory;
import org.apache.shardingsphere.data.pipeline.api.prepare.datasource.TableDefinitionSQLType;
import org.apache.shardingsphere.data.pipeline.core.datasource.PipelineDataSourceManager;
import org.apache.shardingsphere.data.pipeline.core.exception.PipelineJobPrepareFailedException;
import org.apache.shardingsphere.data.pipeline.core.prepare.datasource.DataSourcePreparer;
import org.apache.shardingsphere.data.pipeline.core.prepare.datasource.PrepareTargetSchemasParameter;
import org.apache.shardingsphere.data.pipeline.core.sqlbuilder.PipelineSQLBuilderFactory;
import org.apache.shardingsphere.data.pipeline.spi.sqlbuilder.PipelineSQLBuilder;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataSourcePreparer
implements DataSourcePreparer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractDataSourcePreparer.class);
    private static final Pattern PATTERN_CREATE_TABLE_IF_NOT_EXISTS = Pattern.compile("CREATE\\s+TABLE\\s+IF\\s+NOT\\s+EXISTS\\s+", 2);
    private static final Pattern PATTERN_CREATE_TABLE = Pattern.compile("CREATE\\s+TABLE\\s+", 2);
    private static final Pattern PATTERN_ALTER_TABLE = Pattern.compile("ALTER\\s+TABLE\\s+", 2);
    private static final Pattern PATTERN_CREATE_INDEX = Pattern.compile("CREATE\\s+(UNIQUE\\s+)?INDEX+\\s", 2);
    private static final Pattern PATTERN_DROP_INDEX = Pattern.compile("DROP\\s+INDEX+\\s", 2);
    private static final Pattern PATTERN_COMMENT_ON = Pattern.compile("COMMENT\\s+ON\\s+(COLUMN\\s+|TABLE\\s+)", 2);
    private static final String[] IGNORE_EXCEPTION_MESSAGE = new String[]{"multiple primary keys for table", "already exists"};

    @Override
    public void prepareTargetSchemas(PrepareTargetSchemasParameter parameter) {
        DatabaseType sourceDatabaseType = DatabaseTypeFactory.getInstance((String)parameter.getTaskConfig().getJobConfig().getSourceDatabaseType());
        DatabaseType targetDatabaseType = DatabaseTypeFactory.getInstance((String)parameter.getTaskConfig().getJobConfig().getTargetDatabaseType());
        if (!sourceDatabaseType.isSchemaAvailable() || !targetDatabaseType.isSchemaAvailable()) {
            log.info("prepareTargetSchemas, one of source or target database type schema is not available, ignore");
            return;
        }
        Set<String> schemaNames = this.getSchemaNames(parameter);
        String defaultSchema = DatabaseTypeEngine.getDefaultSchemaName((DatabaseType)targetDatabaseType, (String)parameter.getTaskConfig().getJobConfig().getDatabaseName());
        log.info("prepareTargetSchemas, schemaNames={}, defaultSchema={}", schemaNames, (Object)defaultSchema);
        PipelineSQLBuilder pipelineSQLBuilder = PipelineSQLBuilderFactory.getInstance(targetDatabaseType.getType());
        try (Connection targetConnection = this.getTargetCachedDataSource(parameter.getTaskConfig(), parameter.getDataSourceManager()).getConnection();){
            for (String each : schemaNames) {
                if (each.equalsIgnoreCase(defaultSchema)) continue;
                String sql = pipelineSQLBuilder.buildCreateSchemaSQL(each);
                log.info("prepareTargetSchemas, sql={}", (Object)sql);
                try {
                    Statement statement = targetConnection.createStatement();
                    try {
                        statement.execute(sql);
                    }
                    finally {
                        if (statement == null) continue;
                        statement.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        catch (SQLException ex) {
            throw new PipelineJobPrepareFailedException("Can not get connection.", ex);
        }
    }

    private Set<String> getSchemaNames(PrepareTargetSchemasParameter parameter) {
        HashSet<String> result = new HashSet<String>();
        for (String each : parameter.getTaskConfig().getJobConfig().splitLogicTableNames()) {
            String schemaName = parameter.getTableNameSchemaNameMapping().getSchemaName(each);
            if (null == schemaName) {
                throw new PipelineJobPrepareFailedException("Can not get schemaName by logic table name " + each);
            }
            result.add(schemaName);
        }
        return result;
    }

    protected final PipelineDataSourceWrapper getSourceCachedDataSource(RuleAlteredJobConfiguration jobConfig, PipelineDataSourceManager dataSourceManager) {
        return dataSourceManager.getDataSource(PipelineDataSourceConfigurationFactory.newInstance((String)jobConfig.getSource().getType(), (String)jobConfig.getSource().getParameter()));
    }

    protected final PipelineDataSourceWrapper getTargetCachedDataSource(TaskConfiguration taskConfig, PipelineDataSourceManager dataSourceManager) {
        return dataSourceManager.getDataSource(taskConfig.getImporterConfig().getDataSourceConfig());
    }

    protected final void executeTargetTableSQL(Connection targetConnection, String sql) throws SQLException {
        log.info("execute target table sql: {}", (Object)sql);
        try (Statement statement = targetConnection.createStatement();){
            statement.execute(sql);
        }
        catch (SQLException ex) {
            for (String ignoreMessage : IGNORE_EXCEPTION_MESSAGE) {
                if (!ex.getMessage().contains(ignoreMessage)) continue;
                return;
            }
            throw ex;
        }
    }

    protected final TableDefinitionSQLType getTableDefinitionSQLType(String sql) {
        if (PATTERN_CREATE_TABLE.matcher(sql).find()) {
            return TableDefinitionSQLType.CREATE_TABLE;
        }
        if (PATTERN_ALTER_TABLE.matcher(sql).find()) {
            return TableDefinitionSQLType.ALTER_TABLE;
        }
        if (PATTERN_CREATE_INDEX.matcher(sql).find()) {
            return TableDefinitionSQLType.CREATE_INDEX;
        }
        if (PATTERN_DROP_INDEX.matcher(sql).find()) {
            return TableDefinitionSQLType.DROP_INDEX;
        }
        if (PATTERN_COMMENT_ON.matcher(sql).find()) {
            return TableDefinitionSQLType.COMMENT_ON;
        }
        return TableDefinitionSQLType.UNKNOWN;
    }

    protected final String addIfNotExistsForCreateTableSQL(String createTableSQL) {
        if (PATTERN_CREATE_TABLE_IF_NOT_EXISTS.matcher(createTableSQL).find()) {
            return createTableSQL;
        }
        return PATTERN_CREATE_TABLE.matcher(createTableSQL).replaceFirst("CREATE TABLE IF NOT EXISTS ");
    }

    protected String replaceActualTableNameToLogicTableName(String createOrAlterTableSQL, @NonNull String actualTableName, @NonNull String logicTableName) {
        if (actualTableName == null) {
            throw new NullPointerException("actualTableName is marked non-null but is null");
        }
        if (logicTableName == null) {
            throw new NullPointerException("logicTableName is marked non-null but is null");
        }
        if (actualTableName.equalsIgnoreCase(logicTableName)) {
            return createOrAlterTableSQL;
        }
        StringBuilder logicalTableSQL = new StringBuilder(createOrAlterTableSQL);
        for (int i = 0; i < 10000; ++i) {
            int start = logicalTableSQL.indexOf(actualTableName);
            if (start <= 0) {
                return logicalTableSQL.toString();
            }
            int end = start + actualTableName.length();
            logicalTableSQL.replace(start, end, logicTableName);
        }
        log.error("replaceActualTableNameToLogicTableName, too many times loop, createOrAlterTableSQL={}, actualTableName={}, logicTableName={}", new Object[]{createOrAlterTableSQL, actualTableName, logicalTableSQL});
        throw new RuntimeException("Too many times loop");
    }
}

